/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.DoubleSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;
import org.apache.commons.lang3.mutable.MutableDouble;

public class DoubleType
extends NumberType<Double> {
    public static final DoubleType instance = new DoubleType();
    private static final ByteBuffer MASKED_VALUE = instance.decompose(0.0);

    DoubleType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean allowsEmpty() {
        return true;
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public boolean isFloatingPoint() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return DoubleType.compareComposed(left, accessorL, right, accessorR, this);
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        return ByteSource.optionalSignedFixedLengthFloat(accessor, data);
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        return ByteSourceInverse.getOptionalSignedFixedLengthFloat(accessor, comparableBytes, 8);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            return this.decompose(Double.valueOf(source));
        }
        catch (NumberFormatException e1) {
            throw new MarshalException(String.format("Unable to make double from '%s'", source), e1);
        }
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            if (parsed instanceof String) {
                return new Constants.Value(this.fromString((String)parsed));
            }
            return new Constants.Value(this.getSerializer().serialize(((Number)parsed).doubleValue()));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a double value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        Double value = this.getSerializer().deserialize(buffer);
        if (value == null) {
            return "\"\"";
        }
        if (value.isNaN() || value.isInfinite()) {
            return "null";
        }
        return value.toString();
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.DOUBLE;
    }

    @Override
    public TypeSerializer<Double> getSerializer() {
        return DoubleSerializer.instance;
    }

    @Override
    public ArgumentDeserializer getArgumentDeserializer() {
        return new NumberType.NumberArgumentDeserializer<MutableDouble>(new MutableDouble()){

            @Override
            protected void setMutableValue(MutableDouble mutable, ByteBuffer buffer) {
                mutable.setValue(ByteBufferUtil.toDouble(buffer));
            }
        };
    }

    @Override
    public int valueLengthIfFixed() {
        return 8;
    }

    @Override
    public ByteBuffer add(Number left, Number right) {
        return ByteBufferUtil.bytes(left.doubleValue() + right.doubleValue());
    }

    @Override
    public ByteBuffer substract(Number left, Number right) {
        return ByteBufferUtil.bytes(left.doubleValue() - right.doubleValue());
    }

    @Override
    public ByteBuffer multiply(Number left, Number right) {
        return ByteBufferUtil.bytes(left.doubleValue() * right.doubleValue());
    }

    @Override
    public ByteBuffer divide(Number left, Number right) {
        return ByteBufferUtil.bytes(left.doubleValue() / right.doubleValue());
    }

    @Override
    public ByteBuffer mod(Number left, Number right) {
        return ByteBufferUtil.bytes(left.doubleValue() % right.doubleValue());
    }

    @Override
    public ByteBuffer negate(Number input) {
        return ByteBufferUtil.bytes(-input.doubleValue());
    }

    @Override
    public ByteBuffer abs(Number input) {
        return ByteBufferUtil.bytes(Math.abs(input.doubleValue()));
    }

    @Override
    public ByteBuffer exp(Number input) {
        return ByteBufferUtil.bytes(Math.exp(input.doubleValue()));
    }

    @Override
    public ByteBuffer log(Number input) {
        return ByteBufferUtil.bytes(Math.log(input.doubleValue()));
    }

    @Override
    public ByteBuffer log10(Number input) {
        return ByteBufferUtil.bytes(Math.log10(input.doubleValue()));
    }

    @Override
    public ByteBuffer round(Number input) {
        return ByteBufferUtil.bytes((double)Math.round(input.doubleValue()));
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return MASKED_VALUE;
    }
}

