/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundaryMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.WrappingUnfilteredRowIterator;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.CloseableIterator;

public class ThrottledUnfilteredIterator
extends AbstractIterator<UnfilteredRowIterator>
implements CloseableIterator<UnfilteredRowIterator> {
    private final UnfilteredRowIterator origin;
    private final int throttle;
    private UnfilteredRowIterator throttledItr;
    private Iterator<Unfiltered> overflowed = Collections.emptyIterator();

    @VisibleForTesting
    ThrottledUnfilteredIterator(UnfilteredRowIterator origin, int throttle) {
        assert (origin != null);
        assert (throttle > 1) : "Throttle size must be higher than 1 to properly support open and close tombstone boundaries.";
        this.origin = origin;
        this.throttle = throttle;
        this.throttledItr = null;
    }

    @Override
    protected UnfilteredRowIterator computeNext() {
        while (this.throttledItr != null && this.throttledItr.hasNext()) {
            this.throttledItr.next();
        }
        if (!this.origin.hasNext()) {
            if (this.throttledItr != null) {
                return (UnfilteredRowIterator)this.endOfData();
            }
            this.throttledItr = this.origin;
            return this.throttledItr;
        }
        this.throttledItr = new WrappingUnfilteredRowIterator(){
            private int count = 0;
            private boolean isFirst;
            private RangeTombstoneMarker openMarker;
            private RangeTombstoneMarker closeMarker;
            {
                this.isFirst = ThrottledUnfilteredIterator.this.throttledItr == null;
                this.closeMarker = null;
            }

            @Override
            public UnfilteredRowIterator wrapped() {
                return ThrottledUnfilteredIterator.this.origin;
            }

            @Override
            public boolean hasNext() {
                return this.withinLimit() && ThrottledUnfilteredIterator.this.origin.hasNext() || this.closeMarker != null;
            }

            @Override
            public Unfiltered next() {
                if (this.closeMarker != null) {
                    assert (this.count == ThrottledUnfilteredIterator.this.throttle);
                    RangeTombstoneMarker toReturn = this.closeMarker;
                    this.closeMarker = null;
                    return toReturn;
                }
                assert (this.withinLimit());
                Unfiltered next = ThrottledUnfilteredIterator.this.overflowed.hasNext() ? ThrottledUnfilteredIterator.this.overflowed.next() : (Unfiltered)ThrottledUnfilteredIterator.this.origin.next();
                this.recordNext(next);
                return next;
            }

            private void recordNext(Unfiltered unfiltered) {
                ++this.count;
                if (unfiltered.isRangeTombstoneMarker()) {
                    this.updateMarker((RangeTombstoneMarker)unfiltered);
                }
                if (this.count == ThrottledUnfilteredIterator.this.throttle && this.openMarker != null) {
                    assert (ThrottledUnfilteredIterator.this.origin.hasNext());
                    this.closeOpenMarker((Unfiltered)ThrottledUnfilteredIterator.this.origin.next());
                }
            }

            private boolean withinLimit() {
                return this.count < ThrottledUnfilteredIterator.this.throttle;
            }

            private void updateMarker(RangeTombstoneMarker marker) {
                this.openMarker = marker.isOpen(this.isReverseOrder()) ? marker : null;
            }

            private void closeOpenMarker(Unfiltered next) {
                assert (this.openMarker != null);
                if (next.isRangeTombstoneMarker()) {
                    RangeTombstoneMarker marker = (RangeTombstoneMarker)next;
                    if (marker.isBoundary()) {
                        RangeTombstoneBoundaryMarker boundary = (RangeTombstoneBoundaryMarker)marker;
                        this.closeMarker = boundary.createCorrespondingCloseMarker(this.isReverseOrder());
                        ThrottledUnfilteredIterator.this.overflowed = Collections.singleton(boundary.createCorrespondingOpenMarker(this.isReverseOrder())).iterator();
                    } else {
                        assert (marker.isClose(this.isReverseOrder()));
                        this.updateMarker(marker);
                        this.closeMarker = marker;
                    }
                } else {
                    DeletionTime openDeletion = this.openMarker.openDeletionTime(this.isReverseOrder());
                    this.closeMarker = RangeTombstoneBoundMarker.exclusiveClose(this.isReverseOrder(), next.clustering(), openDeletion);
                    ThrottledUnfilteredIterator.this.overflowed = Arrays.asList(RangeTombstoneBoundMarker.inclusiveOpen(this.isReverseOrder(), next.clustering(), openDeletion), next).iterator();
                }
            }

            @Override
            public DeletionTime partitionLevelDeletion() {
                return this.isFirst ? ThrottledUnfilteredIterator.this.origin.partitionLevelDeletion() : DeletionTime.LIVE;
            }

            @Override
            public Row staticRow() {
                return this.isFirst ? ThrottledUnfilteredIterator.this.origin.staticRow() : Rows.EMPTY_STATIC_ROW;
            }

            @Override
            public void close() {
            }
        };
        return this.throttledItr;
    }

    @Override
    public void close() {
        if (this.origin != null) {
            this.origin.close();
        }
    }

    public static CloseableIterator<UnfilteredRowIterator> throttle(final UnfilteredPartitionIterator partitionIterator, final int maxBatchSize) {
        if (maxBatchSize == 0) {
            return partitionIterator;
        }
        return new AbstractIterator<UnfilteredRowIterator>(){
            ThrottledUnfilteredIterator current = null;

            @Override
            protected UnfilteredRowIterator computeNext() {
                if (this.current != null && !this.current.hasNext()) {
                    this.current.close();
                    this.current = null;
                }
                if (this.current == null && partitionIterator.hasNext()) {
                    this.current = new ThrottledUnfilteredIterator((UnfilteredRowIterator)partitionIterator.next(), maxBatchSize);
                }
                if (this.current != null && this.current.hasNext()) {
                    return (UnfilteredRowIterator)this.current.next();
                }
                return (UnfilteredRowIterator)this.endOfData();
            }

            @Override
            public void close() {
                if (this.current != null) {
                    this.current.close();
                }
            }
        };
    }
}

