/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.cassandra.db.streaming.CassandraStreamHeader;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.StreamManager;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamingDataOutputPlus;
import org.apache.cassandra.streaming.async.StreamCompressionSerializer;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.memory.BufferPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStreamWriter {
    private static final int DEFAULT_CHUNK_SIZE = 65536;
    private static final Logger logger = LoggerFactory.getLogger(CassandraStreamWriter.class);
    protected final SSTableReader sstable;
    private final LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();
    protected final Collection<SSTableReader.PartitionPositionBounds> sections;
    protected final StreamManager.StreamRateLimiter limiter;
    protected final StreamSession session;
    private final long totalSize;

    public CassandraStreamWriter(SSTableReader sstable, CassandraStreamHeader header, StreamSession session) {
        this.session = session;
        this.sstable = sstable;
        this.sections = header.sections;
        this.limiter = StreamManager.getRateLimiter(session.peer);
        this.totalSize = header.size();
    }

    public void write(StreamingDataOutputPlus out) throws IOException {
        long totalSize = this.totalSize();
        logger.debug("[Stream #{}] Start streaming file {} to {}, repairedAt = {}, totalSize = {}", new Object[]{this.session.planId(), this.sstable.getFilename(), this.session.peer, this.sstable.getSSTableMetadata().repairedAt, totalSize});
        try (ChannelProxy proxy = this.sstable.getDataChannel().newChannel();
             DataIntegrityMetadata.ChecksumValidator validator = this.sstable.maybeGetChecksumValidator();){
            int bufferSize = validator == null ? 65536 : validator.chunkSize;
            long progress = 0L;
            String filename = this.sstable.descriptor.fileFor(SSTableFormat.Components.DATA).toString();
            for (SSTableReader.PartitionPositionBounds section : this.sections) {
                long lastBytesRead;
                long start = validator == null ? section.lowerPosition : validator.chunkStart(section.lowerPosition);
                int transferOffset = (int)(section.lowerPosition - start);
                if (validator != null) {
                    validator.seek(start);
                }
                long length = section.upperPosition - start;
                for (long bytesRead = 0L; bytesRead < length; bytesRead += lastBytesRead) {
                    int toTransfer = (int)Math.min((long)bufferSize, length - bytesRead);
                    lastBytesRead = this.write(proxy, validator, out, start, transferOffset, toTransfer, bufferSize);
                    start += lastBytesRead;
                    long delta = lastBytesRead - (long)transferOffset;
                    this.session.progress(filename, ProgressInfo.Direction.OUT, progress += delta, delta, totalSize);
                    transferOffset = 0;
                }
                out.flush();
            }
            logger.debug("[Stream #{}] Finished streaming file {} to {}, bytesTransferred = {}, totalSize = {}", new Object[]{this.session.planId(), this.sstable.getFilename(), this.session.peer, FBUtilities.prettyPrintMemory(progress), FBUtilities.prettyPrintMemory(totalSize)});
        }
    }

    protected long totalSize() {
        return this.totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long write(ChannelProxy proxy, DataIntegrityMetadata.ChecksumValidator validator, StreamingDataOutputPlus output, long start, int transferOffset, int toTransfer, int bufferSize) throws IOException {
        int minReadable = (int)Math.min((long)bufferSize, proxy.size() - start);
        ByteBuffer buffer = BufferPools.forNetworking().get(minReadable, BufferType.OFF_HEAP);
        try {
            int readCount = proxy.read(buffer, start);
            assert (readCount == minReadable) : String.format("could not read required number of bytes from file to be streamed: read %d bytes, wanted %d bytes", readCount, minReadable);
            buffer.flip();
            if (validator != null) {
                validator.validate(buffer);
                buffer.flip();
            }
            buffer.position(transferOffset);
            buffer.limit(transferOffset + (toTransfer - transferOffset));
            output.writeToChannel(StreamCompressionSerializer.serialize(this.compressor, buffer, MessagingService.current_version), this.limiter);
        }
        finally {
            BufferPools.forNetworking().put(buffer);
        }
        return toTransfer;
    }
}

