/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.jmx.AuthorizationProxy;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractMutableVirtualTable;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.schema.TableMetadata;

final class JmxPermissionsCacheKeysTable
extends AbstractMutableVirtualTable {
    private static final String ROLE = "role";

    JmxPermissionsCacheKeysTable(String keyspace) {
        super(TableMetadata.builder(keyspace, "jmx_permissions_cache_keys").comment("keys in the JMX permissions cache").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(ROLE, UTF8Type.instance).build());
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        AuthorizationProxy.jmxPermissionsCache.getAll().forEach((roleResource, ignored) -> result.row(roleResource.getRoleName()));
        return result;
    }

    @Override
    protected void applyPartitionDeletion(AbstractMutableVirtualTable.ColumnValues partitionKey) {
        RoleResource roleResource = RoleResource.role((String)partitionKey.value(0));
        AuthorizationProxy.jmxPermissionsCache.invalidate(roleResource);
    }

    @Override
    public void truncate() {
        AuthorizationProxy.jmxPermissionsCache.invalidate();
    }
}

