/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.postings;

import java.io.IOException;
import org.apache.cassandra.index.sai.postings.OrdinalPostingList;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.lucene.util.FixedBitSet;

public class FilteringPostingList
implements PostingList {
    private final FixedBitSet filter;
    private final OrdinalPostingList delegate;
    private final int cardinality;
    private int position = 0;

    public FilteringPostingList(FixedBitSet filter, OrdinalPostingList delegate) {
        this.cardinality = filter.cardinality();
        this.filter = filter;
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public long nextPosting() throws IOException {
        long segmentRowId;
        do {
            if ((segmentRowId = this.delegate.nextPosting()) != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!this.filter.get(this.position++));
        return segmentRowId;
    }

    @Override
    public long size() {
        return this.cardinality;
    }

    @Override
    public long advance(long targetRowID) throws IOException {
        long segmentRowId = this.delegate.advance(targetRowID);
        if (segmentRowId == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        this.position = (int)this.delegate.getOrdinal();
        if (this.filter.get(this.position - 1)) {
            return segmentRowId;
        }
        return this.nextPosting();
    }
}

