/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.iterators;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;

public class KeyRangeUnionIterator
extends KeyRangeIterator {
    private final List<KeyRangeIterator> ranges;
    private final List<KeyRangeIterator> candidates;

    private KeyRangeUnionIterator(KeyRangeIterator.Builder.Statistics statistics, List<KeyRangeIterator> ranges, Runnable onClose) {
        super(statistics, onClose);
        this.ranges = ranges;
        this.candidates = new ArrayList<KeyRangeIterator>(ranges.size());
    }

    @Override
    public PrimaryKey computeNext() {
        this.candidates.clear();
        PrimaryKey candidateKey = null;
        for (KeyRangeIterator range : this.ranges) {
            if (!range.hasNext()) continue;
            if (candidateKey == null) {
                candidateKey = (PrimaryKey)range.peek();
                this.candidates.add(range);
                continue;
            }
            PrimaryKey peeked = (PrimaryKey)range.peek();
            int cmp = candidateKey.compareTo(peeked, false);
            if (cmp == 0) {
                if (peeked.kind() == PrimaryKey.Kind.STATIC) {
                    candidateKey = peeked;
                }
                this.candidates.add(range);
                continue;
            }
            if (cmp <= 0) continue;
            this.candidates.clear();
            candidateKey = peeked;
            this.candidates.add(range);
        }
        if (this.candidates.isEmpty()) {
            return (PrimaryKey)this.endOfData();
        }
        for (KeyRangeIterator candidate : this.candidates) {
            do {
                candidate.next();
            } while (candidate.hasNext() && ((PrimaryKey)candidate.peek()).compareTo(candidateKey, false) == 0);
        }
        return candidateKey;
    }

    @Override
    protected void performSkipTo(PrimaryKey nextKey) {
        for (KeyRangeIterator range : this.ranges) {
            if (!range.hasNext()) continue;
            range.skipTo(nextKey);
        }
    }

    @Override
    public void close() {
        super.close();
        FileUtils.closeQuietly(this.ranges);
    }

    public static Builder builder(int size) {
        return KeyRangeUnionIterator.builder(size, () -> {});
    }

    public static Builder builder(int size, Runnable onClose) {
        return new Builder(size, onClose);
    }

    public static KeyRangeIterator build(List<KeyRangeIterator> keys, Runnable onClose) {
        return new Builder(keys.size(), onClose).add(keys).build();
    }

    public static KeyRangeIterator build(List<KeyRangeIterator> keys) {
        return KeyRangeUnionIterator.build(keys, () -> {});
    }

    private static class UnionStatistics
    extends KeyRangeIterator.Builder.Statistics {
        private UnionStatistics() {
        }

        @Override
        public void update(KeyRangeIterator range) {
            this.min = KeyRangeIterator.nullSafeMin(this.min, range.getMinimum());
            this.max = KeyRangeIterator.nullSafeMax(this.max, range.getMaximum());
            this.count += range.getMaxKeys();
        }
    }

    @VisibleForTesting
    public static class Builder
    extends KeyRangeIterator.Builder {
        protected final List<KeyRangeIterator> rangeIterators;

        Builder(int size, Runnable onClose) {
            super(new UnionStatistics(), onClose);
            this.rangeIterators = new ArrayList<KeyRangeIterator>(size);
        }

        @Override
        public KeyRangeIterator.Builder add(KeyRangeIterator range) {
            if (range == null) {
                return this;
            }
            if (range.getMaxKeys() > 0L) {
                this.rangeIterators.add(range);
                this.statistics.update(range);
            } else {
                FileUtils.closeQuietly(range);
            }
            return this;
        }

        @Override
        public int rangeCount() {
            return this.rangeIterators.size();
        }

        @Override
        public void cleanup() {
            super.cleanup();
            FileUtils.closeQuietly(this.rangeIterators);
        }

        @Override
        protected KeyRangeIterator buildIterator() {
            if (this.rangeCount() == 1) {
                KeyRangeIterator single = this.rangeIterators.get(0);
                single.setOnClose(this.onClose);
                return single;
            }
            return new KeyRangeUnionIterator(this.statistics, this.rangeIterators, this.onClose);
        }
    }
}

