/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.index.sasi.SASIIndex;
import org.apache.cassandra.index.sasi.conf.ColumnIndex;
import org.apache.cassandra.index.sasi.disk.PerSSTableIndexWriter;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.sstable.KeyReader;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.TimeUUID;

class SASIIndexBuilder
extends SecondaryIndexBuilder {
    private final ColumnFamilyStore cfs;
    private final TimeUUID compactionId = TimeUUID.Generator.nextTimeUUID();
    private String targetDirectory;
    private final SortedMap<SSTableReader, Map<ColumnMetadata, ColumnIndex>> sstables;
    private long bytesProcessed = 0L;
    private final long totalBytesToProcess;

    public SASIIndexBuilder(ColumnFamilyStore cfs, SortedMap<SSTableReader, Map<ColumnMetadata, ColumnIndex>> sstables) {
        long totalBytesToProcess = 0L;
        for (SSTableReader sstable : sstables.keySet()) {
            totalBytesToProcess += sstable.uncompressedLength();
        }
        this.cfs = cfs;
        this.sstables = sstables;
        this.totalBytesToProcess = totalBytesToProcess;
    }

    @Override
    public void build() {
        AbstractType<?> keyValidator = this.cfs.metadata().partitionKeyType;
        long processedBytesInFinishedSSTables = 0L;
        for (Map.Entry<SSTableReader, Map<ColumnMetadata, ColumnIndex>> e : this.sstables.entrySet()) {
            SSTableReader sstable = e.getKey();
            Map<ColumnMetadata, ColumnIndex> indexes = e.getValue();
            RandomAccessReader dataFile = sstable.openDataReader();
            try {
                PerSSTableIndexWriter indexWriter = SASIIndex.newWriter(keyValidator, sstable.descriptor, indexes, OperationType.COMPACTION);
                this.targetDirectory = indexWriter.getDescriptor().directory.path();
                try (KeyReader keys = sstable.keyReader();){
                    while (!keys.isExhausted()) {
                        if (this.isStopRequested()) {
                            throw new CompactionInterruptedException(this.getCompactionInfo());
                        }
                        DecoratedKey key = sstable.decorateKey(keys.key());
                        long keyPosition = keys.keyPositionForSecondaryIndex();
                        indexWriter.startPartition(key, keys.dataPosition(), keyPosition);
                        dataFile.seek(keys.dataPosition());
                        ByteBufferUtil.readWithShortLength(dataFile);
                        try (SSTableIdentityIterator partition = SSTableIdentityIterator.create(sstable, dataFile, key);){
                            if (this.cfs.metadata().hasStaticColumns()) {
                                indexWriter.nextUnfilteredCluster(partition.staticRow());
                            }
                            while (partition.hasNext()) {
                                indexWriter.nextUnfilteredCluster(partition.next());
                            }
                        }
                        keys.advance();
                        long dataPosition = keys.isExhausted() ? sstable.uncompressedLength() : keys.dataPosition();
                        this.bytesProcessed = processedBytesInFinishedSSTables + dataPosition;
                    }
                    this.completeSSTable(indexWriter, sstable, indexes.values());
                }
                catch (IOException ex) {
                    throw new FSReadError((Throwable)ex, sstable.getFilename());
                }
                processedBytesInFinishedSSTables += sstable.uncompressedLength();
            }
            finally {
                if (dataFile == null) continue;
                dataFile.close();
            }
        }
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.cfs.metadata(), OperationType.INDEX_BUILD, this.bytesProcessed, this.totalBytesToProcess, this.compactionId, this.sstables.keySet(), this.targetDirectory);
    }

    private void completeSSTable(PerSSTableIndexWriter indexWriter, SSTableReader sstable, Collection<ColumnIndex> indexes) {
        indexWriter.complete();
        for (ColumnIndex index : indexes) {
            File tmpIndex = sstable.descriptor.fileFor(index.getComponent());
            if (!tmpIndex.exists()) continue;
            index.update(Collections.emptyList(), Collections.singletonList(sstable));
        }
    }
}

