/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.KeyReader;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.CloseableIterator;

public class KeyIterator
extends AbstractIterator<DecoratedKey>
implements CloseableIterator<DecoratedKey> {
    private final IPartitioner partitioner;
    private final KeyReader it;
    private final ReadWriteLock fileAccessLock;
    private final long totalBytes;
    private boolean initialized = false;

    public KeyIterator(KeyReader it, IPartitioner partitioner, long totalBytes, ReadWriteLock fileAccessLock) {
        this.it = it;
        this.partitioner = partitioner;
        this.totalBytes = totalBytes;
        this.fileAccessLock = fileAccessLock;
    }

    @Override
    protected DecoratedKey computeNext() {
        if (this.fileAccessLock != null) {
            this.fileAccessLock.readLock().lock();
        }
        try {
            if (!this.initialized) {
                this.initialized = true;
                DecoratedKey decoratedKey = this.it.isExhausted() ? (DecoratedKey)this.endOfData() : this.partitioner.decorateKey(this.it.key());
                return decoratedKey;
            }
            DecoratedKey decoratedKey = this.it.advance() ? this.partitioner.decorateKey(this.it.key()) : (DecoratedKey)this.endOfData();
            return decoratedKey;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.fileAccessLock != null) {
                this.fileAccessLock.readLock().unlock();
            }
        }
    }

    @Override
    public void close() {
        if (this.fileAccessLock != null) {
            this.fileAccessLock.writeLock().lock();
        }
        try {
            this.it.close();
        }
        finally {
            if (this.fileAccessLock != null) {
                this.fileAccessLock.writeLock().unlock();
            }
        }
    }

    public long getBytesRead() {
        if (this.fileAccessLock != null) {
            this.fileAccessLock.readLock().lock();
        }
        try {
            long l = this.it.isExhausted() ? this.totalBytes : this.it.dataPosition();
            return l;
        }
        finally {
            if (this.fileAccessLock != null) {
                this.fileAccessLock.readLock().unlock();
            }
        }
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }
}

