/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReadsListener;
import org.apache.cassandra.io.sstable.filter.BloomFilterTracker;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.concurrent.SharedCloseable;

public abstract class SSTableReaderWithFilter
extends SSTableReader {
    private final IFilter filter;
    private final BloomFilterTracker filterTracker;

    protected SSTableReaderWithFilter(Builder<?, ?> builder, SSTable.Owner owner) {
        super((SSTableReader.Builder<?, ?>)builder, owner);
        this.filter = Objects.requireNonNull(builder.getFilter());
        this.filterTracker = new BloomFilterTracker();
    }

    @Override
    protected List<AutoCloseable> setupInstance(boolean trackHotness) {
        ArrayList closeables = Lists.newArrayList((Object[])new AutoCloseable[]{this.filter});
        closeables.addAll(super.setupInstance(trackHotness));
        return closeables;
    }

    @Override
    protected final <B extends Builder<?, B>> B unbuildTo(B builder, boolean sharedCopy) {
        B b = super.unbuildTo(builder, sharedCopy);
        if (builder.getFilter() == null) {
            b.setFilter(sharedCopy ? SharedCloseable.sharedCopyOrNull(this.filter) : this.filter);
        }
        return b;
    }

    protected boolean isPresentInFilter(IFilter.FilterKey key) {
        return this.filter.isPresent(key);
    }

    @Override
    public boolean mayContainAssumingKeyIsInRange(DecoratedKey key) {
        return !this.filter.isInformative() && this.getPosition((PartitionPosition)key, SSTableReader.Operator.EQ, false) >= 0L || this.filter.isPresent(key);
    }

    @Override
    protected void notifySelected(SSTableReadsListener.SelectionReason reason, SSTableReadsListener localListener, SSTableReader.Operator op, boolean updateStats, AbstractRowIndexEntry entry) {
        super.notifySelected(reason, localListener, op, updateStats, entry);
        if (!updateStats || op != SSTableReader.Operator.EQ) {
            return;
        }
        this.filterTracker.addTruePositive();
    }

    @Override
    protected void notifySkipped(SSTableReadsListener.SkippingReason reason, SSTableReadsListener localListener, SSTableReader.Operator op, boolean updateStats) {
        super.notifySkipped(reason, localListener, op, updateStats);
        if (!updateStats) {
            return;
        }
        switch (reason) {
            case BLOOM_FILTER: {
                this.filterTracker.addTrueNegative();
                break;
            }
            case MIN_MAX_KEYS: {
                break;
            }
            default: {
                if (op != SSTableReader.Operator.EQ) break;
                this.filterTracker.addFalsePositive();
            }
        }
    }

    public BloomFilterTracker getFilterTracker() {
        return this.filterTracker;
    }

    public long getFilterSerializedSize() {
        return this.filter.serializedSize(this.descriptor.version.hasOldBfFormat());
    }

    public long getFilterOffHeapSize() {
        return this.filter.offHeapSize();
    }

    public abstract SSTableReaderWithFilter cloneAndReplace(IFilter var1);

    public static abstract class Builder<R extends SSTableReaderWithFilter, B extends Builder<R, B>>
    extends SSTableReader.Builder<R, B> {
        private IFilter filter;

        public Builder(Descriptor descriptor) {
            super(descriptor);
        }

        public B setFilter(IFilter filter) {
            this.filter = filter;
            return (B)this;
        }

        public IFilter getFilter() {
            return this.filter;
        }
    }
}

