/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.metadata;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.db.BufferClusteringBound;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.commitlog.IntervalSet;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataComponentSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.serializers.AbstractTypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.UUIDSerializer;
import org.apache.cassandra.utils.streamhist.TombstoneHistogram;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsMetadata
extends MetadataComponent {
    public static final IMetadataComponentSerializer serializer = new StatsMetadataSerializer();
    public static final ISerializer<IntervalSet<CommitLogPosition>> commitLogPositionSetSerializer = IntervalSet.serializer(CommitLogPosition.serializer);
    public final EstimatedHistogram estimatedPartitionSize;
    public final EstimatedHistogram estimatedCellPerPartitionCount;
    public final IntervalSet<CommitLogPosition> commitLogIntervals;
    public final long minTimestamp;
    public final long maxTimestamp;
    public final long minLocalDeletionTime;
    public final long maxLocalDeletionTime;
    public final int minTTL;
    public final int maxTTL;
    public final double compressionRatio;
    public final TombstoneHistogram estimatedTombstoneDropTime;
    public final int sstableLevel;
    public final Slice coveredClustering;
    public final boolean hasLegacyCounterShards;
    public final double tokenSpaceCoverage;
    public final long repairedAt;
    public final long totalColumnsSet;
    public final long totalRows;
    public final UUID originatingHostId;
    public final TimeUUID pendingRepair;
    public final boolean isTransient;
    public final EncodingStats encodingStats;
    private final List<AbstractType<?>> clusteringTypes;
    public final boolean hasPartitionLevelDeletions;
    public final ByteBuffer firstKey;
    public final ByteBuffer lastKey;

    public StatsMetadata(EstimatedHistogram estimatedPartitionSize, EstimatedHistogram estimatedCellPerPartitionCount, IntervalSet<CommitLogPosition> commitLogIntervals, long minTimestamp, long maxTimestamp, long minLocalDeletionTime, long maxLocalDeletionTime, int minTTL, int maxTTL, double compressionRatio, TombstoneHistogram estimatedTombstoneDropTime, int sstableLevel, List<AbstractType<?>> clusteringTypes, Slice coveredClustering, boolean hasLegacyCounterShards, long repairedAt, long totalColumnsSet, long totalRows, double tokenSpaceCoverage, UUID originatingHostId, TimeUUID pendingRepair, boolean isTransient, boolean hasPartitionLevelDeletions, ByteBuffer firstKey, ByteBuffer lastKey) {
        this.estimatedPartitionSize = estimatedPartitionSize;
        this.estimatedCellPerPartitionCount = estimatedCellPerPartitionCount;
        this.commitLogIntervals = commitLogIntervals;
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.minLocalDeletionTime = minLocalDeletionTime;
        this.maxLocalDeletionTime = maxLocalDeletionTime;
        this.minTTL = minTTL;
        this.maxTTL = maxTTL;
        this.compressionRatio = compressionRatio;
        this.estimatedTombstoneDropTime = estimatedTombstoneDropTime;
        this.sstableLevel = sstableLevel;
        this.clusteringTypes = clusteringTypes;
        this.coveredClustering = coveredClustering;
        this.hasLegacyCounterShards = hasLegacyCounterShards;
        this.repairedAt = repairedAt;
        this.totalColumnsSet = totalColumnsSet;
        this.totalRows = totalRows;
        this.tokenSpaceCoverage = tokenSpaceCoverage;
        this.originatingHostId = originatingHostId;
        this.pendingRepair = pendingRepair;
        this.isTransient = isTransient;
        this.encodingStats = new EncodingStats(minTimestamp, minLocalDeletionTime, minTTL);
        this.hasPartitionLevelDeletions = hasPartitionLevelDeletions;
        this.firstKey = firstKey;
        this.lastKey = lastKey;
    }

    @Override
    public MetadataType getType() {
        return MetadataType.STATS;
    }

    public double getEstimatedDroppableTombstoneRatio(long gcBefore) {
        long estimatedColumnCount = this.estimatedCellPerPartitionCount.mean() * this.estimatedCellPerPartitionCount.count();
        if (estimatedColumnCount > 0L) {
            double droppable = this.getDroppableTombstonesBefore(gcBefore);
            return droppable / (double)estimatedColumnCount;
        }
        return 0.0;
    }

    public double getDroppableTombstonesBefore(long gcBefore) {
        return this.estimatedTombstoneDropTime.sum(gcBefore);
    }

    public StatsMetadata mutateLevel(int newLevel) {
        return new StatsMetadata(this.estimatedPartitionSize, this.estimatedCellPerPartitionCount, this.commitLogIntervals, this.minTimestamp, this.maxTimestamp, this.minLocalDeletionTime, this.maxLocalDeletionTime, this.minTTL, this.maxTTL, this.compressionRatio, this.estimatedTombstoneDropTime, newLevel, this.clusteringTypes, this.coveredClustering, this.hasLegacyCounterShards, this.repairedAt, this.totalColumnsSet, this.totalRows, this.tokenSpaceCoverage, this.originatingHostId, this.pendingRepair, this.isTransient, this.hasPartitionLevelDeletions, this.firstKey, this.lastKey);
    }

    public StatsMetadata mutateRepairedMetadata(long newRepairedAt, TimeUUID newPendingRepair, boolean newIsTransient) {
        return new StatsMetadata(this.estimatedPartitionSize, this.estimatedCellPerPartitionCount, this.commitLogIntervals, this.minTimestamp, this.maxTimestamp, this.minLocalDeletionTime, this.maxLocalDeletionTime, this.minTTL, this.maxTTL, this.compressionRatio, this.estimatedTombstoneDropTime, this.sstableLevel, this.clusteringTypes, this.coveredClustering, this.hasLegacyCounterShards, newRepairedAt, this.totalColumnsSet, this.totalRows, this.tokenSpaceCoverage, this.originatingHostId, newPendingRepair, newIsTransient, this.hasPartitionLevelDeletions, this.firstKey, this.lastKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatsMetadata that = (StatsMetadata)o;
        return new EqualsBuilder().append((Object)this.estimatedPartitionSize, (Object)that.estimatedPartitionSize).append((Object)this.estimatedCellPerPartitionCount, (Object)that.estimatedCellPerPartitionCount).append(this.commitLogIntervals, that.commitLogIntervals).append(this.minTimestamp, that.minTimestamp).append(this.maxTimestamp, that.maxTimestamp).append(this.minLocalDeletionTime, that.minLocalDeletionTime).append(this.maxLocalDeletionTime, that.maxLocalDeletionTime).append(this.minTTL, that.minTTL).append(this.maxTTL, that.maxTTL).append(this.compressionRatio, that.compressionRatio).append((Object)this.estimatedTombstoneDropTime, (Object)that.estimatedTombstoneDropTime).append(this.sstableLevel, that.sstableLevel).append(this.repairedAt, that.repairedAt).append((Object)this.coveredClustering, (Object)that.coveredClustering).append(this.hasLegacyCounterShards, that.hasLegacyCounterShards).append(this.totalColumnsSet, that.totalColumnsSet).append(this.totalRows, that.totalRows).append(this.tokenSpaceCoverage, that.tokenSpaceCoverage).append((Object)this.originatingHostId, (Object)that.originatingHostId).append((Object)this.pendingRepair, (Object)that.pendingRepair).append(this.hasPartitionLevelDeletions, that.hasPartitionLevelDeletions).append((Object)this.firstKey, (Object)that.firstKey).append((Object)this.lastKey, (Object)that.lastKey).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.estimatedPartitionSize).append((Object)this.estimatedCellPerPartitionCount).append(this.commitLogIntervals).append(this.minTimestamp).append(this.maxTimestamp).append(this.minLocalDeletionTime).append(this.maxLocalDeletionTime).append(this.minTTL).append(this.maxTTL).append(this.compressionRatio).append((Object)this.estimatedTombstoneDropTime).append(this.sstableLevel).append(this.repairedAt).append((Object)this.coveredClustering).append(this.hasLegacyCounterShards).append(this.totalColumnsSet).append(this.totalRows).append(this.tokenSpaceCoverage).append((Object)this.originatingHostId).append((Object)this.pendingRepair).append(this.hasPartitionLevelDeletions).append((Object)this.firstKey).append((Object)this.lastKey).build();
    }

    public static class StatsMetadataSerializer
    implements IMetadataComponentSerializer<StatsMetadata> {
        private static final Logger logger = LoggerFactory.getLogger(StatsMetadataSerializer.class);
        private final AbstractTypeSerializer typeSerializer = new AbstractTypeSerializer();

        @Override
        public int serializedSize(Version version, StatsMetadata component) throws IOException {
            int size = 0;
            size = (int)((long)size + EstimatedHistogram.serializer.serializedSize(component.estimatedPartitionSize));
            size = (int)((long)size + EstimatedHistogram.serializer.serializedSize(component.estimatedCellPerPartitionCount));
            size = (int)((long)size + CommitLogPosition.serializer.serializedSize(component.commitLogIntervals.upperBound().orElse(CommitLogPosition.NONE)));
            size += 16;
            size += 8;
            size += 24;
            size = (int)((long)size + TombstoneHistogram.getSerializer(version).serializedSize(component.estimatedTombstoneDropTime));
            size += TypeSizes.sizeof(component.sstableLevel);
            if (version.hasLegacyMinMax()) {
                size += 4;
                ClusteringBound<?> minClusteringValues = component.coveredClustering.start();
                size += minClusteringValues.size() * 2 + minClusteringValues.dataSize();
                size += 4;
                ClusteringBound<?> maxClusteringValues = component.coveredClustering.end();
                size += maxClusteringValues.size() * 2 + maxClusteringValues.dataSize();
            } else if (version.hasImprovedMinMax()) {
                size = this.improvedMinMaxSize(version, component, size);
            }
            size += TypeSizes.sizeof(component.hasLegacyCounterShards);
            size += 16;
            if (version.hasCommitLogLowerBound()) {
                size = (int)((long)size + CommitLogPosition.serializer.serializedSize(component.commitLogIntervals.lowerBound().orElse(CommitLogPosition.NONE)));
            }
            if (version.hasCommitLogIntervals()) {
                size = (int)((long)size + commitLogPositionSetSerializer.serializedSize(component.commitLogIntervals));
            }
            if (version.hasPendingRepair()) {
                ++size;
                if (component.pendingRepair != null) {
                    size = (int)((long)size + TimeUUID.sizeInBytes());
                }
            }
            if (version.hasIsTransient()) {
                size += TypeSizes.sizeof(component.isTransient);
            }
            if (version.hasOriginatingHostId()) {
                ++size;
                if (component.originatingHostId != null) {
                    size = (int)((long)size + UUIDSerializer.serializer.serializedSize(component.originatingHostId, version.correspondingMessagingVersion()));
                }
            }
            if (version.hasPartitionLevelDeletionsPresenceMarker()) {
                size += TypeSizes.sizeof(component.hasPartitionLevelDeletions);
            }
            if (version.hasImprovedMinMax() && version.hasLegacyMinMax()) {
                size = this.improvedMinMaxSize(version, component, size);
            }
            if (version.hasKeyRange()) {
                size += ByteBufferUtil.serializedSizeWithVIntLength(component.firstKey);
                size += ByteBufferUtil.serializedSizeWithVIntLength(component.lastKey);
            }
            if (version.hasTokenSpaceCoverage()) {
                size += 8;
            }
            return size;
        }

        private int improvedMinMaxSize(Version version, StatsMetadata component, int size) {
            size = (int)((long)size + this.typeSerializer.serializedListSize(component.clusteringTypes));
            size = (int)((long)size + Slice.serializer.serializedSize(component.coveredClustering, version.correspondingMessagingVersion(), component.clusteringTypes));
            return size;
        }

        @Override
        public void serialize(Version version, StatsMetadata component, DataOutputPlus out) throws IOException {
            EstimatedHistogram.serializer.serialize(component.estimatedPartitionSize, out);
            EstimatedHistogram.serializer.serialize(component.estimatedCellPerPartitionCount, out);
            CommitLogPosition.serializer.serialize(component.commitLogIntervals.upperBound().orElse(CommitLogPosition.NONE), out);
            out.writeLong(component.minTimestamp);
            out.writeLong(component.maxTimestamp);
            if (version.hasUIntDeletionTime()) {
                out.writeInt(Cell.deletionTimeLongToUnsignedInteger(component.minLocalDeletionTime));
                out.writeInt(Cell.deletionTimeLongToUnsignedInteger(component.maxLocalDeletionTime));
            } else {
                int mld = component.minLocalDeletionTime == Long.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.min(component.minLocalDeletionTime, 0x7FFFFFFEL);
                out.writeInt(mld);
                mld = component.maxLocalDeletionTime == Long.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.min(component.maxLocalDeletionTime, 0x7FFFFFFEL);
                out.writeInt(mld);
            }
            out.writeInt(component.minTTL);
            out.writeInt(component.maxTTL);
            out.writeDouble(component.compressionRatio);
            TombstoneHistogram.getSerializer(version).serialize(component.estimatedTombstoneDropTime, out);
            out.writeInt(component.sstableLevel);
            out.writeLong(component.repairedAt);
            if (version.hasLegacyMinMax()) {
                ClusteringBound<?> minClusteringValues = component.coveredClustering.start();
                out.writeInt(this.countUntilNull(minClusteringValues.getBufferArray()));
                for (ByteBuffer value : minClusteringValues.getBufferArray()) {
                    if (value == null) break;
                    ByteBufferUtil.writeWithShortLength(value, out);
                }
                ClusteringBound<?> maxClusteringValues = component.coveredClustering.end();
                out.writeInt(this.countUntilNull(maxClusteringValues.getBufferArray()));
                for (ByteBuffer value : maxClusteringValues.getBufferArray()) {
                    if (value == null) break;
                    ByteBufferUtil.writeWithShortLength(value, out);
                }
            } else if (version.hasImprovedMinMax()) {
                this.serializeImprovedMinMax(version, component, out);
            }
            out.writeBoolean(component.hasLegacyCounterShards);
            out.writeLong(component.totalColumnsSet);
            out.writeLong(component.totalRows);
            if (version.hasCommitLogLowerBound()) {
                CommitLogPosition.serializer.serialize(component.commitLogIntervals.lowerBound().orElse(CommitLogPosition.NONE), out);
            }
            if (version.hasCommitLogIntervals()) {
                commitLogPositionSetSerializer.serialize(component.commitLogIntervals, out);
            }
            if (version.hasPendingRepair()) {
                if (component.pendingRepair != null) {
                    out.writeByte(1);
                    component.pendingRepair.serialize(out);
                } else {
                    out.writeByte(0);
                }
            }
            if (version.hasIsTransient()) {
                out.writeBoolean(component.isTransient);
            }
            if (version.hasOriginatingHostId()) {
                if (component.originatingHostId != null) {
                    out.writeByte(1);
                    UUIDSerializer.serializer.serialize(component.originatingHostId, out, 0);
                } else {
                    out.writeByte(0);
                }
            }
            if (version.hasPartitionLevelDeletionsPresenceMarker()) {
                out.writeBoolean(component.hasPartitionLevelDeletions);
            }
            if (version.hasImprovedMinMax() && version.hasLegacyMinMax()) {
                this.serializeImprovedMinMax(version, component, out);
            }
            if (version.hasKeyRange()) {
                ByteBufferUtil.writeWithVIntLength(component.firstKey, out);
                ByteBufferUtil.writeWithVIntLength(component.lastKey, out);
            }
            if (version.hasTokenSpaceCoverage()) {
                out.writeDouble(component.tokenSpaceCoverage);
            }
        }

        private void serializeImprovedMinMax(Version version, StatsMetadata component, DataOutputPlus out) throws IOException {
            assert (component.clusteringTypes != null);
            this.typeSerializer.serializeList(component.clusteringTypes, out);
            Slice.serializer.serialize(component.coveredClustering, out, version.correspondingMessagingVersion(), component.clusteringTypes);
        }

        @Override
        public StatsMetadata deserialize(Version version, DataInputPlus in) throws IOException {
            boolean hasPartitionLevelDeletions;
            long maxLocalDeletionTime;
            long minLocalDeletionTime;
            EstimatedHistogram columnCounts;
            EstimatedHistogram partitionSizes = EstimatedHistogram.serializer.deserialize(in);
            if (partitionSizes.isOverflowed()) {
                logger.warn("Deserialized partition size histogram with {} values greater than the maximum of {}. Clearing the overflow bucket to allow for degraded mean and percentile calculations...", (Object)partitionSizes.overflowCount(), (Object)partitionSizes.getLargestBucketOffset());
                partitionSizes.clearOverflow();
            }
            if ((columnCounts = EstimatedHistogram.serializer.deserialize(in)).isOverflowed()) {
                logger.warn("Deserialized partition cell count histogram with {} values greater than the maximum of {}. Clearing the overflow bucket to allow for degraded mean and percentile calculations...", (Object)columnCounts.overflowCount(), (Object)columnCounts.getLargestBucketOffset());
                columnCounts.clearOverflow();
            }
            CommitLogPosition commitLogLowerBound = CommitLogPosition.NONE;
            CommitLogPosition commitLogUpperBound = CommitLogPosition.serializer.deserialize(in);
            long minTimestamp = in.readLong();
            long maxTimestamp = in.readLong();
            if (version.hasUIntDeletionTime()) {
                minLocalDeletionTime = Cell.deletionTimeUnsignedIntegerToLong(in.readInt());
                maxLocalDeletionTime = Cell.deletionTimeUnsignedIntegerToLong(in.readInt());
            } else {
                minLocalDeletionTime = in.readInt();
                if (minLocalDeletionTime == Integer.MAX_VALUE) {
                    minLocalDeletionTime = Long.MAX_VALUE;
                }
                if ((maxLocalDeletionTime = (long)in.readInt()) == Integer.MAX_VALUE) {
                    maxLocalDeletionTime = Long.MAX_VALUE;
                }
            }
            int minTTL = in.readInt();
            int maxTTL = in.readInt();
            double compressionRatio = in.readDouble();
            TombstoneHistogram tombstoneHistogram = TombstoneHistogram.getSerializer(version).deserialize(in);
            int sstableLevel = in.readInt();
            long repairedAt = in.readLong();
            List<AbstractType<?>> clusteringTypes = null;
            Slice coveredClustering = Slice.ALL;
            if (version.hasLegacyMinMax()) {
                int colCount = in.readInt();
                ByteBuffer[] minClusteringValues = new ByteBuffer[colCount];
                for (int i = 0; i < colCount; ++i) {
                    minClusteringValues[i] = ByteBufferUtil.readWithShortLength(in);
                }
                colCount = in.readInt();
                ByteBuffer[] maxClusteringValues = new ByteBuffer[colCount];
                for (int i = 0; i < colCount; ++i) {
                    maxClusteringValues[i] = ByteBufferUtil.readWithShortLength(in);
                }
                if (version.hasAccurateMinMax()) {
                    coveredClustering = Slice.make(BufferClusteringBound.inclusiveStartOf(minClusteringValues), BufferClusteringBound.inclusiveEndOf(maxClusteringValues));
                }
            } else if (version.hasImprovedMinMax()) {
                clusteringTypes = this.typeSerializer.deserializeList(in);
                coveredClustering = Slice.serializer.deserialize(in, version.correspondingMessagingVersion(), clusteringTypes);
            }
            boolean hasLegacyCounterShards = in.readBoolean();
            long totalColumnsSet = in.readLong();
            long totalRows = in.readLong();
            if (version.hasCommitLogLowerBound()) {
                commitLogLowerBound = CommitLogPosition.serializer.deserialize(in);
            }
            IntervalSet<CommitLogPosition> commitLogIntervals = version.hasCommitLogIntervals() ? commitLogPositionSetSerializer.deserialize(in) : new IntervalSet<CommitLogPosition>(commitLogLowerBound, commitLogUpperBound);
            TimeUUID pendingRepair = null;
            if (version.hasPendingRepair() && in.readByte() != 0) {
                pendingRepair = TimeUUID.deserialize(in);
            }
            boolean isTransient = version.hasIsTransient() && in.readBoolean();
            UUID originatingHostId = null;
            if (version.hasOriginatingHostId() && in.readByte() != 0) {
                originatingHostId = UUIDSerializer.serializer.deserialize(in, 0);
            }
            boolean bl = hasPartitionLevelDeletions = minLocalDeletionTime != Long.MAX_VALUE;
            if (version.hasPartitionLevelDeletionsPresenceMarker()) {
                hasPartitionLevelDeletions = in.readBoolean();
            }
            if (version.hasImprovedMinMax() && version.hasLegacyMinMax()) {
                clusteringTypes = this.typeSerializer.deserializeList(in);
                coveredClustering = Slice.serializer.deserialize(in, version.correspondingMessagingVersion(), clusteringTypes);
            }
            ByteBuffer firstKey = null;
            ByteBuffer lastKey = null;
            if (version.hasKeyRange()) {
                firstKey = ByteBufferUtil.readWithVIntLength(in);
                lastKey = ByteBufferUtil.readWithVIntLength(in);
            }
            double tokenSpaceCoverage = Double.NaN;
            if (version.hasTokenSpaceCoverage()) {
                tokenSpaceCoverage = in.readDouble();
            }
            return new StatsMetadata(partitionSizes, columnCounts, commitLogIntervals, minTimestamp, maxTimestamp, minLocalDeletionTime, maxLocalDeletionTime, minTTL, maxTTL, compressionRatio, tombstoneHistogram, sstableLevel, clusteringTypes, coveredClustering, hasLegacyCounterShards, repairedAt, totalColumnsSet, totalRows, tokenSpaceCoverage, originatingHostId, pendingRepair, isTransient, hasPartitionLevelDeletions, firstKey, lastKey);
        }

        private int countUntilNull(ByteBuffer[] bufferArray) {
            int i = ArrayUtils.indexOf((Object[])bufferArray, null);
            return i < 0 ? bufferArray.length : i;
        }
    }
}

