/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.cassandra.locator.AbstractCloudMetadataServiceConnector;
import org.apache.cassandra.locator.AbstractCloudMetadataServiceSnitch;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.utils.JsonUtils;
import org.apache.cassandra.utils.Pair;

public class AzureSnitch
extends AbstractCloudMetadataServiceSnitch {
    static final String DEFAULT_METADATA_SERVICE_URL = "http://169.254.169.254";
    static final String METADATA_QUERY_TEMPLATE = "/metadata/instance/compute?api-version=%s&format=json";
    static final String METADATA_HEADER = "Metadata";
    static final String API_VERSION_PROPERTY_KEY = "azure_api_version";
    static final String DEFAULT_API_VERSION = "2021-12-13";

    public AzureSnitch() throws IOException {
        this(new SnitchProperties());
    }

    public AzureSnitch(SnitchProperties properties) throws IOException {
        this(new AbstractCloudMetadataServiceConnector.DefaultCloudMetadataServiceConnector(properties.putIfAbsent("metadata_url", DEFAULT_METADATA_SERVICE_URL)));
    }

    public AzureSnitch(AbstractCloudMetadataServiceConnector connector) throws IOException {
        super(connector, AzureSnitch.resolveDcAndRack(connector));
    }

    private static Pair<String, String> resolveDcAndRack(AbstractCloudMetadataServiceConnector connector) throws IOException {
        String apiVersion = connector.getProperties().get(API_VERSION_PROPERTY_KEY, DEFAULT_API_VERSION);
        String response = connector.apiCall(String.format(METADATA_QUERY_TEMPLATE, apiVersion), (Map<String, String>)ImmutableMap.of((Object)METADATA_HEADER, (Object)"true"));
        JsonNode jsonNode = JsonUtils.JSON_OBJECT_MAPPER.readTree(response);
        JsonNode location = jsonNode.get("location");
        JsonNode zone = jsonNode.get("zone");
        JsonNode platformFaultDomain = jsonNode.get("platformFaultDomain");
        String datacenter = location == null || location.isNull() || location.asText().isEmpty() ? "UNKNOWN-DC" : location.asText();
        String rack = zone == null || zone.isNull() || zone.asText().isEmpty() ? (platformFaultDomain == null || platformFaultDomain.isNull() || platformFaultDomain.asText().isEmpty() ? "UNKNOWN-RACK" : platformFaultDomain.asText()) : zone.asText();
        return Pair.create(datacenter + connector.getProperties().getDcSuffix(), "rack-" + rack);
    }
}

