/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.zip.CRC32;
import org.apache.cassandra.net.BufferPoolAllocator;
import org.apache.cassandra.net.Crc;
import org.apache.cassandra.net.FrameDecoder;
import org.apache.cassandra.net.FrameDecoderWith8bHeader;
import org.apache.cassandra.net.ShareableBytes;

public final class FrameDecoderCrc
extends FrameDecoderWith8bHeader {
    static final int HEADER_LENGTH = 6;
    private static final int TRAILER_LENGTH = 4;
    private static final int HEADER_AND_TRAILER_LENGTH = 10;

    public FrameDecoderCrc(BufferPoolAllocator allocator) {
        super(allocator);
    }

    public static FrameDecoderCrc create(BufferPoolAllocator allocator) {
        return new FrameDecoderCrc(allocator);
    }

    static boolean isSelfContained(long header6b) {
        return 0L != (header6b & 0x20000L);
    }

    static int payloadLength(long header6b) {
        return (int)header6b & 0x1FFFF;
    }

    private static int headerCrc(long header6b) {
        return (int)(header6b >>> 24) & 0xFFFFFF;
    }

    static long readHeader6b(ByteBuffer frame, int begin) {
        long header6b;
        if (frame.limit() - begin >= 8) {
            header6b = frame.getLong(begin);
            if (frame.order() == ByteOrder.BIG_ENDIAN) {
                header6b = Long.reverseBytes(header6b);
            }
            header6b &= 0xFFFFFFFFFFFFL;
        } else {
            header6b = 0L;
            for (int i = 0; i < 6; ++i) {
                header6b |= (0xFFL & (long)frame.get(begin + i)) << 8 * i;
            }
        }
        return header6b;
    }

    static FrameDecoder.CorruptFrame verifyHeader6b(long header6b) {
        int computeLengthCrc = Crc.crc24(header6b, 3);
        int readLengthCrc = FrameDecoderCrc.headerCrc(header6b);
        return readLengthCrc == computeLengthCrc ? null : FrameDecoder.CorruptFrame.unrecoverable(readLengthCrc, computeLengthCrc);
    }

    @Override
    final long readHeader(ByteBuffer frame, int begin) {
        return FrameDecoderCrc.readHeader6b(frame, begin);
    }

    @Override
    final FrameDecoder.CorruptFrame verifyHeader(long header6b) {
        return FrameDecoderCrc.verifyHeader6b(header6b);
    }

    @Override
    final int frameLength(long header6b) {
        return FrameDecoderCrc.payloadLength(header6b) + 10;
    }

    @Override
    final FrameDecoder.Frame unpackFrame(ShareableBytes bytes, int begin, int end, long header6b) {
        ByteBuffer in = bytes.get();
        boolean isSelfContained = FrameDecoderCrc.isSelfContained(header6b);
        CRC32 crc = Crc.crc32();
        int readFullCrc = in.getInt(end - 4);
        if (in.order() == ByteOrder.BIG_ENDIAN) {
            readFullCrc = Integer.reverseBytes(readFullCrc);
        }
        Crc.updateCrc32(crc, in, begin + 6, end - 4);
        int computeFullCrc = (int)crc.getValue();
        if (readFullCrc != computeFullCrc) {
            return FrameDecoder.CorruptFrame.recoverable(isSelfContained, end - begin - 10, readFullCrc, computeFullCrc);
        }
        return new FrameDecoder.IntactFrame(isSelfContained, bytes.slice(begin + 6, end - 4));
    }

    @Override
    void decode(Collection<FrameDecoder.Frame> into, ShareableBytes bytes) {
        this.decode(into, bytes, 6);
    }

    @Override
    void addLastTo(ChannelPipeline pipeline) {
        pipeline.addLast("frameDecoderCrc", (ChannelHandler)this);
    }
}

