/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.AbstractRepairTask;
import org.apache.cassandra.repair.CommonRange;
import org.apache.cassandra.repair.CoordinatedRepairResult;
import org.apache.cassandra.repair.RepairCoordinator;
import org.apache.cassandra.repair.Scheduler;
import org.apache.cassandra.repair.consistent.CoordinatorSession;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Future;

public class IncrementalRepairTask
extends AbstractRepairTask {
    private final TimeUUID parentSession;
    private final RepairCoordinator.NeighborsAndRanges neighborsAndRanges;
    private final String[] cfnames;

    protected IncrementalRepairTask(RepairCoordinator coordinator, TimeUUID parentSession, RepairCoordinator.NeighborsAndRanges neighborsAndRanges, String[] cfnames) {
        super(coordinator);
        this.parentSession = parentSession;
        this.neighborsAndRanges = neighborsAndRanges;
        this.cfnames = cfnames;
    }

    @Override
    public String name() {
        return "Repair";
    }

    @Override
    public Future<CoordinatedRepairResult> performUnsafe(ExecutorPlus executor, Scheduler validationScheduler) throws Exception {
        ImmutableSet allParticipants = ImmutableSet.builder().addAll(this.neighborsAndRanges.participants).add((Object)this.broadcastAddressAndPort).build();
        List<CommonRange> allRanges = this.neighborsAndRanges.filterCommonRanges(this.keyspace, this.cfnames);
        CoordinatorSession coordinatorSession = this.coordinator.ctx.repair().consistent.coordinated.registerSession(this.parentSession, (Set<InetAddressAndPort>)allParticipants, this.neighborsAndRanges.shouldExcludeDeadParticipants);
        return coordinatorSession.execute(() -> this.runRepair(this.parentSession, true, executor, validationScheduler, allRanges, this.cfnames));
    }
}

