/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.concurrent.Condition;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressEventType;
import org.apache.cassandra.utils.progress.jmx.JMXNotificationProgressListener;

public class RepairRunner
extends JMXNotificationProgressListener {
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final PrintStream out;
    private final StorageServiceMBean ssProxy;
    private final String keyspace;
    private final Map<String, String> options;
    private final Condition condition = Condition.newOneTimeCondition();
    private int cmd;
    private volatile Exception error;

    public RepairRunner(PrintStream out, StorageServiceMBean ssProxy, String keyspace, Map<String, String> options) {
        this.out = out;
        this.ssProxy = ssProxy;
        this.keyspace = keyspace;
        this.options = options;
    }

    public void run() throws Exception {
        this.cmd = this.ssProxy.repairAsync(this.keyspace, this.options);
        if (this.cmd <= 0) {
            String message = String.format("Replication factor is 1. No repair is needed for keyspace '%s'", this.keyspace);
            this.printMessage(message);
        } else {
            while (!this.condition.await(NodeProbe.JMX_NOTIFICATION_POLL_INTERVAL_SECONDS, TimeUnit.SECONDS)) {
                this.queryForCompletedRepair(String.format("After waiting for poll interval of %s seconds", NodeProbe.JMX_NOTIFICATION_POLL_INTERVAL_SECONDS));
            }
            Exception error = this.error;
            if (error == null) {
                this.queryForCompletedRepair("condition satisfied");
                error = this.error;
            }
            if (error != null) {
                throw error;
            }
        }
    }

    @Override
    public boolean isInterestedIn(String tag) {
        return tag.equals("repair:" + this.cmd);
    }

    @Override
    public void handleNotificationLost(long timestamp, String message) {
        if (this.cmd > 0) {
            this.queryForCompletedRepair("After receiving lost notification");
        }
    }

    @Override
    public void handleConnectionClosed(long timestamp, String message) {
        this.handleConnectionFailed(timestamp, message);
    }

    @Override
    public void handleConnectionFailed(long timestamp, String message) {
        this.error = new IOException(String.format("[%s] JMX connection closed. You should check server log for repair status of keyspace %s(Subsequent keyspaces are not going to be repaired).", this.format.format(timestamp), this.keyspace));
        this.condition.signalAll();
    }

    @Override
    public void progress(String tag, ProgressEvent event) {
        ProgressEventType type = event.getType();
        Object message = event.getMessage();
        if (type == ProgressEventType.PROGRESS) {
            message = (String)message + " (progress: " + (int)event.getProgressPercentage() + "%)";
        }
        this.printMessage((String)message);
        if (type == ProgressEventType.ERROR) {
            this.error = new RuntimeException(String.format("Repair job has failed with the error message: %s. Check the logs on the repair participants for further details", message));
        }
        if (type == ProgressEventType.COMPLETE) {
            this.condition.signalAll();
        }
    }

    private void queryForCompletedRepair(String triggeringCondition) {
        List<String> status = this.ssProxy.getParentRepairStatus(this.cmd);
        String queriedString = "queried for parent session status and";
        if (status == null) {
            String message = String.format("%s %s couldn't find repair status for cmd: %s", triggeringCondition, queriedString, this.cmd);
            this.printMessage(message);
        } else {
            ActiveRepairService.ParentRepairStatus parentRepairStatus = ActiveRepairService.ParentRepairStatus.valueOf(status.get(0));
            List<String> messages = status.subList(1, status.size());
            switch (parentRepairStatus) {
                case COMPLETED: 
                case FAILED: {
                    this.printMessage(String.format("%s %s discovered repair %s.", triggeringCondition, queriedString, parentRepairStatus.name().toLowerCase()));
                    if (parentRepairStatus == ActiveRepairService.ParentRepairStatus.FAILED) {
                        this.error = new IOException(messages.get(0));
                    }
                    this.printMessages(messages);
                    this.condition.signalAll();
                    break;
                }
                case IN_PROGRESS: {
                    break;
                }
                default: {
                    this.printMessage(String.format("WARNING Encountered unexpected RepairRunnable.ParentRepairStatus: %s", new Object[]{parentRepairStatus}));
                    this.printMessages(messages);
                }
            }
        }
    }

    private void printMessages(List<String> messages) {
        for (String message : messages) {
            this.printMessage(message);
        }
    }

    private void printMessage(String message) {
        this.out.println(String.format("[%s] %s", this.format.format(Clock.Global.currentTimeMillis()), message));
    }
}

