/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;

@Command(name="cidrfilteringstats", description="Print statistics on CIDR filtering")
public class CIDRFilteringStats
extends NodeTool.NodeToolCmd {
    private void printCountsMetrics(NodeProbe probe, PrintStream out) {
        out.println("cidr_filtering_metrics_counts: ");
        TableBuilder outputTable = new TableBuilder();
        outputTable.add("name", "value");
        Map<String, Long> metricRows = probe.getCountsMetricsFromVtable();
        for (Map.Entry<String, Long> row : metricRows.entrySet()) {
            outputTable.add(row.getKey(), Long.toString(row.getValue()));
        }
        outputTable.printTo(out);
        out.println();
    }

    private void printLatenciesMetrics(NodeProbe probe, PrintStream out) {
        out.println("cidr_filtering_metrics_latencies: ");
        TableBuilder outputTable = new TableBuilder();
        outputTable.add("name", "p50th", "p95th", "p99th", "p999th", "max");
        Map<String, List<Double>> metricRows = probe.getLatenciesMetricsFromVtable();
        for (Map.Entry<String, List<Double>> row : metricRows.entrySet()) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(row.getKey());
            for (Double col : row.getValue()) {
                values.add(Double.toString(col));
            }
            outputTable.add(values);
        }
        outputTable.printTo(out);
        out.println();
    }

    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        this.printCountsMetrics(probe, out);
        this.printLatenciesMetrics(probe, out);
    }
}

