/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IGenericSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.obs.OffHeapBitSet;

public final class BloomFilterSerializer
implements IGenericSerializer<BloomFilter, DataInputPlus.DataInputStreamPlus, DataOutputStreamPlus> {
    public static final BloomFilterSerializer newFormatInstance = new BloomFilterSerializer(false);
    public static final BloomFilterSerializer oldFormatInstance = new BloomFilterSerializer(true);
    private final boolean oldFormat;

    private <T> BloomFilterSerializer(boolean oldFormat) {
        this.oldFormat = oldFormat;
    }

    public static BloomFilterSerializer forVersion(boolean oldSerializationFormat) {
        if (oldSerializationFormat) {
            return oldFormatInstance;
        }
        return newFormatInstance;
    }

    @Override
    public void serialize(BloomFilter bf, DataOutputStreamPlus out) throws IOException {
        assert (!this.oldFormat) : "Filter should not be serialized in old format";
        out.writeInt(bf.hashCount);
        bf.bitset.serialize(out);
    }

    @Override
    public long serializedSize(BloomFilter bf) {
        int size = TypeSizes.sizeof(bf.hashCount);
        size = (int)((long)size + bf.bitset.serializedSize());
        return size;
    }

    @Override
    public BloomFilter deserialize(DataInputPlus.DataInputStreamPlus in) throws IOException {
        int hashes = in.readInt();
        OffHeapBitSet bs = OffHeapBitSet.deserialize(in, this.oldFormat);
        return new BloomFilter(hashes, bs);
    }
}

