/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.format.SSTableFormat;

public enum StorageCompatibilityMode {
    CASSANDRA_4(4),
    UPGRADING(0x7FFFFFFE),
    NONE(Integer.MAX_VALUE);

    public final int major;

    private StorageCompatibilityMode(int major) {
        this.major = major;
    }

    public static StorageCompatibilityMode current() {
        return DatabaseDescriptor.getStorageCompatibilityMode();
    }

    public boolean disabled() {
        return this == NONE;
    }

    public boolean isBefore(int major) {
        return this.major < major;
    }

    public void validateSstableFormat(SSTableFormat<?, ?> selectedFormat) {
        if (selectedFormat.name().equals("bti") && this == CASSANDRA_4) {
            throw new ConfigurationException(String.format("Selected sstable format '%s' is not available when in storage compatibility mode '%s'.", new Object[]{selectedFormat.name(), this}));
        }
    }
}

