/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal;

import ch.obermuhlner.math.big.BigRational;
import ch.obermuhlner.math.big.internal.PowerIterator;
import ch.obermuhlner.math.big.internal.PowerTwoNIterator;
import ch.obermuhlner.math.big.internal.SeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class CosCalculator
extends SeriesCalculator {
    public static final CosCalculator INSTANCE = new CosCalculator();
    private int n = 0;
    private boolean negative = false;
    private BigRational factorial2n = BigRational.ONE;

    private CosCalculator() {
        super(true);
    }

    @Override
    protected BigRational getCurrentFactor() {
        BigRational factor = this.factorial2n.reciprocal();
        if (this.negative) {
            factor = factor.negate();
        }
        return factor;
    }

    @Override
    protected void calculateNextFactor() {
        ++this.n;
        this.factorial2n = this.factorial2n.multiply(2 * this.n - 1).multiply(2 * this.n);
        this.negative = !this.negative;
    }

    @Override
    protected PowerIterator createPowerIterator(BigDecimal x, MathContext mathContext) {
        return new PowerTwoNIterator(x, mathContext);
    }
}

