/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.graph;

import org.psjava.ds.graph.DirectedEdgeToString;
import org.psjava.ds.graph.FlowNetworkEdge;
import org.psjava.ds.graph.FlowStatus;
import org.psjava.util.AssertStatus;

public class SimpleFlowNetworkEdge<V, F> {
    public static <V, F, E> FlowNetworkEdge<V, F, E> create(final V from, final V to, final FlowStatus<F> flowStatus, final E originalEdgeOfNonSymmetryOrNull) {
        return new FlowNetworkEdge<V, F, E>(){
            FlowNetworkEdge<V, F, E> opposite;

            @Override
            public V from() {
                return from;
            }

            @Override
            public V to() {
                return to;
            }

            @Override
            public FlowStatus<F> getFlowStatus() {
                return flowStatus;
            }

            @Override
            public FlowNetworkEdge<V, F, E> getOpposite() {
                AssertStatus.assertTrue(this.opposite != null, "Reversed edge is not set");
                return this.opposite;
            }

            @Override
            public void setOpposite(FlowNetworkEdge<V, F, E> edge) {
                this.opposite = edge;
            }

            @Override
            public boolean isSkewSymmetryEdge() {
                return originalEdgeOfNonSymmetryOrNull == null;
            }

            @Override
            public E getOriginalCapacityEdge() {
                AssertStatus.assertTrue(!this.isSkewSymmetryEdge(), "the edge is symmetry edge");
                return originalEdgeOfNonSymmetryOrNull;
            }

            public String toString() {
                return DirectedEdgeToString.toString(this) + "(" + this.getFlowStatus() + ")";
            }
        };
    }

    private SimpleFlowNetworkEdge() {
    }
}

