/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.event;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.event.EventReader;

public class MorphingEventReader<T extends Event>
implements EventReader<T> {
    private final EventReader<Event> nested;
    private final EventMorpher<Event, T> morpher;
    private T nextEvent;

    public static <S extends Event, T extends Event> EventReader<T> morph(EventReader<S> source, EventMorpher<S, T> morpher) {
        return new MorphingEventReader<T>(source, morpher);
    }

    protected MorphingEventReader(EventReader<Event> source) {
        this(source, null);
    }

    public MorphingEventReader(EventReader<Event> source, EventMorpher<Event, T> morph) {
        this.nested = source;
        this.morpher = morph;
    }

    @Override
    public <M extends Event> EventReader<M> morph(EventMorpher<T, M> morpher) {
        return MorphingEventReader.morph(this, morpher);
    }

    @Override
    public boolean hasNext() {
        while (this.nextEvent == null && this.nested.hasNext()) {
            Event e = (Event)this.nested.next();
            this.nextEvent = this.transform(e);
        }
        return this.nextEvent != null;
    }

    protected T transform(Event event) {
        return this.morpher.morph(event);
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T event = this.nextEvent;
        this.nextEvent = null;
        return event;
    }

    @Override
    public T peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T event = this.nextEvent;
        return event;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        this.nested.dispose();
    }
}

