/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.userdefined;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import java.io.IOException;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionFixed;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.PartitionIterator;
import org.apache.cassandra.stress.generate.Row;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.PartitionOperation;
import org.apache.cassandra.stress.operations.userdefined.SchemaStatement;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;

public class SchemaQuery
extends SchemaStatement {
    final SchemaStatement.ArgSelect argSelect;
    final Object[][] randomBuffer;
    final Random random = new Random();

    public SchemaQuery(Timer timer, StressSettings settings, PartitionGenerator generator, SeedManager seedManager, PreparedStatement statement, ConsistencyLevel cl, SchemaStatement.ArgSelect argSelect) {
        super(timer, settings, new PartitionOperation.DataSpec(generator, seedManager, (Distribution)new DistributionFixed(1L), settings.insert.rowPopulationRatio.get(), argSelect == SchemaStatement.ArgSelect.MULTIROW ? statement.getVariables().size() : 1), statement, statement.getVariables().asList().stream().map(d -> d.getName()).collect(Collectors.toList()), cl);
        this.argSelect = argSelect;
        this.randomBuffer = new Object[this.argumentIndex.length][this.argumentIndex.length];
    }

    private int fillRandom() {
        int c = 0;
        PartitionIterator iterator = (PartitionIterator)this.partitions.get(0);
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Object[] randomBufferRow = this.randomBuffer[c++];
            for (int i = 0; i < this.argumentIndex.length; ++i) {
                randomBufferRow[i] = row.get(this.argumentIndex[i]);
            }
            if (c < this.randomBuffer.length) continue;
            break;
        }
        assert (c > 0);
        return c;
    }

    BoundStatement bindArgs() {
        switch (this.argSelect) {
            case MULTIROW: {
                int c = this.fillRandom();
                for (int i = 0; i < this.argumentIndex.length; ++i) {
                    int argIndex = this.argumentIndex[i];
                    this.bindBuffer[i] = this.randomBuffer[argIndex < 0 ? 0 : this.random.nextInt(c)][i];
                }
                return this.statement.bind(this.bindBuffer);
            }
            case SAMEROW: {
                return this.bindRow((Row)((PartitionIterator)this.partitions.get(0)).next());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void run(JavaDriverClient client) throws IOException {
        this.timeWithRetry(new JavaDriverRun(client));
    }

    private class JavaDriverRun
    extends SchemaStatement.Runner {
        final JavaDriverClient client;

        private JavaDriverRun(JavaDriverClient client) {
            super(SchemaQuery.this);
            this.client = client;
        }

        @Override
        public boolean run() throws Exception {
            ResultSet rs = this.client.getSession().execute((Statement)SchemaQuery.this.bindArgs());
            this.rowCount = rs.all().size();
            this.partitionCount = Math.min(1, this.rowCount);
            return true;
        }
    }
}

