/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.response.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class RingEntry {
    private final String datacenter;
    private final String address;
    private final int port;
    private final String rack;
    private final String status;
    private final String state;
    private final String load;
    private final String owns;
    private final String token;
    private final String fqdn;
    private final String hostId;

    @JsonCreator
    public RingEntry(@JsonProperty(value="datacenter") String datacenter, @JsonProperty(value="address") String address, @JsonProperty(value="port") int port, @JsonProperty(value="rack") String rack, @JsonProperty(value="status") String status, @JsonProperty(value="state") String state, @JsonProperty(value="load") String load, @JsonProperty(value="owns") String owns, @JsonProperty(value="token") String token, @JsonProperty(value="fqdn") String fqdn, @JsonProperty(value="hostId") String hostId) {
        this.datacenter = datacenter;
        this.address = address;
        this.port = port;
        this.rack = rack;
        this.status = status;
        this.state = state;
        this.load = load;
        this.owns = owns;
        this.token = token;
        this.fqdn = fqdn;
        this.hostId = hostId;
    }

    private RingEntry(Builder builder) {
        this.datacenter = builder.datacenter;
        this.address = builder.address;
        this.port = builder.port;
        this.rack = builder.rack;
        this.status = builder.status;
        this.state = builder.state;
        this.load = builder.load;
        this.owns = builder.owns;
        this.token = builder.token;
        this.fqdn = builder.fqdn;
        this.hostId = builder.hostId;
    }

    @JsonProperty(value="datacenter")
    public String datacenter() {
        return this.datacenter;
    }

    @JsonProperty(value="address")
    public String address() {
        return this.address;
    }

    @JsonProperty(value="port")
    public int port() {
        return this.port;
    }

    @JsonProperty(value="rack")
    public String rack() {
        return this.rack;
    }

    @JsonProperty(value="status")
    public String status() {
        return this.status;
    }

    @JsonProperty(value="state")
    public String state() {
        return this.state;
    }

    @JsonProperty(value="load")
    public String load() {
        return this.load;
    }

    @JsonProperty(value="owns")
    public String owns() {
        return this.owns;
    }

    @JsonProperty(value="token")
    public String token() {
        return this.token;
    }

    @JsonProperty(value="fqdn")
    public String fqdn() {
        return this.fqdn;
    }

    @JsonProperty(value="hostId")
    public String hostId() {
        return this.hostId;
    }

    public String toString() {
        return "RingEntry{datacenter='" + this.datacenter + '\'' + ", address='" + this.address + '\'' + ", port=" + this.port + ", rack='" + this.rack + '\'' + ", status='" + this.status + '\'' + ", state='" + this.state + '\'' + ", load='" + this.load + '\'' + ", owns='" + this.owns + '\'' + ", token='" + this.token + '\'' + ", fqdn='" + this.fqdn + '\'' + ", hostId='" + this.hostId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RingEntry ringEntry = (RingEntry)o;
        return this.port == ringEntry.port && Objects.equals(this.datacenter, ringEntry.datacenter) && Objects.equals(this.address, ringEntry.address) && Objects.equals(this.rack, ringEntry.rack) && Objects.equals(this.status, ringEntry.status) && Objects.equals(this.state, ringEntry.state) && Objects.equals(this.load, ringEntry.load) && Objects.equals(this.owns, ringEntry.owns) && Objects.equals(this.token, ringEntry.token) && Objects.equals(this.fqdn, ringEntry.fqdn) && Objects.equals(this.hostId, ringEntry.hostId);
    }

    public int hashCode() {
        return Objects.hash(this.datacenter, this.address, this.port, this.rack, this.status, this.state, this.load, this.owns, this.token, this.fqdn, this.hostId);
    }

    public static final class Builder {
        private String datacenter;
        private String address;
        private int port;
        private String rack;
        private String status;
        private String state;
        private String load;
        private String owns;
        private String token;
        private String fqdn;
        private String hostId;

        public Builder datacenter(String datacenter) {
            this.datacenter = datacenter;
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder rack(String rack) {
            this.rack = rack;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder load(String load) {
            this.load = load;
            return this;
        }

        public Builder owns(String owns) {
            this.owns = owns;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public RingEntry build() {
            return new RingEntry(this);
        }
    }
}

