/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base;

import com.google.common.net.HostAndPort;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.sidecar.adapters.base.NodeInfo;
import org.apache.cassandra.sidecar.adapters.base.jmx.EndpointSnitchJmxOperations;
import org.apache.cassandra.sidecar.adapters.base.jmx.GossipDependentStorageJmxOperations;
import org.apache.cassandra.sidecar.adapters.base.jmx.StorageJmxOperations;
import org.apache.cassandra.sidecar.common.response.RingResponse;
import org.apache.cassandra.sidecar.common.response.data.RingEntry;
import org.apache.cassandra.sidecar.common.server.JmxClient;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RingProvider.class);
    private static final String UNKNOWN_SHORT = "?";
    private static final String UNKNOWN = "Unknown";
    private static final String DECIMAL_FORMAT = "##0.00%";
    protected final JmxClient jmxClient;
    private final DnsResolver dnsResolver;

    public RingProvider(JmxClient jmxClient, DnsResolver dnsResolver) {
        this.jmxClient = jmxClient;
        this.dnsResolver = dnsResolver;
    }

    public RingResponse ring(@Nullable Name keyspace) throws UnknownHostException {
        Map<String, Float> ownerships;
        StorageJmxOperations storageOps = this.initializeStorageOps();
        EndpointSnitchJmxOperations epSnitchInfo = this.initializeEndpointProxy();
        List<String> liveNodes = storageOps.getLiveNodesWithPort();
        List<String> deadNodes = storageOps.getUnreachableNodesWithPort();
        Status status = new Status(liveNodes, deadNodes);
        List<String> joiningNodes = storageOps.getJoiningNodesWithPort();
        List<String> leavingNodes = storageOps.getLeavingNodesWithPort();
        List<String> movingNodes = storageOps.getMovingNodesWithPort();
        State state = new State(joiningNodes, leavingNodes, movingNodes);
        Map<String, String> loadMap = storageOps.getLoadMapWithPort();
        Map<String, String> tokensToEndpoints = storageOps.getTokenToEndpointWithPortMap();
        Map<String, String> endpointsToHostIds = storageOps.getEndpointWithPortToHostId();
        boolean showEffectiveOwnership = true;
        try {
            ownerships = storageOps.effectiveOwnershipWithPort(keyspace != null ? keyspace.name() : null);
        }
        catch (IllegalStateException ex) {
            ownerships = storageOps.getOwnershipWithPort();
            LOGGER.warn("Unable to retrieve effective ownership information for keyspace={}", (Object)keyspace, (Object)ex);
            showEffectiveOwnership = false;
        }
        DecimalFormat ownsFormat = new DecimalFormat(DECIMAL_FORMAT);
        RingResponse response = new RingResponse(tokensToEndpoints.size());
        for (Map.Entry<String, String> entry : tokensToEndpoints.entrySet()) {
            String endpoint = entry.getValue();
            String token = entry.getKey();
            HostAndPort hap = RingProvider.resolve(endpoint, this.dnsResolver);
            Float owns = ownerships.get(endpoint);
            RingEntry ringEntry = new RingEntry.Builder().datacenter(epSnitchInfo.getDatacenter(endpoint)).rack(RingProvider.queryRack(epSnitchInfo, endpoint)).status(status.of(endpoint)).state(state.of(endpoint)).load(loadMap.getOrDefault(endpoint, UNKNOWN_SHORT)).owns(RingProvider.formatOwns(showEffectiveOwnership, ownsFormat, owns)).token(token).address(hap.getHost()).port(hap.getPort()).fqdn(this.dnsResolver.reverseResolve(hap.getHost())).hostId(endpointsToHostIds.getOrDefault(endpoint, UNKNOWN)).build();
            response.add((Object)ringEntry);
        }
        return response;
    }

    protected EndpointSnitchJmxOperations initializeEndpointProxy() {
        return (EndpointSnitchJmxOperations)this.jmxClient.proxy(EndpointSnitchJmxOperations.class, "org.apache.cassandra.db:type=EndpointSnitchInfo");
    }

    protected StorageJmxOperations initializeStorageOps() {
        return new GossipDependentStorageJmxOperations((StorageJmxOperations)this.jmxClient.proxy(StorageJmxOperations.class, "org.apache.cassandra.db:type=StorageService"));
    }

    private static HostAndPort resolve(String endpoint, DnsResolver resolver) throws UnknownHostException {
        HostAndPort hap = HostAndPort.fromString((String)endpoint);
        String address = resolver.resolve(hap.getHost());
        return HostAndPort.fromParts((String)address, (int)hap.getPortOrDefault(-1));
    }

    private static String formatOwns(boolean showEffectiveOwnership, DecimalFormat ownsFormat, Float owns) {
        if (showEffectiveOwnership && owns != null) {
            return ownsFormat.format(owns);
        }
        return UNKNOWN_SHORT;
    }

    private static String queryRack(EndpointSnitchJmxOperations epSnitchInfo, String endpoint) {
        try {
            return epSnitchInfo.getRack(endpoint);
        }
        catch (UnknownHostException e) {
            return UNKNOWN;
        }
    }

    static class State {
        protected final Set<String> joiningNodes;
        private final Set<String> leavingNodes;
        private final Set<String> movingNodes;

        State(List<String> joiningNodes, List<String> leavingNodes, List<String> movingNodes) {
            this.joiningNodes = new HashSet<String>(joiningNodes);
            this.leavingNodes = new HashSet<String>(leavingNodes);
            this.movingNodes = new HashSet<String>(movingNodes);
        }

        String of(String endpoint) {
            if (this.joiningNodes.contains(endpoint)) {
                return NodeInfo.NodeState.JOINING.displayName();
            }
            if (this.leavingNodes.contains(endpoint)) {
                return NodeInfo.NodeState.LEAVING.displayName();
            }
            if (this.movingNodes.contains(endpoint)) {
                return NodeInfo.NodeState.MOVING.displayName();
            }
            return NodeInfo.NodeState.NORMAL.displayName();
        }
    }

    static class Status {
        private final Set<String> liveNodes;
        private final Set<String> deadNodes;

        Status(List<String> liveNodes, List<String> deadNodes) {
            this.liveNodes = new HashSet<String>(liveNodes);
            this.deadNodes = new HashSet<String>(deadNodes);
        }

        String of(String endpoint) {
            if (this.liveNodes.contains(endpoint)) {
                return NodeInfo.NodeStatus.UP.displayName();
            }
            if (this.deadNodes.contains(endpoint)) {
                return NodeInfo.NodeStatus.DOWN.displayName();
            }
            return RingProvider.UNKNOWN_SHORT;
        }
    }
}

