/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.apache.cassandra.sidecar.acl.IdentityToRoleCache;
import org.apache.cassandra.sidecar.acl.authorization.SuperUserCache;
import org.apache.cassandra.sidecar.config.AccessControlConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;

@Singleton
public class AdminIdentityResolver {
    private final IdentityToRoleCache identityToRoleCache;
    private final SuperUserCache superUserCache;
    private final AccessControlConfiguration config;

    @Inject
    public AdminIdentityResolver(IdentityToRoleCache identityToRoleCache, SuperUserCache superUserCache, SidecarConfiguration sidecarConfiguration) {
        this.identityToRoleCache = identityToRoleCache;
        this.superUserCache = superUserCache;
        this.config = sidecarConfiguration.accessControlConfiguration();
    }

    public boolean isAdmin(String identity) {
        if (this.config.adminIdentities().contains(identity)) {
            return true;
        }
        String role = (String)this.identityToRoleCache.get(identity);
        if (role == null) {
            return false;
        }
        return this.superUserCache.isSuperUser(role);
    }
}

