/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.file.attribute.PosixFilePermissions;
import org.apache.cassandra.sidecar.config.SSTableUploadConfiguration;

public class SSTableUploadConfigurationImpl
implements SSTableUploadConfiguration {
    public static final String CONCURRENT_UPLOAD_LIMIT_PROPERTY = "concurrent_upload_limit";
    public static final int DEFAULT_CONCURRENT_UPLOAD_LIMIT = 80;
    public static final String MIN_FREE_SPACE_PERCENT_PROPERTY = "min_free_space_percent";
    public static final float DEFAULT_MIN_FREE_SPACE_PERCENT = 10.0f;
    public static final String FILE_PERMISSIONS_PROPERTY = "file_permissions";
    public static final String DEFAULT_FILE_PERMISSIONS = "rw-r--r--";
    @JsonProperty(value="concurrent_upload_limit")
    protected final int concurrentUploadsLimit;
    @JsonProperty(value="min_free_space_percent")
    protected final float minimumSpacePercentageRequired;
    protected String filePermissions;

    public SSTableUploadConfigurationImpl() {
        this(80, 10.0f, DEFAULT_FILE_PERMISSIONS);
    }

    public SSTableUploadConfigurationImpl(int concurrentUploadsLimit) {
        this(concurrentUploadsLimit, 10.0f, DEFAULT_FILE_PERMISSIONS);
    }

    public SSTableUploadConfigurationImpl(float minimumSpacePercentageRequired) {
        this(80, minimumSpacePercentageRequired, DEFAULT_FILE_PERMISSIONS);
    }

    public SSTableUploadConfigurationImpl(String filePermissions) {
        this(80, 10.0f, filePermissions);
    }

    public SSTableUploadConfigurationImpl(int concurrentUploadsLimit, float minimumSpacePercentageRequired, String filePermissions) {
        this.concurrentUploadsLimit = concurrentUploadsLimit;
        this.minimumSpacePercentageRequired = minimumSpacePercentageRequired;
        this.setFilePermissions(filePermissions);
    }

    @Override
    @JsonProperty(value="concurrent_upload_limit")
    public int concurrentUploadsLimit() {
        return this.concurrentUploadsLimit;
    }

    @Override
    @JsonProperty(value="min_free_space_percent")
    public float minimumSpacePercentageRequired() {
        return this.minimumSpacePercentageRequired;
    }

    @Override
    @JsonProperty(value="file_permissions", defaultValue="rw-r--r--")
    public String filePermissions() {
        return this.filePermissions;
    }

    @JsonProperty(value="file_permissions", defaultValue="rw-r--r--")
    public void setFilePermissions(String filePermissions) {
        if (filePermissions != null) {
            try {
                this.filePermissions = PosixFilePermissions.toString(PosixFilePermissions.fromString(filePermissions));
            }
            catch (IllegalArgumentException exception) {
                String errorMessage = String.format("Invalid file_permissions configuration=\"%s\"", filePermissions);
                throw new IllegalArgumentException(errorMessage);
            }
        } else {
            this.filePermissions = null;
        }
    }
}

