/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db.schema;

import io.vertx.core.Vertx;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.db.schema.SidecarInternalKeyspace;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchemaFetcher;
import org.apache.cassandra.sidecar.server.SidecarServerEvents;
import org.apache.cassandra.sidecar.utils.EventBusUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarSchema
implements TableSchemaFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarSchema.class);
    private final SchemaKeyspaceConfiguration schemaKeyspaceConfiguration;
    private final SidecarInternalKeyspace sidecarInternalKeyspace;
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);

    public SidecarSchema(Vertx vertx, SidecarConfiguration config, SidecarInternalKeyspace sidecarInternalKeyspace) {
        this.schemaKeyspaceConfiguration = config.serviceConfiguration().schemaKeyspaceConfiguration();
        this.sidecarInternalKeyspace = sidecarInternalKeyspace;
        if (this.schemaKeyspaceConfiguration.isEnabled()) {
            EventBusUtils.onceLocalConsumer(vertx.eventBus(), SidecarServerEvents.ON_SIDECAR_SCHEMA_INITIALIZED.address(), ignored -> this.isInitialized.set(true));
        } else {
            LOGGER.info("Sidecar schema is disabled!");
        }
    }

    public boolean isInitialized() {
        return this.schemaKeyspaceConfiguration.isEnabled() && this.isInitialized.get();
    }

    public void ensureInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Sidecar schema is not initialized!");
        }
    }

    public SidecarInternalKeyspace sidecarInternalKeyspace() {
        return this.sidecarInternalKeyspace;
    }

    public <T extends TableSchema> T tableSchema(Class<T> type) {
        return this.sidecarInternalKeyspace.tableSchema(type);
    }
}

