/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import com.google.inject.Inject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.job.OperationalJob;
import org.apache.cassandra.sidecar.job.OperationalJobManager;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.apache.cassandra.sidecar.utils.OperationalJobUtils;
import org.jetbrains.annotations.NotNull;

public class OperationalJobHandler
extends AbstractHandler<UUID>
implements AccessProtected {
    private final OperationalJobManager jobManager;

    @Inject
    public OperationalJobHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator, OperationalJobManager jobManager) {
        super(metadataFetcher, executorPools, validator);
        this.jobManager = jobManager;
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.READ_OPERATIONAL_JOB.toAuthorization());
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, UUID jobId) {
        this.executorPools.service().executeBlocking(() -> {
            OperationalJob job = this.jobManager.getJobIfExists(jobId);
            if (job == null) {
                this.logger.info("No operational job found with the jobId. jobId={}", (Object)jobId);
                throw HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, String.format("Unknown job with ID: %s. Please retry the operation.", jobId));
            }
            return job;
        }).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, jobId)).onSuccess(job -> OperationalJobUtils.sendStatusBasedResponse(context, job));
    }

    @Override
    protected UUID extractParamsOrThrow(RoutingContext context) {
        return this.validatedJobIdParam(context);
    }

    private UUID validatedJobIdParam(RoutingContext context) {
        UUID jobId;
        String requestJobId = context.pathParam(":operationId".substring(1));
        if (requestJobId == null) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, ":operationId is required but not supplied");
        }
        try {
            jobId = UUID.fromString(requestJobId);
        }
        catch (IllegalArgumentException e) {
            this.logger.info("Invalid jobId. jobId={}", (Object)requestJobId);
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, String.format("Invalid job ID provided: %s.", requestJobId));
        }
        return jobId;
    }
}

