/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics.instance;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import org.apache.cassandra.sidecar.metrics.instance.InstanceHealthMetrics;
import org.apache.cassandra.sidecar.metrics.instance.InstanceMetrics;
import org.apache.cassandra.sidecar.metrics.instance.InstanceResourceMetrics;
import org.apache.cassandra.sidecar.metrics.instance.InstanceRestoreMetrics;
import org.apache.cassandra.sidecar.metrics.instance.SSTableImportMetrics;
import org.apache.cassandra.sidecar.metrics.instance.StreamSSTableMetrics;
import org.apache.cassandra.sidecar.metrics.instance.UploadSSTableMetrics;

public class InstanceMetricsImpl
implements InstanceMetrics {
    protected final MetricRegistry metricRegistry;
    protected final StreamSSTableMetrics streamSSTableMetrics;
    protected final UploadSSTableMetrics uploadSSTableMetrics;
    protected final InstanceHealthMetrics healthMetrics;
    protected final InstanceResourceMetrics resourceMetrics;
    protected final InstanceRestoreMetrics restoreMetrics;
    protected final SSTableImportMetrics ssTableImportMetrics;

    public InstanceMetricsImpl(MetricRegistry metricRegistry) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metrics registry can not be null");
        this.healthMetrics = new InstanceHealthMetrics(metricRegistry);
        this.resourceMetrics = new InstanceResourceMetrics(metricRegistry);
        this.streamSSTableMetrics = new StreamSSTableMetrics(metricRegistry);
        this.uploadSSTableMetrics = new UploadSSTableMetrics(metricRegistry);
        this.restoreMetrics = new InstanceRestoreMetrics(metricRegistry);
        this.ssTableImportMetrics = new SSTableImportMetrics(metricRegistry);
    }

    @Override
    public InstanceHealthMetrics health() {
        return this.healthMetrics;
    }

    @Override
    public InstanceResourceMetrics resource() {
        return this.resourceMetrics;
    }

    @Override
    public StreamSSTableMetrics streamSSTable() {
        return this.streamSSTableMetrics;
    }

    @Override
    public UploadSSTableMetrics uploadSSTable() {
        return this.uploadSSTableMetrics;
    }

    @Override
    public InstanceRestoreMetrics restore() {
        return this.restoreMetrics;
    }

    @Override
    public SSTableImportMetrics sstableImport() {
        return this.ssTableImportMetrics;
    }
}

