/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.restore;

import com.datastax.driver.core.utils.UUIDs;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.cassandra.sidecar.exceptions.RestoreJobException;
import org.apache.cassandra.sidecar.exceptions.RestoreJobFatalException;
import org.apache.cassandra.sidecar.utils.DigestAlgorithm;
import org.apache.cassandra.sidecar.utils.DigestAlgorithmProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RestoreJobUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreJobUtil.class);
    private static final int KB_512 = 524288;
    private static final String RESTORE_JOB_PREFIX = "c0ffee-";
    private static final int RESTORE_JOB_PREFIX_LEN = "c0ffee-".length();
    private static final int RESTORE_JOB_DEFAULT_HASH_SEED = 0;
    private final DigestAlgorithmProvider digestAlgorithmProvider;

    @Inject
    public RestoreJobUtil(@Named(value="xxhash32") DigestAlgorithmProvider digestAlgorithmProvider) {
        this.digestAlgorithmProvider = digestAlgorithmProvider;
    }

    public static void unzip(File zipFile, File targetDir) throws IOException, RestoreJobException {
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(zipFile.toPath(), new OpenOption[0]));){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (zipEntry.getName().contains(File.separator)) {
                    throw new RestoreJobFatalException("Unexpected directory in slice zip file. File: " + zipFile);
                }
                File targetFile = RestoreJobUtil.newProtectedTargetFile(zipEntry, targetDir);
                Files.copy(zis, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            zis.closeEntry();
        }
    }

    public static String prefixedJobId(UUID jobId) {
        return RESTORE_JOB_PREFIX + jobId;
    }

    public static String generateUniqueUploadId(UUID jobId, String sliceId) {
        return RestoreJobUtil.prefixedJobId(jobId) + "-" + sliceId + "-" + ThreadLocalRandom.current().nextInt(10000);
    }

    public static long timestampFromRestoreJobDir(String fileName) {
        if (!fileName.startsWith(RESTORE_JOB_PREFIX)) {
            return -1L;
        }
        try {
            UUID id = UUID.fromString(fileName.substring(RESTORE_JOB_PREFIX_LEN));
            return UUIDs.unixTimestamp((UUID)id);
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }

    public static void cleanDirectory(Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0]) || !Files.exists(path, new LinkOption[0])) {
            LOGGER.warn("Clean directory API called for non existent directory: {}", (Object)path);
            return;
        }
        try (Stream<Path> contents = Files.list(path);){
            contents.forEach(filePath -> {
                try {
                    if (Files.isDirectory(filePath, new LinkOption[0])) {
                        RestoreJobUtil.cleanDirectory(filePath);
                    }
                    Files.delete(filePath);
                }
                catch (IOException e) {
                    LOGGER.error("Unexpected error occurred while cleaning directory {}", (Object)path, (Object)e);
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static File newProtectedTargetFile(ZipEntry zipEntry, File targetDir) throws IOException, RestoreJobException {
        File targetFile = new File(targetDir, zipEntry.getName());
        String targetDirPath = targetDir.getCanonicalPath();
        String targetFilePath = targetFile.getCanonicalPath();
        if (!targetFilePath.startsWith(targetDirPath)) {
            throw new RestoreJobException("Bad zip entry: " + zipEntry.getName());
        }
        return targetFile;
    }

    public String checksum(File file) throws IOException {
        return this.checksum(file, 0);
    }

    public String checksum(File file, int seed) throws IOException {
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            String string;
            block13: {
                DigestAlgorithm digestAlgorithm = this.digestAlgorithmProvider.get(seed);
                try {
                    int len;
                    byte[] buffer = new byte[524288];
                    while ((len = fis.read(buffer)) != -1) {
                        digestAlgorithm.update(buffer, 0, len);
                    }
                    string = digestAlgorithm.digest();
                    if (digestAlgorithm == null) break block13;
                }
                catch (Throwable throwable) {
                    if (digestAlgorithm != null) {
                        try {
                            digestAlgorithm.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                digestAlgorithm.close();
            }
            return string;
        }
    }

    public long currentTimeNanos() {
        return System.nanoTime();
    }
}

