/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mtls.impl;

import io.vertx.ext.auth.authentication.CertificateCredentials;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.mtls.CertificateIdentityExtractor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SpiffeIdentityExtractor
implements CertificateIdentityExtractor {
    private static final int SUBJECT_ALT_NAME_URI_TYPE = 6;
    private static final String SPIFFE_PREFIX = "spiffe://";
    private final String trustedDomain;

    public SpiffeIdentityExtractor() {
        this(null);
    }

    public SpiffeIdentityExtractor(String trustedDomain) {
        this.trustedDomain = trustedDomain;
    }

    @Override
    public List<String> validIdentities(CertificateCredentials certificateCredentials) throws CredentialValidationException {
        X509Certificate privateCert = certificateCredentials.peerCertificate();
        if (privateCert == null) {
            throw new CredentialValidationException("No X509Certificate found for validating");
        }
        String identity = this.extractIdentity(privateCert);
        this.validateIdentity(identity);
        return Collections.singletonList(identity);
    }

    protected String extractIdentity(X509Certificate certificate) {
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            for (List<?> item : subjectAltNames) {
                Integer type = (Integer)item.get(0);
                String identity = (String)item.get(1);
                if (type != 6 || !identity.startsWith(SPIFFE_PREFIX)) continue;
                return identity;
            }
        }
        catch (Exception e) {
            throw new CredentialValidationException("Error reading SAN of certificate", (Throwable)e);
        }
        throw new CredentialValidationException("Unable to extract SPIFFE identity from certificate");
    }

    protected void validateIdentity(String identity) {
        this.verifyPrefix(identity);
        if (this.trustedDomain != null) {
            this.verifyDomain(identity);
        }
    }

    private void verifyPrefix(String identity) {
        if (!identity.startsWith(SPIFFE_PREFIX)) {
            throw new CredentialValidationException("SPIFFE identity must start with prefix spiffe://");
        }
    }

    private void verifyDomain(String identity) {
        boolean domainPresentCheck;
        String uriSuffix = identity.replaceFirst(SPIFFE_PREFIX, "");
        String[] uriSuffixParts = uriSuffix.split("/");
        boolean bl = domainPresentCheck = uriSuffixParts.length > 0;
        if (!domainPresentCheck) {
            throw new CredentialValidationException("SPIFFE identity extracted " + identity + " does not contain domain information");
        }
        String domain = uriSuffixParts[0];
        if (!domain.equals(this.trustedDomain)) {
            throw new CredentialValidationException("SPIFFE Identity domain " + domain + " is not trusted");
        }
    }
}

