/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import java.util.concurrent.TimeUnit;

public class InstantThroughput {
    static final long ONE_SEC = TimeUnit.SECONDS.toNanos(1L);
    static final long TWO_SECS = TimeUnit.SECONDS.toNanos(2L);
    private volatile long prevCount = -1L;
    private volatile long timestamp = 0L;
    private volatile long count = 0L;

    void check() {
        long now = System.nanoTime();
        if (now - this.timestamp > ONE_SEC) {
            if (now - this.timestamp < TWO_SECS) {
                this.prevCount = this.count;
            } else if (this.prevCount > 0L) {
                this.prevCount = 0L;
            }
            this.timestamp = now;
            this.count = 0L;
        }
    }

    public void mark() {
        this.check();
        ++this.count;
    }

    public long count() {
        this.check();
        return this.prevCount != -1L ? this.prevCount : this.count;
    }
}

