/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import org.apache.cayenne.crypto.transformer.value.ValueDecryptor;
import org.apache.cayenne.crypto.transformer.value.ValueEncryptor;
import org.apache.cayenne.crypto.transformer.value.ValueTransformerFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.map.DbAttribute;

public class LazyValueTransformerFactory
implements ValueTransformerFactory {
    private Provider<ValueTransformerFactory> delegateProvider;
    private volatile ValueTransformerFactory delegate;

    public LazyValueTransformerFactory(@Inject Provider<ValueTransformerFactory> delegateProvider) {
        this.delegateProvider = delegateProvider;
    }

    @Override
    public ValueEncryptor encryptor(DbAttribute a) {
        return this.ensureInit().encryptor(a);
    }

    @Override
    public ValueDecryptor decryptor(DbAttribute a) {
        return this.ensureInit().decryptor(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueTransformerFactory ensureInit() {
        if (this.delegate == null) {
            LazyValueTransformerFactory lazyValueTransformerFactory = this;
            synchronized (lazyValueTransformerFactory) {
                if (this.delegate == null) {
                    this.delegate = (ValueTransformerFactory)this.delegateProvider.get();
                }
            }
        }
        return this.delegate;
    }
}

