/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.ProcedureEvent;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.project.extension.info.ObjectInfo;
import org.apache.cayenne.swing.components.JCayenneCheckBox;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class ProcedureTab
extends JPanel
implements ProcedureDisplayListener,
ExistingSelectionProcessor {
    protected ProjectController eventController;
    protected TextAdapter name;
    protected TextAdapter schema;
    protected TextAdapter catalog;
    protected TextAdapter comment;
    protected JCheckBox returnsValue;
    protected boolean ignoreChange;

    public ProcedureTab(ProjectController eventController) {
        this.eventController = eventController;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.name = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                ProcedureTab.this.setProcedureName(text);
            }
        };
        this.schema = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                ProcedureTab.this.setSchema(text);
            }
        };
        this.catalog = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                ProcedureTab.this.setCatalog(text);
            }
        };
        this.comment = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                ProcedureTab.this.setComment(text);
            }
        };
        this.returnsValue = new JCayenneCheckBox();
        this.returnsValue.setToolTipText("first parameter will be used as return value");
        FormLayout layout = new FormLayout("right:pref, 3dlu, fill:200dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Stored Procedure Configuration");
        builder.append("Procedure Name:", (Component)this.name.getComponent());
        builder.append("Catalog:", (Component)this.catalog.getComponent());
        builder.append("Schema:", (Component)this.schema.getComponent());
        builder.append("Returns Value:", (Component)this.returnsValue);
        builder.append("Comment:", (Component)this.comment.getComponent());
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    private void initController() {
        this.returnsValue.addItemListener(e -> {
            Procedure procedure = this.eventController.getCurrentProcedure();
            if (procedure != null && !this.ignoreChange) {
                procedure.setReturningValue(this.returnsValue.isSelected());
                this.eventController.fireProcedureEvent(new ProcedureEvent((Object)this, procedure));
            }
        });
        this.eventController.addProcedureDisplayListener(this);
    }

    @Override
    public void processExistingSelection(EventObject e) {
        ProcedureDisplayEvent pde = new ProcedureDisplayEvent((Object)this, this.eventController.getCurrentProcedure(), this.eventController.getCurrentDataMap(), (DataChannelDescriptor)this.eventController.getProject().getRootNode());
        this.eventController.fireProcedureDisplayEvent(pde);
    }

    @Override
    public void currentProcedureChanged(ProcedureDisplayEvent e) {
        Procedure procedure = e.getProcedure();
        if (procedure == null || !e.isProcedureChanged()) {
            return;
        }
        this.name.setText(procedure.getName());
        this.schema.setText(procedure.getSchema());
        this.catalog.setText(procedure.getCatalog());
        this.comment.setText(this.getComment(procedure));
        this.ignoreChange = true;
        this.returnsValue.setSelected(procedure.isReturningValue());
        this.ignoreChange = false;
    }

    void setProcedureName(String newName) {
        Procedure procedure;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((procedure = this.eventController.getCurrentProcedure()) == null || Util.nullSafeEquals(newName, procedure.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Procedure name is required.", new Object[0]);
        }
        if (procedure.getDataMap().getProcedure(newName) != null) {
            throw new ValidationException("There is another procedure with name '" + newName + "'.", new Object[0]);
        }
        ProcedureEvent e = new ProcedureEvent((Object)this, procedure, procedure.getName());
        ProjectUtil.setProcedureName(procedure.getDataMap(), procedure, newName);
        this.eventController.fireProcedureEvent(e);
    }

    void setSchema(String text) {
        Procedure procedure;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((procedure = this.eventController.getCurrentProcedure()) != null && !Util.nullSafeEquals(procedure.getSchema(), text)) {
            procedure.setSchema(text);
            this.eventController.fireProcedureEvent(new ProcedureEvent((Object)this, procedure));
        }
    }

    void setCatalog(String text) {
        Procedure procedure;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((procedure = this.eventController.getCurrentProcedure()) != null && !Util.nullSafeEquals(procedure.getCatalog(), text)) {
            procedure.setCatalog(text);
            this.eventController.fireProcedureEvent(new ProcedureEvent((Object)this, procedure));
        }
    }

    void setComment(String comment) {
        Procedure procedure = this.eventController.getCurrentProcedure();
        if (procedure == null) {
            return;
        }
        ObjectInfo.putToMetaData(this.eventController.getApplication().getMetaData(), procedure, "comment", comment);
        this.eventController.fireProcedureEvent(new ProcedureEvent((Object)this, procedure));
    }

    String getComment(Procedure procedure) {
        return ObjectInfo.getFromMetaData(this.eventController.getApplication().getMetaData(), procedure, "comment");
    }
}

