/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.map.DefaultEntityResultSegment;
import org.apache.cayenne.map.DefaultScalarResultSegment;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.ScalarResultSegment;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.ToCacheKeyPrefetchProcessor;
import org.apache.cayenne.query.ToCacheKeyTraversalHandler;

@Deprecated
class SelectQueryMetadata
extends BaseQueryMetadata {
    private static final long serialVersionUID = 7465922769303943945L;
    private static final ScalarResultSegment SCALAR_RESULT_SEGMENT = new DefaultScalarResultSegment(null, -1);
    private static final EntityResultSegment ENTITY_RESULT_SEGMENT = new DefaultEntityResultSegment(null, null, -1);
    private Map<String, String> pathSplitAliases;
    private boolean isSingleResultSetMapping;
    private boolean suppressingDistinct;

    SelectQueryMetadata() {
    }

    @Override
    void copyFromInfo(QueryMetadata info) {
        super.copyFromInfo(info);
        this.pathSplitAliases = new HashMap<String, String>(info.getPathSplitAliases());
    }

    boolean resolve(Object root, EntityResolver resolver, SelectQuery<?> query) {
        if (super.resolve(root, resolver)) {
            if (this.cacheStrategy != null && this.cacheStrategy != QueryCacheStrategy.NO_CACHE) {
                this.cacheKey = this.makeCacheKey(query, resolver);
            }
            this.resolveAutoAliases(query);
            this.buildResultSetMappingForColumns(query, resolver);
            this.isSingleResultSetMapping = query.canReturnScalarValue() && super.isSingleResultSetMapping();
            return true;
        }
        return false;
    }

    private String makeCacheKey(SelectQuery<?> query, EntityResolver resolver) {
        StringBuilder key = new StringBuilder();
        ToCacheKeyTraversalHandler traversalHandler = null;
        ObjEntity entity = this.getObjEntity();
        if (entity != null) {
            key.append(entity.getName());
        } else if (this.dbEntity != null) {
            key.append("db:").append(this.dbEntity.getName());
        }
        if (query.getColumns() != null && !query.getColumns().isEmpty()) {
            traversalHandler = new ToCacheKeyTraversalHandler(resolver.getValueObjectTypeRegistry(), key);
            for (Property property : query.getColumns()) {
                key.append("/c:");
                property.getExpression().traverse(traversalHandler);
            }
        }
        if (query.getQualifier() != null) {
            key.append('/');
            if (traversalHandler == null) {
                traversalHandler = new ToCacheKeyTraversalHandler(resolver.getValueObjectTypeRegistry(), key);
            }
            query.getQualifier().traverse(traversalHandler);
        }
        if (!query.getOrderings().isEmpty()) {
            for (Ordering ordering : query.getOrderings()) {
                key.append('/').append(ordering.getSortSpecString());
                if (!ordering.isAscending()) {
                    key.append(":d");
                }
                if (!ordering.isCaseInsensitive()) continue;
                key.append(":i");
            }
        }
        if (query.getHavingQualifier() != null) {
            key.append('/');
            if (traversalHandler == null) {
                traversalHandler = new ToCacheKeyTraversalHandler(resolver.getValueObjectTypeRegistry(), key);
            }
            query.getHavingQualifier().traverse(traversalHandler);
        }
        if (query.getFetchOffset() > 0 || query.getFetchLimit() > 0) {
            key.append('/');
            if (query.getFetchOffset() > 0) {
                key.append('o').append(query.getFetchOffset());
            }
            if (query.getFetchLimit() > 0) {
                key.append('l').append(query.getFetchLimit());
            }
        }
        if (query.getPrefetchTree() != null) {
            query.getPrefetchTree().traverse(new ToCacheKeyPrefetchProcessor(key));
        }
        return key.toString();
    }

    private void resolveAutoAliases(SelectQuery<?> query) {
        this.resolveQualifierAliases(query);
        this.resolveColumnsAliases(query);
        this.resolveOrderingAliases(query);
        this.resolveHavingQualifierAliases(query);
    }

    private void resolveQualifierAliases(SelectQuery<?> query) {
        Expression qualifier = query.getQualifier();
        if (qualifier != null) {
            this.resolveAutoAliases(qualifier);
        }
    }

    private void resolveColumnsAliases(SelectQuery<?> query) {
        Collection<Property<?>> columns = query.getColumns();
        if (columns != null) {
            for (Property<?> property : columns) {
                Expression propertyExpression = property.getExpression();
                if (propertyExpression == null) continue;
                this.resolveAutoAliases(propertyExpression);
            }
        }
    }

    private void resolveOrderingAliases(SelectQuery<?> query) {
        List<Ordering> orderings = query.getOrderings();
        if (orderings != null) {
            for (Ordering ordering : orderings) {
                Expression sortSpec = ordering.getSortSpec();
                if (sortSpec == null) continue;
                this.resolveAutoAliases(sortSpec);
            }
        }
    }

    private void resolveHavingQualifierAliases(SelectQuery<?> query) {
        Expression havingQualifier = query.getHavingQualifier();
        if (havingQualifier != null) {
            this.resolveAutoAliases(havingQualifier);
        }
    }

    private void resolveAutoAliases(Expression expression) {
        Map<String, String> aliases = expression.getPathAliases();
        if (!aliases.isEmpty()) {
            if (this.pathSplitAliases == null) {
                this.pathSplitAliases = new HashMap<String, String>();
            }
            for (Map.Entry<String, String> entry : aliases.entrySet()) {
                this.pathSplitAliases.compute(entry.getKey(), (key, value) -> {
                    if (value != null && !value.equals(entry.getValue())) {
                        throw new CayenneRuntimeException("Can't add the same alias to different path segments.", new Object[0]);
                    }
                    return (String)entry.getValue();
                });
            }
        }
        int len = expression.getOperandCount();
        for (int i = 0; i < len; ++i) {
            Object operand = expression.getOperand(i);
            if (!(operand instanceof Expression)) continue;
            this.resolveAutoAliases((Expression)operand);
        }
    }

    @Override
    public Map<String, String> getPathSplitAliases() {
        return this.pathSplitAliases != null ? this.pathSplitAliases : Collections.emptyMap();
    }

    public void addPathSplitAliases(String path, String ... aliases) {
        if (aliases == null) {
            throw new NullPointerException("Null aliases");
        }
        if (aliases.length == 0) {
            throw new IllegalArgumentException("No aliases specified");
        }
        if (this.pathSplitAliases == null) {
            this.pathSplitAliases = new HashMap<String, String>();
        }
        for (String alias : aliases) {
            this.pathSplitAliases.put(alias, path);
        }
    }

    private void buildResultSetMappingForColumns(SelectQuery<?> query, EntityResolver resolver) {
        if (query.getColumns() == null || query.getColumns().isEmpty()) {
            return;
        }
        this.resultSetMapping = new ArrayList(query.getColumns().size());
        for (Property<?> column : query.getColumns()) {
            Expression exp = column.getExpression();
            boolean fullObject = false;
            if (exp.getType() == 26) {
                Object rel = exp.evaluate(this.getObjEntity());
                fullObject = rel instanceof ObjRelationship && !((ObjRelationship)rel).isToMany();
            } else if (exp.getType() == 47) {
                fullObject = true;
            }
            if (fullObject) {
                this.resultSetMapping.add(ENTITY_RESULT_SEGMENT);
                continue;
            }
            this.resultSetMapping.add(SCALAR_RESULT_SEGMENT);
        }
    }

    @Override
    public boolean isSingleResultSetMapping() {
        return this.isSingleResultSetMapping;
    }

    @Override
    public boolean isSuppressingDistinct() {
        return this.suppressingDistinct;
    }

    public void setSuppressingDistinct(boolean suppressingDistinct) {
        this.suppressingDistinct = suppressingDistinct;
    }
}

