/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.EmbeddableDescriptor;
import org.apache.cayenne.reflect.PropertyException;

public class EmbeddedFieldAccessor
implements Accessor {
    protected String propertyPath;
    protected Accessor embeddedAccessor;
    protected Accessor embeddableAccessor;
    protected EmbeddableDescriptor embeddableDescriptor;

    public EmbeddedFieldAccessor(EmbeddableDescriptor embeddableDescriptor, Accessor embeddedAccessor, Accessor embeddableAccessor) {
        this.propertyPath = embeddedAccessor.getName() + "." + embeddableAccessor.getName();
        this.embeddableDescriptor = embeddableDescriptor;
        this.embeddableAccessor = embeddableAccessor;
        this.embeddedAccessor = embeddedAccessor;
    }

    @Override
    public String getName() {
        return this.propertyPath;
    }

    @Override
    public Object getValue(Object object) throws PropertyException {
        return this.embeddableAccessor.getValue(this.getEmbeddable(object));
    }

    @Override
    public void setValue(Object object, Object newValue) throws PropertyException {
        this.embeddableAccessor.setValue(this.getEmbeddable(object), newValue);
    }

    protected Object getEmbeddable(Object owner) {
        Object embeddable = this.embeddedAccessor.getValue(owner);
        if (embeddable == null) {
            embeddable = this.embeddableDescriptor.createObject(owner, this.embeddedAccessor.getName());
            this.embeddedAccessor.setValue(owner, embeddable);
        }
        return embeddable;
    }
}

