/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;
import org.apache.commons.beanutils.converters.ShortConverter;

public class ShortConverterTestCase
extends NumberConverterTestBase {
    private Converter converter;

    public static TestSuite suite() {
        return new TestSuite(ShortConverterTestCase.class);
    }

    public ShortConverterTestCase(String name) {
        super(name);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Short.class;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new ShortConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new ShortConverter(defaultValue);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = Short.valueOf("-12");
        this.numbers[1] = Short.valueOf("13");
        this.numbers[2] = Short.valueOf("-22");
        this.numbers[3] = Short.valueOf("23");
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    public void testInvalidAmount() {
        NumberConverter converter = this.makeConverter();
        Class<Short> clazz = Short.class;
        Long min = -32768L;
        Long max = 32767L;
        Long minMinusOne = min - 1L;
        Long maxPlusOne = max + 1L;
        ShortConverterTestCase.assertEquals((String)"Minimum", (Object)Short.MIN_VALUE, (Object)converter.convert(clazz, (Object)min));
        ShortConverterTestCase.assertEquals((String)"Maximum", (Object)Short.MAX_VALUE, (Object)converter.convert(clazz, (Object)max));
        try {
            ShortConverterTestCase.assertEquals((String)"Minimum - 1", null, (Object)converter.convert(clazz, (Object)minMinusOne));
            ShortConverterTestCase.fail((String)"Less than minimum, expected ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ShortConverterTestCase.assertEquals((String)"Maximum + 1", null, (Object)converter.convert(clazz, (Object)maxPlusOne));
            ShortConverterTestCase.fail((String)"More than maximum, expected ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Short.MIN_VALUE), "-17", "-1", "0", "1", "17", String.valueOf(Short.MAX_VALUE), (byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2};
        Short[] expected = new Short[]{(short)Short.MIN_VALUE, (short)-17, (short)-1, (short)0, (short)1, (short)17, (short)Short.MAX_VALUE, (short)7, (short)8, (short)9, (short)10, (short)11, (short)12};
        for (int i = 0; i < expected.length; ++i) {
            ShortConverterTestCase.assertEquals((String)(message[i] + " to Short"), (Object)expected[i], (Object)this.converter.convert(Short.class, input[i]));
            ShortConverterTestCase.assertEquals((String)(message[i] + " to short"), (Object)expected[i], (Object)this.converter.convert(Short.TYPE, input[i]));
            ShortConverterTestCase.assertEquals((String)(message[i] + " to null type"), (Object)expected[i], (Object)this.converter.convert(null, input[i]));
        }
    }
}

