/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.jakarta;

import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.mail2.core.EmailConstants;
import org.apache.commons.mail2.core.EmailException;
import org.apache.commons.mail2.core.EmailUtils;
import org.apache.commons.mail2.jakarta.DefaultAuthenticator;
import org.apache.commons.mail2.jakarta.util.IDNEmailAddressConverter;

public abstract class Email {
    private static final InternetAddress[] EMPTY_INTERNET_ADDRESS_ARRAY = new InternetAddress[0];
    private MimeMessage message;
    private String charset;
    private InternetAddress fromAddress;
    private String subject;
    private MimeMultipart emailBody;
    private Object content;
    private String contentType;
    private boolean debug;
    private Date sentDate;
    private Authenticator authenticator;
    private String hostName;
    private String smtpPort = "25";
    private String sslSmtpPort = "465";
    private List<InternetAddress> toList = new ArrayList<InternetAddress>();
    private List<InternetAddress> ccList = new ArrayList<InternetAddress>();
    private List<InternetAddress> bccList = new ArrayList<InternetAddress>();
    private List<InternetAddress> replyList = new ArrayList<InternetAddress>();
    private String bounceAddress;
    private final Map<String, String> headers = new HashMap<String, String>();
    private boolean popBeforeSmtp;
    private String popHost;
    private String popUsername;
    private String popPassword;
    private boolean tls;
    private boolean ssl;
    private int socketTimeout = Math.toIntExact(EmailConstants.SOCKET_TIMEOUT.toMillis());
    private int socketConnectionTimeout = Math.toIntExact(EmailConstants.SOCKET_TIMEOUT.toMillis());
    private boolean startTlsEnabled;
    private boolean startTlsRequired;
    private boolean sslOnConnect;
    private boolean sslCheckServerIdentity;
    private boolean sendPartial;
    private Session session;

    public Email addBcc(String email) throws EmailException {
        return this.addBcc(email, (String)null);
    }

    public Email addBcc(String ... emails) throws EmailException {
        EmailException.checkNonEmpty((Object[])emails, () -> "BCC list invalid.");
        for (String email : emails) {
            this.addBcc(email, (String)null);
        }
        return this;
    }

    public Email addBcc(String email, String name) throws EmailException {
        return this.addBcc(email, name, this.charset);
    }

    public Email addBcc(String email, String name, String charset) throws EmailException {
        this.bccList.add(this.createInternetAddress(email, name, charset));
        return this;
    }

    public Email addCc(String email) throws EmailException {
        return this.addCc(email, (String)null);
    }

    public Email addCc(String ... emails) throws EmailException {
        EmailException.checkNonEmpty((Object[])emails, () -> "CC list invalid.");
        for (String email : emails) {
            this.addCc(email, (String)null);
        }
        return this;
    }

    public Email addCc(String email, String name) throws EmailException {
        return this.addCc(email, name, this.charset);
    }

    public Email addCc(String email, String name, String charset) throws EmailException {
        this.ccList.add(this.createInternetAddress(email, name, charset));
        return this;
    }

    public void addHeader(String name, String value) {
        if (EmailUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name can not be null or empty");
        }
        if (EmailUtils.isEmpty((String)value)) {
            throw new IllegalArgumentException("value can not be null or empty");
        }
        this.headers.put(name, value);
    }

    public Email addReplyTo(String email) throws EmailException {
        return this.addReplyTo(email, null);
    }

    public Email addReplyTo(String email, String name) throws EmailException {
        return this.addReplyTo(email, name, this.charset);
    }

    public Email addReplyTo(String email, String name, String charset) throws EmailException {
        this.replyList.add(this.createInternetAddress(email, name, charset));
        return this;
    }

    public Email addTo(String email) throws EmailException {
        return this.addTo(email, (String)null);
    }

    public Email addTo(String ... emails) throws EmailException {
        EmailException.checkNonEmpty((Object[])emails, () -> "To list invalid.");
        for (String email : emails) {
            this.addTo(email, (String)null);
        }
        return this;
    }

    public Email addTo(String email, String name) throws EmailException {
        return this.addTo(email, name, this.charset);
    }

    public Email addTo(String email, String name, String charset) throws EmailException {
        this.toList.add(this.createInternetAddress(email, name, charset));
        return this;
    }

    public void buildMimeMessage() throws EmailException {
        if (this.message != null) {
            throw new IllegalStateException("The MimeMessage is already built.");
        }
        try {
            this.message = this.createMimeMessage(this.getMailSession());
            if (EmailUtils.isNotEmpty((String)this.subject)) {
                if (EmailUtils.isNotEmpty((String)this.charset)) {
                    this.message.setSubject(this.subject, this.charset);
                } else {
                    this.message.setSubject(this.subject);
                }
            }
            this.updateContentType(this.contentType);
            if (this.content != null) {
                if ("text/plain".equalsIgnoreCase(this.contentType) && this.content instanceof String) {
                    this.message.setText(this.content.toString(), this.charset);
                } else {
                    this.message.setContent(this.content, this.contentType);
                }
            } else if (this.emailBody != null) {
                if (this.contentType == null) {
                    this.message.setContent((Multipart)this.emailBody);
                } else {
                    this.message.setContent((Object)this.emailBody, this.contentType);
                }
            } else {
                this.message.setText("");
            }
            if (this.fromAddress != null) {
                this.message.setFrom((Address)this.fromAddress);
            } else if (this.session.getProperty("mail.smtp.from") == null && this.session.getProperty("mail.from") == null) {
                throw new EmailException("From address required");
            }
            if (this.toList.size() + this.ccList.size() + this.bccList.size() == 0) {
                throw new EmailException("At least one receiver address required");
            }
            if (!EmailUtils.isEmpty(this.toList)) {
                this.message.setRecipients(Message.RecipientType.TO, (Address[])this.toInternetAddressArray(this.toList));
            }
            if (!EmailUtils.isEmpty(this.ccList)) {
                this.message.setRecipients(Message.RecipientType.CC, (Address[])this.toInternetAddressArray(this.ccList));
            }
            if (!EmailUtils.isEmpty(this.bccList)) {
                this.message.setRecipients(Message.RecipientType.BCC, (Address[])this.toInternetAddressArray(this.bccList));
            }
            if (!EmailUtils.isEmpty(this.replyList)) {
                this.message.setReplyTo((Address[])this.toInternetAddressArray(this.replyList));
            }
            if (!EmailUtils.isEmpty(this.headers)) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    String foldedValue = this.createFoldedHeaderValue(entry.getKey(), entry.getValue());
                    this.message.addHeader(entry.getKey(), foldedValue);
                }
            }
            if (this.message.getSentDate() == null) {
                this.message.setSentDate(this.getSentDate());
            }
            if (this.popBeforeSmtp) {
                Store store = this.session.getStore("pop3");
                store.connect(this.popHost, this.popUsername, this.popPassword);
            }
        }
        catch (MessagingException e) {
            throw new EmailException((Throwable)e);
        }
    }

    private void checkSessionAlreadyInitialized() {
        if (this.session != null) {
            throw new IllegalStateException("The mail session is already initialized");
        }
    }

    private String createFoldedHeaderValue(String name, String value) {
        if (EmailUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name can not be null or empty");
        }
        if (EmailUtils.isEmpty((String)value)) {
            throw new IllegalArgumentException("value can not be null or empty");
        }
        try {
            return MimeUtility.fold((int)(name.length() + 2), (String)MimeUtility.encodeText((String)value, (String)this.charset, null));
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    private InternetAddress createInternetAddress(String email, String name, String charsetName) throws EmailException {
        try {
            InternetAddress address = new InternetAddress(new IDNEmailAddressConverter().toASCII(email));
            if (EmailUtils.isNotEmpty((String)name)) {
                if (EmailUtils.isEmpty((String)charsetName)) {
                    address.setPersonal(name);
                } else {
                    Charset set = Charset.forName(charsetName);
                    address.setPersonal(name, set.name());
                }
            }
            address.validate();
            return address;
        }
        catch (AddressException | UnsupportedEncodingException e) {
            throw new EmailException(e);
        }
    }

    protected MimeMessage createMimeMessage(Session aSession) {
        return new MimeMessage(aSession);
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public List<InternetAddress> getBccAddresses() {
        return this.bccList;
    }

    public String getBounceAddress() {
        return this.bounceAddress;
    }

    public List<InternetAddress> getCcAddresses() {
        return this.ccList;
    }

    public String getCharsetName() {
        return this.charset;
    }

    public Object getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public MimeMultipart getEmailBody() {
        return this.emailBody;
    }

    public InternetAddress getFromAddress() {
        return this.fromAddress;
    }

    public String getHeader(String header) {
        return this.headers.get(header);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHostName() {
        if (this.session != null) {
            return this.session.getProperty("mail.smtp.host");
        }
        if (EmailUtils.isNotEmpty((String)this.hostName)) {
            return this.hostName;
        }
        return null;
    }

    public Session getMailSession() throws EmailException {
        if (this.session == null) {
            Properties properties = new Properties(System.getProperties());
            properties.setProperty("mail.transport.protocol", "smtp");
            if (EmailUtils.isEmpty((String)this.hostName)) {
                this.hostName = properties.getProperty("mail.smtp.host");
            }
            EmailException.checkNonEmpty((String)this.hostName, () -> "Cannot find valid hostname for mail session");
            properties.setProperty("mail.smtp.port", this.smtpPort);
            properties.setProperty("mail.smtp.host", this.hostName);
            properties.setProperty("mail.debug", String.valueOf(this.debug));
            properties.setProperty("mail.smtp.starttls.enable", Boolean.toString(this.isStartTLSEnabled()));
            properties.setProperty("mail.smtp.starttls.required", Boolean.toString(this.isStartTLSRequired()));
            properties.setProperty("mail.smtp.sendpartial", Boolean.toString(this.isSendPartial()));
            properties.setProperty("mail.smtps.sendpartial", Boolean.toString(this.isSendPartial()));
            if (this.authenticator != null) {
                properties.setProperty("mail.smtp.auth", "true");
            }
            if (this.isSSLOnConnect()) {
                properties.setProperty("mail.smtp.port", this.sslSmtpPort);
                properties.setProperty("mail.smtp.socketFactory.port", this.sslSmtpPort);
                properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                properties.setProperty("mail.smtp.socketFactory.fallback", "false");
            }
            if ((this.isSSLOnConnect() || this.isStartTLSEnabled()) && this.isSSLCheckServerIdentity()) {
                properties.setProperty("mail.smtp.ssl.checkserveridentity", "true");
            }
            if (this.bounceAddress != null) {
                properties.setProperty("mail.smtp.from", this.bounceAddress);
            }
            if (this.socketTimeout > 0) {
                properties.setProperty("mail.smtp.timeout", Integer.toString(this.socketTimeout));
            }
            if (this.socketConnectionTimeout > 0) {
                properties.setProperty("mail.smtp.connectiontimeout", Integer.toString(this.socketConnectionTimeout));
            }
            this.session = Session.getInstance((Properties)properties, (Authenticator)this.authenticator);
        }
        return this.session;
    }

    public MimeMessage getMessage() {
        return this.message;
    }

    public MimeMessage getMimeMessage() {
        return this.message;
    }

    public String getPopHost() {
        return this.popHost;
    }

    public String getPopPassword() {
        return this.popPassword;
    }

    public String getPopUserName() {
        return this.popUsername;
    }

    public List<InternetAddress> getReplyToAddresses() {
        return this.replyList;
    }

    public Date getSentDate() {
        if (this.sentDate == null) {
            return new Date();
        }
        return new Date(this.sentDate.getTime());
    }

    public String getSmtpPort() {
        if (this.session != null) {
            return this.session.getProperty("mail.smtp.port");
        }
        if (EmailUtils.isNotEmpty((String)this.smtpPort)) {
            return this.smtpPort;
        }
        return null;
    }

    public int getSocketConnectionTimeout() {
        return this.socketConnectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public String getSslSmtpPort() {
        if (this.session != null) {
            return this.session.getProperty("mail.smtp.socketFactory.port");
        }
        if (EmailUtils.isNotEmpty((String)this.sslSmtpPort)) {
            return this.sslSmtpPort;
        }
        return null;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<InternetAddress> getToAddresses() {
        return this.toList;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isPopBeforeSmtp() {
        return this.popBeforeSmtp;
    }

    public boolean isSendPartial() {
        return this.sendPartial;
    }

    public boolean isSSLCheckServerIdentity() {
        return this.sslCheckServerIdentity;
    }

    public boolean isSSLOnConnect() {
        return this.sslOnConnect || this.ssl;
    }

    public boolean isStartTLSEnabled() {
        return this.startTlsEnabled || this.tls;
    }

    public boolean isStartTLSRequired() {
        return this.startTlsRequired;
    }

    public String send() throws EmailException {
        this.buildMimeMessage();
        return this.sendMimeMessage();
    }

    public String sendMimeMessage() throws EmailException {
        Objects.requireNonNull(this.message, "MimeMessage has not been created yet");
        try {
            Transport.send((Message)this.message);
            return this.message.getMessageID();
        }
        catch (Throwable t) {
            throw new EmailException("Sending the email to the following server failed : " + this.getHostName() + ":" + this.getSmtpPort(), t);
        }
    }

    public void setAuthentication(String userName, String password) {
        this.setAuthenticator(new DefaultAuthenticator(userName, password));
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public Email setBcc(Collection<InternetAddress> collection) throws EmailException {
        EmailException.checkNonEmpty(collection, () -> "BCC list invalid");
        this.bccList = new ArrayList<InternetAddress>(collection);
        return this;
    }

    public Email setBounceAddress(String email) {
        this.checkSessionAlreadyInitialized();
        if (!EmailUtils.isEmpty((String)email)) {
            try {
                this.bounceAddress = this.createInternetAddress(email, null, this.charset).getAddress();
            }
            catch (EmailException e) {
                throw new IllegalArgumentException("Failed to set the bounce address : " + email, e);
            }
        } else {
            this.bounceAddress = email;
        }
        return this;
    }

    public Email setCc(Collection<InternetAddress> collection) throws EmailException {
        EmailException.checkNonEmpty(collection, () -> "CC list invalid");
        this.ccList = new ArrayList<InternetAddress>(collection);
        return this;
    }

    public void setCharset(String charset) {
        Charset set = Charset.forName(charset);
        this.charset = set.name();
    }

    public void setContent(MimeMultipart mimeMultipart) {
        this.emailBody = mimeMultipart;
    }

    public Email setContent(Object content) {
        this.content = content;
        return this;
    }

    public void setContent(Object content, String contentType) {
        this.content = content;
        this.updateContentType(contentType);
    }

    public Email setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Email setFrom(String email) throws EmailException {
        return this.setFrom(email, null);
    }

    public Email setFrom(String email, String name) throws EmailException {
        return this.setFrom(email, name, this.charset);
    }

    public Email setFrom(String email, String name, String charset) throws EmailException {
        this.fromAddress = this.createInternetAddress(email, name, charset);
        return this;
    }

    public Email setFromAddress(InternetAddress fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    public void setHeaders(Map<String, String> map) {
        this.headers.clear();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public void setHostName(String hostName) {
        this.checkSessionAlreadyInitialized();
        this.hostName = hostName;
    }

    public void setMailSession(Session session) {
        Objects.requireNonNull(session, "no mail session supplied");
        Properties sessionProperties = session.getProperties();
        String auth = sessionProperties.getProperty("mail.smtp.auth");
        if (Boolean.parseBoolean(auth)) {
            String userName = sessionProperties.getProperty("mail.smtp.user");
            String password = sessionProperties.getProperty("mail.smtp.password");
            if (EmailUtils.isNotEmpty((String)userName) && EmailUtils.isNotEmpty((String)password)) {
                this.authenticator = new DefaultAuthenticator(userName, password);
                this.session = Session.getInstance((Properties)sessionProperties, (Authenticator)this.authenticator);
            } else {
                this.session = session;
            }
        } else {
            this.session = session;
        }
    }

    public void setMailSessionFromJNDI(String jndiName) throws NamingException {
        if (EmailUtils.isEmpty((String)jndiName)) {
            throw new IllegalArgumentException("JNDI name missing");
        }
        Context ctx = null;
        ctx = jndiName.startsWith("java:") ? new InitialContext() : (Context)new InitialContext().lookup("java:comp/env");
        this.setMailSession((Session)ctx.lookup(jndiName));
    }

    public void setMessage(MimeMessage message) {
        this.message = message;
    }

    public abstract Email setMsg(String var1) throws EmailException;

    public Email setPopBeforeSmtp(boolean popBeforeSmtp) {
        this.popBeforeSmtp = popBeforeSmtp;
        return this;
    }

    public void setPopBeforeSmtp(boolean popBeforeSmtp, String popHost, String popUserName, String popPassword) {
        this.popBeforeSmtp = popBeforeSmtp;
        this.popHost = popHost;
        this.popUsername = popUserName;
        this.popPassword = popPassword;
    }

    public Email setPopHost(String popHost) {
        this.popHost = popHost;
        return this;
    }

    public Email setPopPassword(String popPassword) {
        this.popPassword = popPassword;
        return this;
    }

    public Email setPopUsername(String popUserName) {
        this.popUsername = popUserName;
        return this;
    }

    public Email setReplyTo(Collection<InternetAddress> collection) throws EmailException {
        EmailException.checkNonEmpty(collection, () -> "Reply to list invalid");
        this.replyList = new ArrayList<InternetAddress>(collection);
        return this;
    }

    public Email setSendPartial(boolean sendPartial) {
        this.checkSessionAlreadyInitialized();
        this.sendPartial = sendPartial;
        return this;
    }

    public void setSentDate(Date date) {
        if (date != null) {
            this.sentDate = new Date(date.getTime());
        }
    }

    public void setSmtpPort(int portNumber) {
        this.checkSessionAlreadyInitialized();
        if (portNumber < 1) {
            throw new IllegalArgumentException("Cannot connect to a port number that is less than 1 ( " + portNumber + " )");
        }
        this.smtpPort = Integer.toString(portNumber);
    }

    public void setSocketConnectionTimeout(Duration socketConnectionTimeout) {
        this.checkSessionAlreadyInitialized();
        this.socketConnectionTimeout = Math.toIntExact(socketConnectionTimeout.toMillis());
    }

    public void setSocketTimeout(Duration socketTimeout) {
        this.checkSessionAlreadyInitialized();
        this.socketTimeout = Math.toIntExact(socketTimeout.toMillis());
    }

    public Email setSSLCheckServerIdentity(boolean sslCheckServerIdentity) {
        this.checkSessionAlreadyInitialized();
        this.sslCheckServerIdentity = sslCheckServerIdentity;
        return this;
    }

    public Email setSSLOnConnect(boolean ssl) {
        this.checkSessionAlreadyInitialized();
        this.sslOnConnect = ssl;
        this.ssl = ssl;
        return this;
    }

    public void setSslSmtpPort(String sslSmtpPort) {
        this.checkSessionAlreadyInitialized();
        this.sslSmtpPort = sslSmtpPort;
    }

    public Email setStartTLSEnabled(boolean startTlsEnabled) {
        this.checkSessionAlreadyInitialized();
        this.startTlsEnabled = startTlsEnabled;
        this.tls = startTlsEnabled;
        return this;
    }

    public Email setStartTLSRequired(boolean startTlsRequired) {
        this.checkSessionAlreadyInitialized();
        this.startTlsRequired = startTlsRequired;
        return this;
    }

    public Email setSubject(String aSubject) {
        this.subject = EmailUtils.replaceEndOfLineCharactersWithSpaces((String)aSubject);
        return this;
    }

    public Email setTo(Collection<InternetAddress> collection) throws EmailException {
        EmailException.checkNonEmpty(collection, () -> "To list invalid");
        this.toList = new ArrayList<InternetAddress>(collection);
        return this;
    }

    protected InternetAddress[] toInternetAddressArray(List<InternetAddress> list) {
        return list.toArray(EMPTY_INTERNET_ADDRESS_ARRAY);
    }

    public void updateContentType(String contentType) {
        if (EmailUtils.isEmpty((String)contentType)) {
            this.contentType = null;
        } else {
            this.contentType = contentType;
            String strMarker = "; charset=";
            int charsetPos = EmailUtils.toLower((String)contentType).indexOf("; charset=");
            if (charsetPos != -1) {
                int intCharsetEnd = EmailUtils.toLower((String)contentType).indexOf(" ", charsetPos += "; charset=".length());
                this.charset = intCharsetEnd != -1 ? contentType.substring(charsetPos, intCharsetEnd) : contentType.substring(charsetPos);
            } else if (this.contentType.startsWith("text/") && EmailUtils.isNotEmpty((String)this.charset)) {
                StringBuilder contentTypeBuf = new StringBuilder(this.contentType);
                contentTypeBuf.append("; charset=");
                contentTypeBuf.append(this.charset);
                this.contentType = contentTypeBuf.toString();
            }
        }
    }
}

