/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.partitioning.bsp;

import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.bsp.BSPSubtree;

public interface BSPTree<P extends Point<P>, N extends Node<P, N>>
extends BSPSubtree<P, N> {
    public N getRoot();

    default public N findNode(P pt) {
        return this.findNode(pt, FindNodeCutRule.MINUS);
    }

    public N findNode(P var1, FindNodeCutRule var2);

    public void copy(BSPTree<P, N> var1);

    public void extract(N var1);

    public void transform(Transform<P> var1);

    public static interface Node<P extends Point<P>, N extends Node<P, N>>
    extends BSPSubtree<P, N> {
        public BSPTree<P, N> getTree();

        public int depth();

        public N getParent();

        public HyperplaneConvexSubset<P> getCut();

        public Hyperplane<P> getCutHyperplane();

        public N getMinus();

        public N getPlus();

        public boolean isLeaf();

        public boolean isInternal();

        public boolean isMinus();

        public boolean isPlus();

        public HyperplaneConvexSubset<P> trim(HyperplaneConvexSubset<P> var1);
    }

    public static enum FindNodeCutRule {
        MINUS,
        PLUS,
        NODE;

    }
}

