/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.obj;

import java.io.Closeable;
import java.io.Reader;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.euclidean.threed.obj.PolygonObjParser;

public abstract class AbstractObjPolygonReader
implements Closeable {
    private final Reader reader;
    private final PolygonObjParser parser;

    protected AbstractObjPolygonReader(Reader reader) {
        this.reader = reader;
        this.parser = new PolygonObjParser(reader);
    }

    public boolean isFailOnNonPolygonKeywords() {
        return this.parser.isFailOnNonPolygonKeywords();
    }

    public void setFailOnNonPolygonKeywords(boolean fail) {
        this.parser.setFailOnNonPolygonKeywords(fail);
    }

    @Override
    public void close() {
        GeometryIOUtils.closeUnchecked((Closeable)this.reader);
    }

    protected PolygonObjParser.Face readFace() {
        while (this.parser.nextKeyword()) {
            switch (this.parser.getCurrentKeyword()) {
                case "v": {
                    this.handleVertex(this.parser.readVector());
                    break;
                }
                case "vn": {
                    this.handleNormal(this.parser.readVector());
                    break;
                }
                case "f": {
                    return this.parser.readFace();
                }
            }
        }
        return null;
    }

    protected abstract void handleVertex(Vector3D var1);

    protected abstract void handleNormal(Vector3D var1);
}

