/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.proxy;

import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.commons.pool2.proxy.ProxiedKeyedObjectPool;
import org.apache.commons.pool2.proxy.ProxySource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseTestProxiedKeyedObjectPool {
    private static final String KEY1 = "key1";
    private static final String DATA1 = "data1";
    private KeyedObjectPool<String, TestObject> pool = null;

    @Before
    public void setUp() {
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setMaxTotal(3);
        TestKeyedObjectFactory factory = new TestKeyedObjectFactory();
        GenericKeyedObjectPool innerPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)factory, config);
        this.pool = new ProxiedKeyedObjectPool((KeyedObjectPool)innerPool, this.getproxySource());
    }

    protected abstract ProxySource<TestObject> getproxySource();

    @Test
    public void testBorrowObject() throws Exception {
        TestObject obj = (TestObject)this.pool.borrowObject((Object)KEY1);
        Assert.assertNotNull((Object)obj);
        obj.setData(DATA1);
        Assert.assertEquals((Object)DATA1, (Object)obj.getData());
        this.pool.returnObject((Object)KEY1, (Object)obj);
    }

    @Test(expected=IllegalStateException.class)
    public void testAccessAfterReturn() throws Exception {
        TestObject obj = (TestObject)this.pool.borrowObject((Object)KEY1);
        Assert.assertNotNull((Object)obj);
        obj.setData(DATA1);
        Assert.assertEquals((Object)DATA1, (Object)obj.getData());
        this.pool.returnObject((Object)KEY1, (Object)obj);
        Assert.assertNotNull((Object)obj);
        obj.getData();
    }

    @Test(expected=IllegalStateException.class)
    public void testAccessAfterInvalidate() throws Exception {
        TestObject obj = (TestObject)this.pool.borrowObject((Object)KEY1);
        Assert.assertNotNull((Object)obj);
        obj.setData(DATA1);
        Assert.assertEquals((Object)DATA1, (Object)obj.getData());
        this.pool.invalidateObject((Object)KEY1, (Object)obj);
        Assert.assertNotNull((Object)obj);
        obj.getData();
    }

    @Test
    public void testPassThroughMethods01() throws Exception {
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
        this.pool.addObject((Object)KEY1);
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)1L, (long)this.pool.getNumIdle());
        this.pool.clear();
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.pool.getNumIdle());
    }

    @Test(expected=IllegalStateException.class)
    public void testPassThroughMethods02() throws Exception {
        this.pool.close();
        this.pool.addObject((Object)KEY1);
    }

    private static class TestObjectImpl
    implements TestObject {
        private String data;

        private TestObjectImpl() {
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public void setData(String data) {
            this.data = data;
        }
    }

    protected static interface TestObject {
        public String getData();

        public void setData(String var1);
    }

    private static class TestKeyedObjectFactory
    extends BaseKeyedPooledObjectFactory<String, TestObject> {
        private TestKeyedObjectFactory() {
        }

        public TestObject create(String key) throws Exception {
            return new TestObjectImpl();
        }

        public PooledObject<TestObject> wrap(TestObject value) {
            return new DefaultPooledObject((Object)value);
        }
    }
}

