/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.common;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OrderColumn;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@Entity
@Cacheable
public class OAuthPermission
implements Serializable {
    private static final long serialVersionUID = -6486616235830491290L;
    private List<String> httpVerbs = new LinkedList<String>();
    private List<String> uris = new LinkedList<String>();
    private String permission;
    private String description;
    private boolean isDefaultPermission;
    private boolean invisibleToClient;

    public OAuthPermission() {
    }

    public OAuthPermission(String permission) {
        this.permission = permission;
    }

    public OAuthPermission(String permission, String description) {
        this.description = description;
        this.permission = permission;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    public List<String> getHttpVerbs() {
        return this.httpVerbs;
    }

    public void setHttpVerbs(List<String> httpVerbs) {
        this.httpVerbs = httpVerbs;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    public List<String> getUris() {
        return this.uris;
    }

    public void setUris(List<String> uri) {
        this.uris = uri;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Id
    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public void setDefaultPermission(boolean value) {
        this.isDefaultPermission = value;
    }

    public boolean isDefaultPermission() {
        return this.isDefaultPermission;
    }

    public boolean isInvisibleToClient() {
        return this.invisibleToClient;
    }

    public void setInvisibleToClient(boolean invisibleToClient) {
        this.invisibleToClient = invisibleToClient;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OAuthPermission)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        OAuthPermission that = (OAuthPermission)object;
        if (this.getHttpVerbs() != null && that.getHttpVerbs() == null || this.getHttpVerbs() == null && that.getHttpVerbs() != null || this.getHttpVerbs() != null && !this.getHttpVerbs().equals(that.getHttpVerbs())) {
            return false;
        }
        if (this.getUris() != null && that.getUris() == null || this.getUris() == null && that.getUris() != null || this.getUris() != null && !this.getUris().equals(that.getUris())) {
            return false;
        }
        if (!this.getPermission().equals(that.getPermission())) {
            return false;
        }
        if (this.getDescription() != null && that.getDescription() == null || this.getDescription() == null && that.getDescription() != null || this.getDescription() != null && !this.getDescription().equals(that.getDescription())) {
            return false;
        }
        return this.isInvisibleToClient() == that.isInvisibleToClient() && this.isDefaultPermission() == that.isDefaultPermission();
    }

    public int hashCode() {
        int hashCode = 17;
        if (this.getHttpVerbs() != null) {
            hashCode = 31 * hashCode + this.getHttpVerbs().hashCode();
        }
        if (this.getUris() != null) {
            hashCode = 31 * hashCode + this.getUris().hashCode();
        }
        hashCode = 31 * hashCode + this.getPermission().hashCode();
        if (this.getDescription() != null) {
            hashCode = 31 * hashCode + this.getDescription().hashCode();
        }
        hashCode = 31 * hashCode + Boolean.hashCode(this.isInvisibleToClient());
        hashCode = 31 * hashCode + Boolean.hashCode(this.isDefaultPermission());
        return hashCode;
    }
}

