/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.List;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V4;

public class SessionBindingQueryResponseMessage_V5
extends SessionBindingQueryResponseMessage_V4 {
    protected boolean supportsMulticast;
    protected boolean supportsAnycast;

    public SessionBindingQueryResponseMessage_V5(boolean exists, List<SimpleString> queueNames, boolean autoCreateQueues, boolean autoCreateAddresses, boolean defaultPurgeOnNoConsumers, int defaultMaxConsumers, Boolean defaultExclusive, Boolean defaultLastValue, SimpleString defaultLastValueKey, Boolean defaultNonDestructive, Integer defaultConsumersBeforeDispatch, Long defaultDelayBeforeDispatch, boolean supportsMulticast, boolean supportsAnycast) {
        super((byte)-22);
        this.exists = exists;
        this.queueNames = queueNames;
        this.autoCreateQueues = autoCreateQueues;
        this.autoCreateAddresses = autoCreateAddresses;
        this.defaultPurgeOnNoConsumers = defaultPurgeOnNoConsumers;
        this.defaultMaxConsumers = defaultMaxConsumers;
        this.defaultExclusive = defaultExclusive;
        this.defaultLastValue = defaultLastValue;
        this.defaultLastValueKey = defaultLastValueKey;
        this.defaultNonDestructive = defaultNonDestructive;
        this.defaultConsumersBeforeDispatch = defaultConsumersBeforeDispatch;
        this.defaultDelayBeforeDispatch = defaultDelayBeforeDispatch;
        this.supportsMulticast = supportsMulticast;
        this.supportsAnycast = supportsAnycast;
    }

    public SessionBindingQueryResponseMessage_V5() {
        super((byte)-22);
    }

    public Boolean isSupportsMulticast() {
        return this.supportsMulticast;
    }

    public Boolean isSupportsAnycast() {
        return this.supportsAnycast;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeBoolean(this.supportsMulticast);
        buffer.writeBoolean(this.supportsAnycast);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        if (buffer.readableBytes() > 0) {
            this.supportsMulticast = buffer.readBoolean();
            this.supportsAnycast = buffer.readBoolean();
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.supportsMulticast, this.supportsAnycast);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", supportsMulticast=" + this.supportsMulticast);
        sb.append(", supportsAnycast=" + this.supportsAnycast);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionBindingQueryResponseMessage_V5)) {
            return false;
        }
        SessionBindingQueryResponseMessage_V5 other = (SessionBindingQueryResponseMessage_V5)obj;
        return this.supportsMulticast == other.supportsMulticast && this.supportsAnycast == other.supportsAnycast;
    }
}

