/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.io.Serializable;
import java.io.StringReader;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.json.JsonString;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.JsonLoader;

public class QueueConfiguration
implements Serializable {
    public static final String MIRROR_ADDRESS = "$ACTIVEMQ_ARTEMIS_MIRROR";
    private static final long serialVersionUID = 2601016432150225938L;
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String ADDRESS = "address";
    public static final String ROUTING_TYPE = "routing-type";
    public static final String FILTER_STRING = "filter-string";
    public static final String DURABLE = "durable";
    public static final String USER = "user";
    public static final String MAX_CONSUMERS = "max-consumers";
    public static final String EXCLUSIVE = "exclusive";
    public static final String GROUP_REBALANCE = "group-rebalance";
    public static final String GROUP_REBALANCE_PAUSE_DISPATCH = "group-rebalance-pause-dispatch";
    public static final String GROUP_BUCKETS = "group-buckets";
    public static final String GROUP_FIRST_KEY = "group-first-key";
    public static final String LAST_VALUE = "last-value";
    public static final String LAST_VALUE_KEY = "last-value-key";
    public static final String NON_DESTRUCTIVE = "non-destructive";
    public static final String PURGE_ON_NO_CONSUMERS = "purge-on-no-consumers";
    public static final String ENABLED = "enabled";
    public static final String CONSUMERS_BEFORE_DISPATCH = "consumers-before-dispatch";
    public static final String DELAY_BEFORE_DISPATCH = "delay-before-dispatch";
    public static final String CONSUMER_PRIORITY = "consumer-priority";
    public static final String AUTO_DELETE = "auto-delete";
    public static final String AUTO_DELETE_DELAY = "auto-delete-delay";
    public static final String AUTO_DELETE_MESSAGE_COUNT = "auto-delete-message-count";
    public static final String RING_SIZE = "ring-size";
    public static final String CONFIGURATION_MANAGED = "configuration-managed";
    public static final String TEMPORARY = "temporary";
    public static final String AUTO_CREATE_ADDRESS = "auto-create-address";
    public static final String INTERNAL = "internal";
    public static final String TRANSIENT = "transient";
    public static final String AUTO_CREATED = "auto-created";
    public static final String FQQN = "fqqn";
    private Long id;
    private SimpleString name;
    private SimpleString address;
    private RoutingType routingType;
    private SimpleString filterString;
    private Boolean durable;
    private SimpleString user;
    private Integer maxConsumers;
    private Boolean exclusive;
    private Boolean groupRebalance;
    private Boolean groupRebalancePauseDispatch;
    private Integer groupBuckets;
    private SimpleString groupFirstKey;
    private Boolean lastValue;
    private SimpleString lastValueKey;
    private Boolean nonDestructive;
    private Boolean purgeOnNoConsumers;
    private Boolean enabled;
    private Integer consumersBeforeDispatch;
    private Long delayBeforeDispatch;
    private Integer consumerPriority;
    private Boolean autoDelete;
    private Long autoDeleteDelay;
    private Long autoDeleteMessageCount;
    private Long ringSize;
    private Boolean configurationManaged;
    private Boolean temporary;
    private Boolean autoCreateAddress;
    private Boolean internal;
    private Boolean _transient;
    private Boolean autoCreated;
    private Boolean fqqn;

    public static QueueConfiguration of(String name) {
        return new QueueConfiguration(name);
    }

    public static QueueConfiguration of(SimpleString name) {
        return new QueueConfiguration(name);
    }

    public static QueueConfiguration of(QueueConfiguration queueConfiguration) {
        return new QueueConfiguration(queueConfiguration);
    }

    @Deprecated(forRemoval=true)
    public QueueConfiguration() {
    }

    @Deprecated(forRemoval=true)
    public QueueConfiguration(QueueConfiguration o) {
        this.id = o.id;
        this.name = o.name;
        this.address = o.address;
        this.routingType = o.routingType;
        this.filterString = o.filterString;
        this.durable = o.durable;
        this.user = o.user;
        this.maxConsumers = o.maxConsumers;
        this.exclusive = o.exclusive;
        this.groupRebalance = o.groupRebalance;
        this.groupRebalancePauseDispatch = o.groupRebalancePauseDispatch;
        this.groupBuckets = o.groupBuckets;
        this.groupFirstKey = o.groupFirstKey;
        this.lastValue = o.lastValue;
        this.lastValueKey = o.lastValueKey;
        this.nonDestructive = o.nonDestructive;
        this.purgeOnNoConsumers = o.purgeOnNoConsumers;
        this.enabled = o.enabled;
        this.consumersBeforeDispatch = o.consumersBeforeDispatch;
        this.delayBeforeDispatch = o.delayBeforeDispatch;
        this.consumerPriority = o.consumerPriority;
        this.autoDelete = o.autoDelete;
        this.autoDeleteDelay = o.autoDeleteDelay;
        this.autoDeleteMessageCount = o.autoDeleteMessageCount;
        this.ringSize = o.ringSize;
        this.configurationManaged = o.configurationManaged;
        this.temporary = o.temporary;
        this.autoCreateAddress = o.autoCreateAddress;
        this.internal = o.internal;
        this._transient = o._transient;
        this.autoCreated = o.autoCreated;
        this.fqqn = o.fqqn;
    }

    @Deprecated(forRemoval=true)
    public QueueConfiguration(SimpleString name) {
        this.setName(name);
    }

    @Deprecated(forRemoval=true)
    public QueueConfiguration(String name) {
        this(SimpleString.of(name));
    }

    public QueueConfiguration set(String key, String value) {
        if (key != null && value != null) {
            if (key.equals(NAME)) {
                this.setName(value);
            } else if (key.equals(ADDRESS)) {
                this.setAddress(value);
            } else if (key.equals(ROUTING_TYPE)) {
                this.setRoutingType(RoutingType.valueOf(value));
            } else if (key.equals(FILTER_STRING)) {
                this.setFilterString(value);
            } else if (key.equals(DURABLE)) {
                this.setDurable(Boolean.valueOf(value));
            } else if (key.equals(USER)) {
                this.setUser(SimpleString.of(value));
            } else if (key.equals(MAX_CONSUMERS)) {
                this.setMaxConsumers(Integer.valueOf(value));
            } else if (key.equals(EXCLUSIVE)) {
                this.setExclusive(Boolean.valueOf(value));
            } else if (key.equals(GROUP_REBALANCE)) {
                this.setGroupRebalance(Boolean.valueOf(value));
            } else if (key.equals(GROUP_REBALANCE_PAUSE_DISPATCH)) {
                this.setGroupRebalancePauseDispatch(Boolean.valueOf(value));
            } else if (key.equals(GROUP_BUCKETS)) {
                this.setGroupBuckets(Integer.valueOf(value));
            } else if (key.equals(GROUP_FIRST_KEY)) {
                this.setGroupFirstKey(value);
            } else if (key.equals(LAST_VALUE)) {
                this.setLastValue(Boolean.valueOf(value));
            } else if (key.equals(LAST_VALUE_KEY)) {
                this.setLastValueKey(value);
            } else if (key.equals(NON_DESTRUCTIVE)) {
                this.setNonDestructive(Boolean.valueOf(value));
            } else if (key.equals(PURGE_ON_NO_CONSUMERS)) {
                this.setPurgeOnNoConsumers(Boolean.valueOf(value));
            } else if (key.equals(ENABLED)) {
                this.setEnabled(Boolean.valueOf(value));
            } else if (key.equals(CONSUMERS_BEFORE_DISPATCH)) {
                this.setConsumersBeforeDispatch(Integer.valueOf(value));
            } else if (key.equals(DELAY_BEFORE_DISPATCH)) {
                this.setDelayBeforeDispatch(Long.valueOf(value));
            } else if (key.equals(CONSUMER_PRIORITY)) {
                this.setConsumerPriority(Integer.valueOf(value));
            } else if (key.equals(AUTO_DELETE)) {
                this.setAutoDelete(Boolean.valueOf(value));
            } else if (key.equals(AUTO_DELETE_DELAY)) {
                this.setAutoDeleteDelay(Long.valueOf(value));
            } else if (key.equals(AUTO_DELETE_MESSAGE_COUNT)) {
                this.setAutoDeleteMessageCount(Long.valueOf(value));
            } else if (key.equals(RING_SIZE)) {
                this.setRingSize(Long.valueOf(value));
            } else if (key.equals(CONFIGURATION_MANAGED)) {
                this.setConfigurationManaged(Boolean.valueOf(value));
            } else if (key.equals(TEMPORARY)) {
                this.setTemporary(Boolean.valueOf(value));
            } else if (key.equals(AUTO_CREATE_ADDRESS)) {
                this.setAutoCreateAddress(Boolean.valueOf(value));
            } else if (key.equals(INTERNAL)) {
                this.setInternal(Boolean.valueOf(value));
            } else if (key.equals(TRANSIENT)) {
                this.setTransient(Boolean.valueOf(value));
            } else if (key.equals(AUTO_CREATED)) {
                this.setAutoCreated(Boolean.valueOf(value));
            }
        }
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public QueueConfiguration setId(Long id) {
        this.id = id;
        return this;
    }

    public SimpleString getAddress() {
        return Objects.requireNonNullElse(this.address, this.getName());
    }

    public boolean isAddressNull() {
        return this.address == null;
    }

    public QueueConfiguration setAddress(SimpleString address) {
        if (CompositeAddress.isFullyQualified(address)) {
            this.name = CompositeAddress.extractQueueName(address);
            this.address = CompositeAddress.extractAddressName(address);
            this.fqqn = Boolean.TRUE;
        } else {
            this.address = address;
        }
        return this;
    }

    public QueueConfiguration setAddress(String address) {
        return this.setAddress(SimpleString.of(address));
    }

    public SimpleString getName() {
        return this.name;
    }

    public QueueConfiguration setName(SimpleString name) {
        if (CompositeAddress.isFullyQualified(name)) {
            this.name = CompositeAddress.extractQueueName(name);
            this.address = CompositeAddress.extractAddressName(name);
            this.fqqn = Boolean.TRUE;
        } else {
            this.name = name;
        }
        return this;
    }

    public QueueConfiguration setName(String name) {
        return this.setName(SimpleString.of(name));
    }

    public RoutingType getRoutingType() {
        return this.routingType;
    }

    public QueueConfiguration setRoutingType(RoutingType routingType) {
        this.routingType = routingType;
        return this;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public QueueConfiguration setFilterString(SimpleString filterString) {
        this.filterString = filterString == null || filterString.isEmpty() || filterString.isBlank() ? null : filterString;
        return this;
    }

    public QueueConfiguration setFilterString(String filterString) {
        return this.setFilterString(SimpleString.of(filterString));
    }

    public Boolean isDurable() {
        return Objects.requireNonNullElse(this.durable, true);
    }

    public QueueConfiguration setDurable(Boolean durable) {
        this.durable = durable;
        return this;
    }

    public SimpleString getUser() {
        return this.user;
    }

    public QueueConfiguration setUser(SimpleString user) {
        this.user = user;
        return this;
    }

    public QueueConfiguration setUser(String user) {
        return this.setUser(SimpleString.of(user));
    }

    public Integer getMaxConsumers() {
        return this.maxConsumers;
    }

    public QueueConfiguration setMaxConsumers(Integer maxConsumers) {
        this.maxConsumers = maxConsumers;
        return this;
    }

    public Boolean isExclusive() {
        return this.exclusive;
    }

    public QueueConfiguration setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    public Boolean isLastValue() {
        return this.lastValue;
    }

    public QueueConfiguration setLastValue(Boolean lastValue) {
        this.lastValue = lastValue;
        return this;
    }

    public SimpleString getLastValueKey() {
        return this.lastValueKey;
    }

    public QueueConfiguration setLastValueKey(SimpleString lastValueKey) {
        this.lastValueKey = lastValueKey;
        return this;
    }

    public QueueConfiguration setLastValueKey(String lastValueKey) {
        return this.setLastValueKey(SimpleString.of(lastValueKey));
    }

    public Boolean isNonDestructive() {
        return this.nonDestructive;
    }

    public QueueConfiguration setNonDestructive(Boolean nonDestructive) {
        this.nonDestructive = nonDestructive;
        return this;
    }

    public Boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    public QueueConfiguration setPurgeOnNoConsumers(Boolean purgeOnNoConsumers) {
        this.purgeOnNoConsumers = purgeOnNoConsumers;
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public QueueConfiguration setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Integer getConsumersBeforeDispatch() {
        return this.consumersBeforeDispatch;
    }

    public QueueConfiguration setConsumersBeforeDispatch(Integer consumersBeforeDispatch) {
        this.consumersBeforeDispatch = consumersBeforeDispatch;
        return this;
    }

    public Long getDelayBeforeDispatch() {
        return this.delayBeforeDispatch;
    }

    public QueueConfiguration setDelayBeforeDispatch(Long delayBeforeDispatch) {
        this.delayBeforeDispatch = delayBeforeDispatch;
        return this;
    }

    public Integer getConsumerPriority() {
        return this.consumerPriority;
    }

    public QueueConfiguration setConsumerPriority(Integer consumerPriority) {
        this.consumerPriority = consumerPriority;
        return this;
    }

    public Boolean isGroupRebalance() {
        return this.groupRebalance;
    }

    public QueueConfiguration setGroupRebalance(Boolean groupRebalance) {
        this.groupRebalance = groupRebalance;
        return this;
    }

    public Boolean isGroupRebalancePauseDispatch() {
        return this.groupRebalancePauseDispatch;
    }

    public QueueConfiguration setGroupRebalancePauseDispatch(Boolean groupRebalancePauseDispatch) {
        this.groupRebalancePauseDispatch = groupRebalancePauseDispatch;
        return this;
    }

    public Integer getGroupBuckets() {
        return this.groupBuckets;
    }

    public QueueConfiguration setGroupBuckets(Integer groupBuckets) {
        this.groupBuckets = groupBuckets;
        return this;
    }

    public SimpleString getGroupFirstKey() {
        return this.groupFirstKey;
    }

    public QueueConfiguration setGroupFirstKey(SimpleString groupFirstKey) {
        this.groupFirstKey = groupFirstKey;
        return this;
    }

    public QueueConfiguration setGroupFirstKey(String groupFirstKey) {
        return this.setGroupFirstKey(SimpleString.of(groupFirstKey));
    }

    public Boolean isAutoDelete() {
        return this.autoDelete;
    }

    public QueueConfiguration setAutoDelete(Boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
    }

    public Long getAutoDeleteDelay() {
        return this.autoDeleteDelay;
    }

    public QueueConfiguration setAutoDeleteDelay(Long autoDeleteDelay) {
        this.autoDeleteDelay = autoDeleteDelay;
        return this;
    }

    public Long getAutoDeleteMessageCount() {
        return this.autoDeleteMessageCount;
    }

    public QueueConfiguration setAutoDeleteMessageCount(Long autoDeleteMessageCount) {
        this.autoDeleteMessageCount = autoDeleteMessageCount;
        return this;
    }

    public Long getRingSize() {
        return this.ringSize;
    }

    public QueueConfiguration setRingSize(Long ringSize) {
        this.ringSize = ringSize;
        return this;
    }

    public Boolean isConfigurationManaged() {
        return Objects.requireNonNullElse(this.configurationManaged, false);
    }

    public QueueConfiguration setConfigurationManaged(Boolean configurationManaged) {
        this.configurationManaged = configurationManaged;
        return this;
    }

    public Boolean isTemporary() {
        return Objects.requireNonNullElse(this.temporary, false);
    }

    public QueueConfiguration setTemporary(Boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    public Boolean isAutoCreateAddress() {
        return this.autoCreateAddress;
    }

    public QueueConfiguration setAutoCreateAddress(Boolean autoCreateAddress) {
        this.autoCreateAddress = autoCreateAddress;
        return this;
    }

    public Boolean isInternal() {
        return Objects.requireNonNullElse(this.internal, false);
    }

    public QueueConfiguration setInternal(Boolean internal) {
        this.internal = internal;
        return this;
    }

    public Boolean isTransient() {
        return Objects.requireNonNullElse(this._transient, false);
    }

    public QueueConfiguration setTransient(Boolean _transient) {
        this._transient = _transient;
        return this;
    }

    public Boolean isAutoCreated() {
        return Objects.requireNonNullElse(this.autoCreated, false);
    }

    public QueueConfiguration setAutoCreated(Boolean autoCreated) {
        this.autoCreated = autoCreated;
        return this;
    }

    public Boolean isFqqn() {
        return Objects.requireNonNullElse(this.fqqn, Boolean.FALSE);
    }

    public String toJSON() {
        JsonObjectBuilder builder = JsonLoader.createObjectBuilder();
        if (this.getId() != null) {
            builder.add(ID, this.getId());
        }
        if (this.getName() != null) {
            builder.add(NAME, this.getName().toString());
        }
        if (this.getAddress() != null) {
            builder.add(ADDRESS, this.getAddress().toString());
        }
        if (this.getRoutingType() != null) {
            builder.add(ROUTING_TYPE, this.getRoutingType().toString().toUpperCase());
        }
        if (this.getFilterString() != null) {
            builder.add(FILTER_STRING, this.getFilterString().toString());
        }
        if (this.isDurable() != null) {
            builder.add(DURABLE, this.isDurable());
        }
        if (this.getUser() != null) {
            builder.add(USER, this.getUser().toString());
        }
        if (this.getMaxConsumers() != null) {
            builder.add(MAX_CONSUMERS, this.getMaxConsumers());
        }
        if (this.isExclusive() != null) {
            builder.add(EXCLUSIVE, this.isExclusive());
        }
        if (this.isGroupRebalance() != null) {
            builder.add(GROUP_REBALANCE, this.isGroupRebalance());
        }
        if (this.isGroupRebalancePauseDispatch() != null) {
            builder.add(GROUP_REBALANCE_PAUSE_DISPATCH, this.isGroupRebalancePauseDispatch());
        }
        if (this.getGroupBuckets() != null) {
            builder.add(GROUP_BUCKETS, this.getGroupBuckets());
        }
        if (this.getGroupFirstKey() != null) {
            builder.add(GROUP_FIRST_KEY, this.getGroupFirstKey().toString());
        }
        if (this.isLastValue() != null) {
            builder.add(LAST_VALUE, this.isLastValue());
        }
        if (this.getLastValueKey() != null) {
            builder.add(LAST_VALUE_KEY, this.getLastValueKey().toString());
        }
        if (this.isNonDestructive() != null) {
            builder.add(NON_DESTRUCTIVE, this.isNonDestructive());
        }
        if (this.isPurgeOnNoConsumers() != null) {
            builder.add(PURGE_ON_NO_CONSUMERS, this.isPurgeOnNoConsumers());
        }
        if (this.isEnabled() != null) {
            builder.add(ENABLED, this.isEnabled());
        }
        if (this.getConsumersBeforeDispatch() != null) {
            builder.add(CONSUMERS_BEFORE_DISPATCH, this.getConsumersBeforeDispatch());
        }
        if (this.getDelayBeforeDispatch() != null) {
            builder.add(DELAY_BEFORE_DISPATCH, this.getDelayBeforeDispatch());
        }
        if (this.getConsumerPriority() != null) {
            builder.add(CONSUMER_PRIORITY, this.getConsumerPriority());
        }
        if (this.isAutoDelete() != null) {
            builder.add(AUTO_DELETE, this.isAutoDelete());
        }
        if (this.getAutoDeleteDelay() != null) {
            builder.add(AUTO_DELETE_DELAY, this.getAutoDeleteDelay());
        }
        if (this.getAutoDeleteMessageCount() != null) {
            builder.add(AUTO_DELETE_MESSAGE_COUNT, this.getAutoDeleteMessageCount());
        }
        if (this.getRingSize() != null) {
            builder.add(RING_SIZE, this.getRingSize());
        }
        if (this.isConfigurationManaged() != null) {
            builder.add(CONFIGURATION_MANAGED, this.isConfigurationManaged());
        }
        if (this.isTemporary() != null) {
            builder.add(TEMPORARY, this.isTemporary());
        }
        if (this.isAutoCreateAddress() != null) {
            builder.add(AUTO_CREATE_ADDRESS, this.isAutoCreateAddress());
        }
        if (this.isInternal() != null) {
            builder.add(INTERNAL, this.isInternal());
        }
        if (this.isTransient() != null) {
            builder.add(TRANSIENT, this.isTransient());
        }
        if (this.isAutoCreated() != null) {
            builder.add(AUTO_CREATED, this.isAutoCreated());
        }
        if (this.isFqqn() != null) {
            builder.add(FQQN, this.isFqqn());
        }
        return builder.build().toString();
    }

    public static QueueConfiguration fromJSON(String jsonString) {
        JsonObject json = JsonLoader.readObject(new StringReader(jsonString));
        if (!json.containsKey(NAME)) {
            return null;
        }
        QueueConfiguration result = QueueConfiguration.of(json.getString(NAME));
        for (Map.Entry entry : json.entrySet()) {
            result.set((String)entry.getKey(), ((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.STRING ? ((JsonString)entry.getValue()).getString() : ((JsonValue)entry.getValue()).toString());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QueueConfiguration)) {
            return false;
        }
        QueueConfiguration other = (QueueConfiguration)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.address, other.address) && Objects.equals((Object)this.routingType, (Object)other.routingType) && Objects.equals(this.filterString, other.filterString) && Objects.equals(this.durable, other.durable) && Objects.equals(this.user, other.user) && Objects.equals(this.maxConsumers, other.maxConsumers) && Objects.equals(this.exclusive, other.exclusive) && Objects.equals(this.groupRebalance, other.groupRebalance) && Objects.equals(this.groupRebalancePauseDispatch, other.groupRebalancePauseDispatch) && Objects.equals(this.groupBuckets, other.groupBuckets) && Objects.equals(this.groupFirstKey, other.groupFirstKey) && Objects.equals(this.lastValue, other.lastValue) && Objects.equals(this.lastValueKey, other.lastValueKey) && Objects.equals(this.nonDestructive, other.nonDestructive) && Objects.equals(this.purgeOnNoConsumers, other.purgeOnNoConsumers) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.consumersBeforeDispatch, other.consumersBeforeDispatch) && Objects.equals(this.delayBeforeDispatch, other.delayBeforeDispatch) && Objects.equals(this.consumerPriority, other.consumerPriority) && Objects.equals(this.autoDelete, other.autoDelete) && Objects.equals(this.autoDeleteDelay, other.autoDeleteDelay) && Objects.equals(this.autoDeleteMessageCount, other.autoDeleteMessageCount) && Objects.equals(this.ringSize, other.ringSize) && Objects.equals(this.configurationManaged, other.configurationManaged) && Objects.equals(this.temporary, other.temporary) && Objects.equals(this.autoCreateAddress, other.autoCreateAddress) && Objects.equals(this.internal, other.internal) && Objects.equals(this._transient, other._transient) && Objects.equals(this.autoCreated, other.autoCreated) && Objects.equals(this.fqqn, other.fqqn);
    }

    public boolean isMirrorQueue() {
        return this.isInternal() != false && this.name != null && this.name.toString().startsWith(MIRROR_ADDRESS);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.address, this.routingType, this.filterString, this.durable, this.user, this.maxConsumers, this.exclusive, this.groupRebalance, this.groupRebalancePauseDispatch, this.groupBuckets, this.groupFirstKey, this.lastValue, this.lastValueKey, this.nonDestructive, this.purgeOnNoConsumers, this.enabled, this.consumersBeforeDispatch, this.delayBeforeDispatch, this.consumerPriority, this.autoDelete, this.autoDeleteDelay, this.autoDeleteMessageCount, this.ringSize, this.configurationManaged, this.temporary, this.autoCreateAddress, this.internal, this._transient, this.autoCreated, this.fqqn});
    }

    public String toString() {
        return "QueueConfiguration [id=" + this.id + ", name=" + String.valueOf(this.name) + ", address=" + String.valueOf(this.address) + ", routingType=" + String.valueOf((Object)this.routingType) + ", filterString=" + String.valueOf(this.filterString) + ", durable=" + this.durable + ", user=" + String.valueOf(this.user) + ", maxConsumers=" + this.maxConsumers + ", exclusive=" + this.exclusive + ", groupRebalance=" + this.groupRebalance + ", groupRebalancePauseDispatch=" + this.groupRebalancePauseDispatch + ", groupBuckets=" + this.groupBuckets + ", groupFirstKey=" + String.valueOf(this.groupFirstKey) + ", lastValue=" + this.lastValue + ", lastValueKey=" + String.valueOf(this.lastValueKey) + ", nonDestructive=" + this.nonDestructive + ", purgeOnNoConsumers=" + this.purgeOnNoConsumers + ", enabled=" + this.enabled + ", consumersBeforeDispatch=" + this.consumersBeforeDispatch + ", delayBeforeDispatch=" + this.delayBeforeDispatch + ", consumerPriority=" + this.consumerPriority + ", autoDelete=" + this.autoDelete + ", autoDeleteDelay=" + this.autoDeleteDelay + ", autoDeleteMessageCount=" + this.autoDeleteMessageCount + ", ringSize=" + this.ringSize + ", configurationManaged=" + this.configurationManaged + ", temporary=" + this.temporary + ", autoCreateAddress=" + this.autoCreateAddress + ", internal=" + this.internal + ", transient=" + this._transient + ", autoCreated=" + this.autoCreated + ", fqqn=" + this.fqqn + "]";
    }
}

