/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.impl;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCredits;
import org.apache.activemq.artemis.core.client.impl.ClientProducerFlowCallback;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeMetrics;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.spi.core.protocol.EmbedMessageUtil;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeImpl
implements Bridge,
SessionFailureListener,
SendAcknowledgementHandler,
ReadyListener,
ClientProducerFlowCallback {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final ServerLocatorInternal serverLocator;
    protected final Executor executor;
    protected final ScheduledExecutorService scheduledExecutor;
    private final ReusableLatch pendingAcks = new ReusableLatch(0);
    private final UUID nodeUUID;
    private final long sequentialID;
    protected final Queue queue;
    private final Filter filter;
    final Map<Long, MessageReference> refs = new LinkedHashMap<Long, MessageReference>();
    private final Transformer transformer;
    private final Object connectionGuard = new Object();
    private boolean blockedOnFlowControl;
    protected ScheduledFuture<?> scheduledReconnection;
    protected volatile ClientSessionInternal session;
    protected volatile ClientSessionInternal sessionConsumer;
    protected volatile boolean disconnectedAndDown = false;
    protected String targetNodeID;
    protected TopologyMember targetNode;
    private volatile ClientSessionFactoryInternal csf;
    private volatile ClientProducer producer;
    private volatile State state = State.STOPPED;
    private boolean deliveringLargeMessage;
    private int reconnectAttemptsInUse;
    private int retryCount = 0;
    private NotificationService notificationService;
    private boolean keepConnecting = true;
    private final ActiveMQServer server;
    private final BridgeMetrics metrics = new BridgeMetrics();
    private final BridgeConfiguration configuration;
    private final OperationContextImpl bridgeContext;
    private final Lock statusLock = new ReentrantLock();

    public BridgeImpl(ServerLocatorInternal serverLocator, BridgeConfiguration configuration, UUID nodeUUID, Queue queue, Executor executor, ScheduledExecutorService scheduledExecutor, ActiveMQServer server) throws ActiveMQException {
        this.sequentialID = server.getStorageManager().generateID();
        this.configuration = configuration;
        this.reconnectAttemptsInUse = configuration.getInitialConnectAttempts();
        this.serverLocator = serverLocator;
        this.nodeUUID = nodeUUID;
        this.queue = queue;
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
        this.transformer = server.getServiceRegistry().getBridgeTransformer(configuration.getName(), configuration.getTransformerConfiguration());
        this.filter = FilterImpl.createFilter(configuration.getFilterString());
        this.server = server;
        this.bridgeContext = new OperationContextImpl(executor);
    }

    public static final byte[] getDuplicateBytes(UUID nodeUUID, long messageID) {
        byte[] bytes = new byte[24];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.put(nodeUUID.asBytes());
        bb.putLong(messageID);
        return bytes;
    }

    public boolean isBlockedOnFlowControl() {
        return this.blockedOnFlowControl;
    }

    public ClientSessionFactory getSessionFactory() {
        return this.csf;
    }

    public ServerLocatorInternal getServerLocator() {
        return this.serverLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> getDeliveringMessages() {
        Map<Long, MessageReference> map = this.refs;
        synchronized (map) {
            return new ArrayList<MessageReference>(this.refs.values());
        }
    }

    private static void cleanUpSessionFactory(ClientSessionFactoryInternal factory) {
        if (factory != null) {
            factory.cleanup();
        }
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void onCreditsFlow(boolean blocked, ClientProducerCredits producerCredits) {
        if (logger.isTraceEnabled()) {
            logger.trace("Bridge {} received credits, with blocked = {}", (Object)this.configuration.getName(), (Object)blocked);
        }
        this.blockedOnFlowControl = blocked;
        if (!blocked) {
            this.queue.deliverAsync();
        }
    }

    public void onCreditsFail(ClientProducerCredits producerCredits) {
        ActiveMQServerLogger.LOGGER.bridgeAddressFull(String.valueOf(producerCredits.getAddress()), this.configuration.getName());
        this.disconnect();
    }

    @Override
    public long sequentialID() {
        return this.sequentialID;
    }

    public void start() throws Exception {
        this.statusLock.lock();
        try {
            State localState = this.state;
            if (localState == State.STARTING || localState == State.STARTED || localState == State.STOPPING || localState == State.PAUSING) {
                logger.debug("Bridge {} state is {}. Ignoring call to start.", (Object)this.configuration.getName(), (Object)localState);
                if (localState == State.STOPPING || localState == State.PAUSING) {
                    throw ActiveMQMessageBundle.BUNDLE.bridgeOperationCannotBeExecuted(this.configuration.getName(), "started", localState);
                }
                return;
            }
            this.state = State.STARTING;
            logger.debug("Bridge {} is starting", (Object)this.configuration.getName());
            this.executor.execute(new ConnectRunnable());
            this.sendNotification(CoreNotificationType.BRIDGE_STARTED);
        }
        finally {
            this.statusLock.unlock();
        }
    }

    @Override
    public String debug() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRefs() {
        LinkedList<MessageReference> list;
        Map<Long, MessageReference> map = this.refs;
        synchronized (map) {
            list = new LinkedList<MessageReference>(this.refs.values());
            this.refs.clear();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("BridgeImpl::cancelRefs cancelling {} references", (Object)list.size());
        }
        if (logger.isTraceEnabled() && list.isEmpty()) {
            logger.trace("didn't have any references to cancel on bridge {}", (Object)this);
            return;
        }
        ListIterator<MessageReference> listIterator = list.listIterator(list.size());
        long timeBase = System.currentTimeMillis();
        while (listIterator.hasPrevious()) {
            MessageReference ref = listIterator.previous();
            logger.trace("BridgeImpl::cancelRefs Cancelling reference {} on bridge {}", (Object)ref, (Object)this);
            Queue refqueue = ref.getQueue();
            try {
                refqueue.cancel(ref, timeBase);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorCancellingRefOnBridge(ref, e);
            }
        }
    }

    @Override
    public void flushExecutor() {
        FutureLatch future = new FutureLatch();
        this.executor.execute((Runnable)future);
        boolean ok = future.await(10000L);
        if (!ok) {
            ActiveMQServerLogger.LOGGER.timedOutWaitingToStopBridge();
        }
    }

    @Override
    public void disconnect() {
        this.executor.execute(() -> {
            if (this.session != null) {
                try {
                    this.session.cleanUp(false);
                }
                catch (Exception dontcare) {
                    logger.debug(dontcare.getMessage(), (Throwable)dontcare);
                }
                this.session = null;
            }
            if (this.sessionConsumer != null) {
                try {
                    this.sessionConsumer.cleanUp(false);
                }
                catch (Exception dontcare) {
                    logger.debug(dontcare.getMessage(), (Throwable)dontcare);
                }
                this.sessionConsumer = null;
            }
        });
    }

    @Override
    public boolean isConnected() {
        return this.session != null && !this.session.isClosed();
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void stop() throws Exception {
        this.statusLock.lock();
        try {
            State localState = this.state;
            if (localState == State.STOPPING || localState == State.STOPPED || localState == State.PAUSING) {
                logger.debug("Bridge {} state is {}. Ignoring call to stop.", (Object)this.configuration.getName(), (Object)localState);
                if (localState == State.PAUSING) {
                    throw ActiveMQMessageBundle.BUNDLE.bridgeOperationCannotBeExecuted(this.configuration.getName(), "stopped", localState);
                }
                return;
            }
            this.state = State.STOPPING;
            logger.debug("Bridge {} is stopping", (Object)this.configuration.getName());
            if (this.scheduledReconnection != null) {
                this.scheduledReconnection.cancel(true);
            }
            this.executor.execute(new StopRunnable());
        }
        finally {
            this.statusLock.unlock();
        }
    }

    @Override
    public void pause() throws Exception {
        this.statusLock.lock();
        try {
            State localState = this.state;
            if (localState == State.STOPPING || localState == State.STOPPED || localState == State.PAUSING || localState == State.PAUSED) {
                logger.debug("Bridge {} state is {}. Ignoring call to pause.", (Object)this.configuration.getName(), (Object)localState);
                if (localState == State.STOPPING || localState == State.STOPPED) {
                    throw ActiveMQMessageBundle.BUNDLE.bridgeOperationCannotBeExecuted(this.configuration.getName(), "paused", localState);
                }
                return;
            }
            this.state = State.PAUSING;
            logger.info("Bridge {} is pausing", (Object)this.configuration.getName());
            this.executor.execute(new PauseRunnable());
        }
        finally {
            this.statusLock.unlock();
        }
    }

    @Override
    public void resume() throws Exception {
        this.queue.addConsumer(this);
        this.queue.deliverAsync();
    }

    public boolean isStarted() {
        return this.state == State.STARTING || this.state == State.STARTED;
    }

    @Override
    public SimpleString getName() {
        return SimpleString.of((String)this.configuration.getName());
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public SimpleString getForwardingAddress() {
        return SimpleString.of((String)this.configuration.getForwardingAddress());
    }

    @Override
    public RemotingConnection getForwardingConnection() {
        if (this.session == null) {
            return null;
        }
        return this.session.getConnection();
    }

    public void sendFailed(Message message, Exception e) {
        ActiveMQServerLogger.LOGGER.bridgeFailedToSend(this.configuration.getName(), message.toString(), e.getClass().getSimpleName(), e.getMessage());
        if (e instanceof ActiveMQAddressFullException) {
            this.failed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAcknowledged(Message message) {
        block12: {
            OperationContext oldContext = OperationContextImpl.getContext();
            try {
                OperationContextImpl.setContext(this.bridgeContext);
                logger.debug("Bridge {} received confirmation for message {}", (Object)this.configuration.getName(), (Object)message);
                State localState = this.state;
                if (localState == State.STARTED || localState == State.STOPPING || localState == State.PAUSING) {
                    try {
                        MessageReference ref;
                        Map<Long, MessageReference> map = this.refs;
                        synchronized (map) {
                            ref = this.refs.remove(message.getMessageID());
                        }
                        if (ref != null) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("BridgeImpl::sendAcknowledged bridge {} Acking {} on queue {}", new Object[]{this, ref, ref.getQueue()});
                            }
                            ref.getQueue().acknowledge(ref);
                            this.pendingAcks.countDown();
                            this.metrics.incrementMessagesAcknowledged();
                            if (this.server.hasBrokerBridgePlugins()) {
                                this.server.callBrokerBridgePlugins(plugin -> plugin.afterAcknowledgeBridge(this, ref));
                            }
                            break block12;
                        }
                        logger.trace("BridgeImpl::sendAcknowledged bridge {} could not find reference for message {}", (Object)this, (Object)message);
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.bridgeFailedToAck(e);
                    }
                    break block12;
                }
                logger.debug("Bridge {} state is {}. Ignoring call to sendAcknowledged.", (Object)this.configuration.getName(), (Object)localState);
            }
            finally {
                OperationContextImpl.setContext(oldContext);
            }
        }
    }

    @Override
    public void failed(Throwable t) {
        if (t instanceof ActiveMQException) {
            ActiveMQException activeMQException = (ActiveMQException)t;
            this.connectionFailed(activeMQException, false);
        } else {
            ActiveMQException exception = new ActiveMQException(t.getMessage());
            exception.initCause(t);
            this.connectionFailed(exception, false);
        }
    }

    protected Message beforeForward(Message message, SimpleString forwardingAddress) {
        message = message.copy();
        ((RefCountMessage)message).setParentRef((RefCountMessage)message);
        return this.beforeForwardingNoCopy(message, forwardingAddress);
    }

    protected Message beforeForwardingNoCopy(Message message, SimpleString forwardingAddress) {
        if (this.configuration.isUseDuplicateDetection()) {
            byte[] bytes = BridgeImpl.getDuplicateBytes(this.nodeUUID, message.getMessageID());
            message.putExtraBytesProperty(Message.HDR_BRIDGE_DUPLICATE_ID, bytes);
        }
        if (forwardingAddress != null) {
            message.setAddress(forwardingAddress);
        }
        switch (this.configuration.getRoutingType()) {
            case ANYCAST: {
                message.setRoutingType(RoutingType.ANYCAST);
                break;
            }
            case MULTICAST: {
                message.setRoutingType(RoutingType.MULTICAST);
                break;
            }
            case STRIP: {
                message.setRoutingType(null);
                break;
            }
        }
        message.messageChanged();
        if (this.transformer != null) {
            Message transformedMessage = this.transformer.transform(message);
            if (transformedMessage != message) {
                logger.debug("The transformer {} made a copy of the message {} as transformedMessage", (Object)this.transformer, (Object)message);
            }
            return EmbedMessageUtil.embedAsCoreMessage(transformedMessage);
        }
        return EmbedMessageUtil.embedAsCoreMessage(message);
    }

    public void readyForWriting() {
        this.queue.deliverAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleStatus handle(MessageReference ref) throws Exception {
        if (RefCountMessage.isRefTraceEnabled() && ref.getMessage() instanceof RefCountMessage) {
            RefCountMessage.deferredDebug((Message)ref.getMessage(), (String)"Going through the bridge", (Object[])new Object[0]);
        }
        if (this.filter != null && !this.filter.match(ref.getMessage())) {
            logger.trace("message reference {} is no match for bridge {}", (Object)ref, (Object)this.configuration.getName());
            return HandleStatus.NO_MATCH;
        }
        if (this.statusLock.tryLock()) {
            try {
                if (this.state != State.STARTED || !this.session.isWritable((ReadyListener)this)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}::Ignoring reference on bridge as it is set to inactive ref {}, active = false", (Object)this, (Object)ref);
                    }
                    HandleStatus handleStatus = HandleStatus.BUSY;
                    return handleStatus;
                }
                if (this.blockedOnFlowControl) {
                    logger.debug("Bridge {} is blocked on flow control, cannot receive {}", (Object)this.configuration.getName(), (Object)ref);
                    HandleStatus handleStatus = HandleStatus.BUSY;
                    return handleStatus;
                }
                if (this.deliveringLargeMessage) {
                    logger.trace("Bridge {} is busy delivering a large message", (Object)this.configuration.getName());
                    HandleStatus handleStatus = HandleStatus.BUSY;
                    return handleStatus;
                }
                logger.trace("Bridge {} is handling reference {} ", (Object)this.configuration.getName(), (Object)ref);
                ref.handled();
                Map<Long, MessageReference> map = this.refs;
                synchronized (map) {
                    this.refs.put(ref.getMessage().getMessageID(), ref);
                }
                SimpleString dest = this.configuration.getForwardingAddress() != null ? SimpleString.of((String)this.configuration.getForwardingAddress()) : ref.getMessage().getAddressSimpleString();
                Message message = this.beforeForward(ref.getMessage(), dest);
                this.pendingAcks.countUp();
                try {
                    HandleStatus status;
                    if (this.server.hasBrokerBridgePlugins()) {
                        this.server.callBrokerBridgePlugins(plugin -> plugin.beforeDeliverBridge(this, ref));
                    }
                    if (message.isLargeMessage()) {
                        this.deliveringLargeMessage = true;
                        this.deliverLargeMessage(dest, ref, (LargeServerMessage)message);
                        status = HandleStatus.HANDLED;
                    } else {
                        status = this.deliverStandardMessage(dest, ref, message, ref.getMessage());
                    }
                    if (status == HandleStatus.HANDLED) {
                        this.metrics.incrementMessagesPendingAcknowledgement();
                    }
                    if (this.server.hasBrokerBridgePlugins()) {
                        this.server.callBrokerBridgePlugins(plugin -> plugin.afterDeliverBridge(this, ref, status));
                    }
                    HandleStatus handleStatus = status;
                    return handleStatus;
                }
                catch (Exception e) {
                    this.pendingAcks.countDown();
                    throw e;
                }
            }
            finally {
                this.statusLock.unlock();
            }
        }
        return HandleStatus.BUSY;
    }

    @Override
    public void proceedDeliver(MessageReference ref) {
    }

    public void connectionFailed(ActiveMQException me, boolean failedOver) {
        this.connectionFailed(me, failedOver, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
        if (this.server.isStarted()) {
            if (me instanceof ActiveMQDisconnectedException) {
                ActiveMQServerLogger.LOGGER.bridgeConnectionClosed(failedOver);
            } else {
                ActiveMQServerLogger.LOGGER.bridgeConnectionFailed(failedOver);
            }
        }
        Object object = this.connectionGuard;
        synchronized (object) {
            this.keepConnecting = true;
        }
        try {
            if (this.producer != null) {
                this.producer.close();
            }
            BridgeImpl.cleanUpSessionFactory(this.csf);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.session.cleanUp(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (scaleDownTargetNodeID != null && !scaleDownTargetNodeID.equals(this.nodeUUID.toString())) {
            this.scaleDown(scaleDownTargetNodeID);
        } else if (scaleDownTargetNodeID != null) {
            logger.debug("Received scaleDownTargetNodeID: {}; cancelling reconnect.", (Object)scaleDownTargetNodeID);
            this.fail(true, true);
        } else {
            logger.debug("Received null scaleDownTargetNodeID");
            this.fail(me.getType() == ActiveMQExceptionType.DISCONNECTED, false);
        }
        this.tryScheduleRetryReconnect(me.getType());
    }

    protected void scaleDown(String scaleDownTargetNodeID) {
        this.statusLock.lock();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Moving {} messages from {} to {}", new Object[]{this.queue.getMessageCount(), this.queue.getName(), scaleDownTargetNodeID});
            }
            ((QueueImpl)this.queue).moveReferencesBetweenSnFQueues(SimpleString.of((String)scaleDownTargetNodeID));
            this.fail(true, true);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            this.statusLock.unlock();
        }
    }

    protected void tryScheduleRetryReconnect(ActiveMQExceptionType type) {
        this.scheduleRetryConnect();
    }

    public void beforeReconnect(ActiveMQException exception) {
    }

    private void deliverLargeMessage(SimpleString dest, MessageReference ref, LargeServerMessage message) {
        this.executor.execute(() -> {
            logger.trace("going to send large message: {} from {}", (Object)message, (Object)this.queue);
            try {
                this.producer.send(dest, message.toMessage());
                this.unsetLargeMessageDelivery();
                if (this.queue != null) {
                    this.queue.deliverAsync();
                }
            }
            catch (ActiveMQException e) {
                this.unsetLargeMessageDelivery();
                ActiveMQServerLogger.LOGGER.bridgeUnableToSendMessage(ref, (Exception)((Object)e));
                this.connectionFailed(e, false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HandleStatus deliverStandardMessage(SimpleString dest, MessageReference ref, Message message, Message originalMessage) {
        logger.trace("going to send message: {} from {}", (Object)message, (Object)this.queue);
        try {
            this.producer.send(dest, message);
        }
        catch (ActiveMQException e) {
            ActiveMQServerLogger.LOGGER.bridgeUnableToSendMessage(ref, (Exception)((Object)e));
            Object object = this.refs;
            synchronized (object) {
                this.refs.remove(message.getMessageID());
                ((QueueImpl)ref.getQueue()).decDelivering(ref);
            }
            this.connectionFailed(e, false);
            object = HandleStatus.BUSY;
            return object;
        }
        finally {
            originalMessage.usageDown();
        }
        return HandleStatus.HANDLED;
    }

    public TopologyMember getTargetNodeFromTopology() {
        return this.targetNode;
    }

    @Override
    public BridgeMetrics getMetrics() {
        return this.metrics;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " [name=" + this.configuration.getName() + ", queue=" + String.valueOf(this.queue) + " targetConnector=" + String.valueOf(this.serverLocator) + "]";
    }

    @Override
    public String toManagementString() {
        return this.getClass().getSimpleName() + " [name=" + this.configuration.getName() + ", queue=" + String.valueOf(this.queue.getName()) + "/" + this.queue.getID() + "]";
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public BridgeConfiguration getConfiguration() {
        return this.configuration;
    }

    public State getState() {
        return this.state;
    }

    protected void fail(boolean permanently, boolean scaleDown) {
        logger.debug("{}\n\t::fail being called, permanently={}", (Object)this, (Object)permanently);
        if (this.targetNodeID != null) {
            this.disconnectedAndDown = true;
            this.serverLocator.notifyNodeDown(System.currentTimeMillis(), this.targetNodeID);
        }
        if (this.queue != null) {
            try {
                logger.trace("Removing consumer on fail {} from queue {}", (Object)this, (Object)this.queue);
                this.queue.removeConsumer(this);
            }
            catch (Exception dontcare) {
                logger.debug(dontcare.getMessage(), (Throwable)dontcare);
            }
        }
        this.cancelRefs();
        if (this.queue != null) {
            this.queue.deliverAsync();
        }
    }

    protected void afterConnect() throws Exception {
        if (this.disconnectedAndDown && this.targetNodeID != null && this.targetNode != null) {
            this.serverLocator.notifyNodeUp(System.currentTimeMillis(), this.targetNodeID, this.targetNode.getBackupGroupName(), this.targetNode.getScaleDownGroupName(), new Pair((Object)this.targetNode.getPrimary(), (Object)this.targetNode.getBackup()), false);
            this.disconnectedAndDown = false;
        }
        this.retryCount = 0;
        this.reconnectAttemptsInUse = this.configuration.getReconnectAttempts();
        if (this.scheduledReconnection != null) {
            this.scheduledReconnection.cancel(true);
            this.scheduledReconnection = null;
        }
    }

    protected ClientSessionFactoryInternal createSessionFactory() throws Exception {
        if (this.targetNodeID != null && (this.configuration.getReconnectAttemptsOnSameNode() < 0 || this.retryCount <= this.configuration.getReconnectAttemptsOnSameNode())) {
            this.csf = this.reconnectOnOriginalNode();
        } else {
            this.serverLocator.resetToInitialConnectors();
            this.csf = (ClientSessionFactoryInternal)this.serverLocator.createSessionFactory();
        }
        if (this.csf != null) {
            this.csf.setReconnectAttempts(0);
        }
        return this.csf;
    }

    protected ClientSessionFactoryInternal reconnectOnOriginalNode() throws Exception {
        String targetNodeIdUse = this.targetNodeID;
        TopologyMember nodeUse = this.targetNode;
        if (targetNodeIdUse != null && nodeUse != null) {
            TransportConfiguration[] configs = new TransportConfiguration[2];
            int numberOfConfigs = 0;
            if (nodeUse.getPrimary() != null) {
                configs[numberOfConfigs++] = nodeUse.getPrimary();
            }
            if (nodeUse.getBackup() != null) {
                configs[numberOfConfigs++] = nodeUse.getBackup();
            }
            if (numberOfConfigs > 0) {
                int nodeTry = (this.retryCount - 1) % numberOfConfigs;
                return (ClientSessionFactoryInternal)this.serverLocator.createSessionFactory(configs[nodeTry]);
            }
        }
        return null;
    }

    protected void setSessionFactory(ClientSessionFactoryInternal sfi) {
        this.csf = sfi;
    }

    protected void scheduleRetryConnect() {
        if (this.serverLocator.isClosed()) {
            ActiveMQServerLogger.LOGGER.bridgeLocatorShutdown();
            return;
        }
        if (this.state == State.STOPPING || this.state == State.PAUSING) {
            ActiveMQServerLogger.LOGGER.bridgeWillNotRetry(this.state == State.STOPPING ? "stopping" : "pausing");
            return;
        }
        if (this.reconnectAttemptsInUse >= 0 && this.retryCount > this.reconnectAttemptsInUse) {
            ActiveMQServerLogger.LOGGER.bridgeAbortStart(this.configuration.getName(), this.retryCount, this.configuration.getReconnectAttempts());
            this.fail(true, false);
            return;
        }
        long timeout = (long)((double)this.configuration.getRetryInterval() * Math.pow(this.configuration.getRetryIntervalMultiplier(), this.retryCount));
        if (timeout == 0L) {
            timeout = this.configuration.getRetryInterval();
        }
        if (timeout > this.configuration.getMaxRetryInterval()) {
            timeout = this.configuration.getMaxRetryInterval();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bridge {} retrying connection #{}, maxRetry={}, timeout={}", new Object[]{this, this.retryCount, this.reconnectAttemptsInUse, timeout});
        }
        this.scheduleRetryConnectFixedTimeout(timeout);
    }

    protected void nodeUP(TopologyMember member, boolean last) {
        if (member != null) {
            RemotingConnection connectionToUse;
            ClientSessionInternal sessionToUse = this.session;
            RemotingConnection remotingConnection = connectionToUse = sessionToUse != null ? sessionToUse.getConnection() : null;
            if (this.targetNodeID != null && this.targetNodeID.equals(member.getNodeId())) {
                this.targetNode = member;
            } else if (connectionToUse != null && member.isMember(connectionToUse)) {
                this.targetNode = member;
                this.targetNodeID = member.getNodeId();
            }
        }
    }

    protected void scheduleRetryConnectFixedTimeout(long milliseconds) {
        try {
            BridgeImpl.cleanUpSessionFactory(this.csf);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.state == State.STOPPING || this.state == State.STOPPED || this.state == State.PAUSING || this.state == State.PAUSED) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Scheduling retry for bridge {} in {} milliseconds", (Object)this.configuration.getName(), (Object)milliseconds);
        }
        this.scheduledReconnection = this.scheduledExecutor.schedule(new ScheduledConnectRunnable(), milliseconds, TimeUnit.MILLISECONDS);
    }

    private void internalCancelReferences() {
        this.cancelRefs();
        if (this.queue != null) {
            this.queue.deliverAsync();
        }
    }

    private void unsetLargeMessageDelivery() {
        this.deliveringLargeMessage = false;
    }

    private void sendNotification(CoreNotificationType type) {
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(SimpleString.of((String)"name"), this.getName());
            Notification notification = new Notification(this.nodeUUID.toString(), (NotificationType)type, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.notificationBridgeError(this.configuration.getName(), type, e);
            }
        }
    }

    public static enum State {
        STARTING,
        STARTED,
        PAUSING,
        PAUSED,
        STOPPING,
        STOPPED;

    }

    private class ConnectRunnable
    implements Runnable {
        private ConnectRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (BridgeImpl.this.state == State.STOPPING || BridgeImpl.this.state == State.PAUSING) {
                logger.debug("Bridge {} state is {}. Ignoring call to connect.", (Object)BridgeImpl.this.configuration.getName(), (Object)BridgeImpl.this.state);
                return;
            }
            Object object = BridgeImpl.this.connectionGuard;
            synchronized (object) {
                if (!BridgeImpl.this.keepConnecting) {
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Connecting  {} to its destination [{}], csf={}", new Object[]{this, BridgeImpl.this.nodeUUID, BridgeImpl.this.csf});
                }
                ++BridgeImpl.this.retryCount;
                try {
                    if (BridgeImpl.this.csf == null || BridgeImpl.this.csf.isClosed()) {
                        if (BridgeImpl.this.state == State.STOPPING || BridgeImpl.this.state == State.PAUSING) {
                            return;
                        }
                        if (BridgeImpl.this.csf != null && BridgeImpl.this.csf.isClosed()) {
                            BridgeImpl.this.serverLocator.factoryClosed((ClientSessionFactory)BridgeImpl.this.csf);
                        }
                        BridgeImpl.this.csf = BridgeImpl.this.createSessionFactory();
                        if (BridgeImpl.this.csf == null) {
                            BridgeImpl.this.scheduleRetryConnect();
                            return;
                        }
                        BridgeImpl.this.session = (ClientSessionInternal)BridgeImpl.this.csf.createSession(BridgeImpl.this.configuration.getUser(), BridgeImpl.this.configuration.getPassword(), false, true, true, true, 1, BridgeImpl.this.configuration.getClientId());
                        BridgeImpl.this.session.getProducerCreditManager().setCallback((ClientProducerFlowCallback)BridgeImpl.this);
                        BridgeImpl.this.sessionConsumer = (ClientSessionInternal)BridgeImpl.this.csf.createSession(BridgeImpl.this.configuration.getUser(), BridgeImpl.this.configuration.getPassword(), false, true, true, true, 1, BridgeImpl.this.configuration.getClientId());
                    }
                    if (BridgeImpl.this.configuration.getForwardingAddress() != null) {
                        ClientSession.AddressQuery query = null;
                        try {
                            query = BridgeImpl.this.session.addressQuery(SimpleString.of((String)BridgeImpl.this.configuration.getForwardingAddress()));
                        }
                        catch (Throwable e) {
                            ActiveMQServerLogger.LOGGER.errorQueryingBridge(BridgeImpl.this.configuration.getName(), e);
                            --BridgeImpl.this.retryCount;
                            BridgeImpl.this.scheduleRetryConnectFixedTimeout(100L);
                            return;
                        }
                        if (!query.isExists()) {
                            ActiveMQServerLogger.LOGGER.errorQueryingBridge(BridgeImpl.this.configuration.getForwardingAddress(), BridgeImpl.this.retryCount);
                            BridgeImpl.this.scheduleRetryConnect();
                            return;
                        }
                    }
                    BridgeImpl.this.blockedOnFlowControl = false;
                    BridgeImpl.this.producer = BridgeImpl.this.session.createProducer();
                    BridgeImpl.this.session.addFailureListener((SessionFailureListener)BridgeImpl.this);
                    BridgeImpl.this.session.setSendAcknowledgementHandler((SendAcknowledgementHandler)BridgeImpl.this);
                    BridgeImpl.this.afterConnect();
                    BridgeImpl.this.state = State.STARTED;
                    BridgeImpl.this.queue.addConsumer(BridgeImpl.this);
                    BridgeImpl.this.queue.deliverAsync();
                    ActiveMQServerLogger.LOGGER.bridgeConnected(BridgeImpl.this);
                    BridgeImpl.this.serverLocator.addClusterTopologyListener(new ClusterTopologyListener(){

                        public void nodeUP(TopologyMember member, boolean last) {
                            BridgeImpl.this.nodeUP(member, last);
                        }

                        public void nodeDown(long eventUID, String nodeID) {
                        }
                    });
                    BridgeImpl.this.keepConnecting = false;
                }
                catch (ActiveMQException e) {
                    if (e.getType() == ActiveMQExceptionType.SESSION_CREATION_REJECTED) {
                        ActiveMQServerLogger.LOGGER.errorStartingBridge(BridgeImpl.this.configuration.getName());
                        --BridgeImpl.this.retryCount;
                        BridgeImpl.this.scheduleRetryConnectFixedTimeout(BridgeImpl.this.configuration.getRetryInterval());
                    } else {
                        ActiveMQServerLogger.LOGGER.errorConnectingBridgeRetry(BridgeImpl.this);
                        logger.debug("Underlying bridge connection failure", (Throwable)e);
                        BridgeImpl.this.scheduleRetryConnect();
                    }
                }
                catch (InterruptedException | ActiveMQInterruptedException e) {
                    ActiveMQServerLogger.LOGGER.errorConnectingBridge(BridgeImpl.this, (Exception)e);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorConnectingBridge(BridgeImpl.this, e);
                    if (BridgeImpl.this.csf != null) {
                        try {
                            BridgeImpl.this.csf.close();
                            BridgeImpl.this.csf = null;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    BridgeImpl.this.fail(false, false);
                    BridgeImpl.this.scheduleRetryConnect();
                }
            }
        }
    }

    private class StopRunnable
    implements Runnable {
        private StopRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                logger.debug("stopping bridge {}", (Object)BridgeImpl.this);
                logger.trace("Removing consumer on stopRunnable {} from queue {}", (Object)this, (Object)BridgeImpl.this.queue);
                BridgeImpl.this.queue.removeConsumer(BridgeImpl.this);
                if (!BridgeImpl.this.pendingAcks.await(BridgeImpl.this.configuration.getPendingAckTimeout(), TimeUnit.MILLISECONDS)) {
                    ActiveMQServerLogger.LOGGER.timedOutWaitingForSendAcks("Stopping", BridgeImpl.this.configuration.getName(), BridgeImpl.this.pendingAcks.getCount());
                }
                BridgeImpl.this.statusLock.lock();
                try {
                    BridgeImpl.this.state = State.STOPPED;
                }
                finally {
                    BridgeImpl.this.statusLock.unlock();
                }
                if (BridgeImpl.this.session != null) {
                    logger.debug("Cleaning up session {} for bridge {}", (Object)BridgeImpl.this.session, (Object)BridgeImpl.this.configuration.getName());
                    BridgeImpl.this.session.removeFailureListener((SessionFailureListener)BridgeImpl.this);
                    try {
                        BridgeImpl.this.session.close();
                        BridgeImpl.this.session = null;
                    }
                    catch (ActiveMQException activeMQException) {
                        // empty catch block
                    }
                }
                if (BridgeImpl.this.sessionConsumer != null) {
                    logger.debug("Cleaning up session {}", (Object)BridgeImpl.this.session);
                    try {
                        BridgeImpl.this.sessionConsumer.close();
                        BridgeImpl.this.sessionConsumer = null;
                    }
                    catch (ActiveMQException activeMQException) {
                        // empty catch block
                    }
                }
                BridgeImpl.this.internalCancelReferences();
                if (BridgeImpl.this.csf != null) {
                    BridgeImpl.this.csf.cleanup();
                }
                Object object = BridgeImpl.this.connectionGuard;
                synchronized (object) {
                    BridgeImpl.this.keepConnecting = true;
                }
                BridgeImpl.this.sendNotification(CoreNotificationType.BRIDGE_STOPPED);
                ActiveMQServerLogger.LOGGER.bridgeStopped(BridgeImpl.this.configuration.getName());
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorStoppingBridge(BridgeImpl.this.configuration.getName(), e);
            }
        }
    }

    private class PauseRunnable
    implements Runnable {
        private PauseRunnable() {
        }

        @Override
        public void run() {
            try {
                logger.debug("pausing bridge {}", (Object)BridgeImpl.this);
                logger.trace("Removing consumer on pauseRunnable {} from queue {}", (Object)this, (Object)BridgeImpl.this.queue);
                BridgeImpl.this.queue.removeConsumer(BridgeImpl.this);
                if (!BridgeImpl.this.pendingAcks.await(BridgeImpl.this.configuration.getPendingAckTimeout(), TimeUnit.MILLISECONDS)) {
                    ActiveMQServerLogger.LOGGER.timedOutWaitingForSendAcks("Pausing", BridgeImpl.this.configuration.getName(), BridgeImpl.this.pendingAcks.getCount());
                }
                BridgeImpl.this.statusLock.lock();
                try {
                    BridgeImpl.this.state = State.PAUSED;
                }
                finally {
                    BridgeImpl.this.statusLock.unlock();
                }
                BridgeImpl.this.internalCancelReferences();
                BridgeImpl.this.sendNotification(CoreNotificationType.BRIDGE_STOPPED);
                ActiveMQServerLogger.LOGGER.bridgePaused(BridgeImpl.this.configuration.getName());
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorPausingBridge(BridgeImpl.this.configuration.getName(), e);
            }
        }
    }

    private class ScheduledConnectRunnable
    implements Runnable {
        private ScheduledConnectRunnable() {
        }

        @Override
        public void run() {
            if (BridgeImpl.this.isStarted()) {
                BridgeImpl.this.executor.execute(new ConnectRunnable());
            }
        }
    }
}

