/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.SourcePath;

public class SourceElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<SourceElement> parents = new ParentList(this);
    private final List<SourceElement> children = new ChildList(this);
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    public SourceElement(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        this.name = name;
    }

    public SourceElement(SourceElementName sourceElementName) {
        this(sourceElementName.getName());
    }

    public String getName() {
        return this.name;
    }

    public SourceElement getParent() {
        if (this.parents.size() == 0) {
            return null;
        }
        return this.parents.get(0);
    }

    public List<SourceElement> getParents() {
        return this.parents;
    }

    public List<SourceElement> getChildren() {
        return this.children;
    }

    public List<SourceElement> getChildren(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        ArrayList<SourceElement> result = new ArrayList<SourceElement>();
        for (SourceElement sourceElement : this.children) {
            if (!name.equals(sourceElement.getName())) continue;
            result.add(sourceElement);
        }
        return result;
    }

    public List<SourceElement> getChildren(SourceElementName sourceElementName) {
        return this.getChildren(sourceElementName.getName());
    }

    public SourceElement getChild(String name) {
        for (SourceElement sourceElement : this.children) {
            if (!name.equals(sourceElement.getName())) continue;
            return sourceElement;
        }
        return null;
    }

    public SourceElement getChild(SourceElementName sourceElementName) {
        return this.getChild(sourceElementName.getName());
    }

    public boolean hasChild(String name) {
        return SourcePath.hasChild(this, name);
    }

    public SourceElement getFirstChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.get(0);
    }

    public SourceElement getLastChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.get(this.children.size() - 1);
    }

    public List<SourceElement> getFollowing(String name) {
        return SourcePath.getFollowing(this, name);
    }

    public SourceElement getFollowingSourceElement(SourceElement parent) {
        if (!this.parents.contains(parent)) {
            throw new IllegalArgumentException("parent is not a parent of this SourceElement");
        }
        ListIterator<SourceElement> sameLevelIt = SourcePath.getSiblingIteratorPositionedOnSelf(this, parent);
        if (!sameLevelIt.hasNext()) {
            return null;
        }
        return sameLevelIt.next();
    }

    public boolean hasFollowing() {
        return SourcePath.hasFollowing(this);
    }

    public boolean hasPreceding() {
        return SourcePath.hasPreceding(this);
    }

    public boolean hasFollowingSibling() {
        return SourcePath.hasFollowingSibling(this);
    }

    public boolean hasPrecedingSibling() {
        return SourcePath.hasPrecedingSibling(this);
    }

    public List<SourceElement> getPreceding(String name) {
        return SourcePath.getPreceding(this, name);
    }

    public SourceElement getPrecedingSourceElement(SourceElement parent) {
        if (!this.parents.contains(parent)) {
            throw new IllegalArgumentException("parent is not a parent of this SourceElement");
        }
        ListIterator<SourceElement> sameLevelIt = SourcePath.getSiblingIteratorPositionedOnSelf(this, parent);
        sameLevelIt.previous();
        if (!sameLevelIt.hasPrevious()) {
            return null;
        }
        return sameLevelIt.previous();
    }

    public Object getTextAttribute() {
        return this.attributes.get(null);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object getAttribute(SourceAttributeName sourceAttributeName) {
        return this.getAttribute(sourceAttributeName.getName());
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.attributes.remove(name);
        }
        return this.attributes.put(name, value);
    }

    public Object setAttribute(SourceAttributeName sourceAttributeName, Object value) {
        return this.setAttribute(sourceAttributeName.getName(), value);
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public SourceElement copy() {
        HashMap<SourceElement, SourceElement> copied = new HashMap<SourceElement, SourceElement>();
        return this.copy(this, copied);
    }

    private SourceElement copy(SourceElement toCopy, Map<SourceElement, SourceElement> copiedElements) {
        SourceElement copied = copiedElements.get(toCopy);
        if (copied != null) {
            return copied;
        }
        copied = new SourceElement(toCopy.getName());
        copiedElements.put(toCopy, copied);
        for (String attributeName : toCopy.getAttributeNames()) {
            copied.setAttribute(attributeName, toCopy.getAttribute(attributeName));
        }
        List<SourceElement> childrenOfCopied = copied.getChildren();
        for (SourceElement child : toCopy.getChildren()) {
            SourceElement copiedChild = this.copy(child, copiedElements);
            if (childrenOfCopied.contains(copiedChild)) continue;
            childrenOfCopied.add(copiedChild);
        }
        List<SourceElement> parentsOfCopied = copied.getParents();
        for (SourceElement parent : toCopy.getParents()) {
            SourceElement copiedParent = this.copy(parent, copiedElements);
            if (parentsOfCopied.contains(copiedParent)) continue;
            parentsOfCopied.add(copiedParent);
        }
        return copied;
    }

    public boolean graphEquals(SourceElement toCompare) {
        HashSet<SourceElement> alreadyCompared = new HashSet<SourceElement>();
        return this.graphEquals(this, toCompare, alreadyCompared);
    }

    private boolean graphEquals(SourceElement reference, SourceElement toCompare, Set<SourceElement> compared) {
        if (reference == null && toCompare != null || reference != null && toCompare == null) {
            return false;
        }
        if (reference == null && toCompare == null || compared.contains(reference)) {
            return true;
        }
        compared.add(reference);
        if (!reference.getName().equals(toCompare.getName())) {
            return false;
        }
        if (reference.getAttributeNames().size() != toCompare.getAttributeNames().size()) {
            return false;
        }
        for (String attributeName : reference.getAttributeNames()) {
            Object toCompareAttributeContent;
            Object referenceAttributeContent = reference.getAttribute(attributeName);
            if (Objects.equals(referenceAttributeContent, toCompareAttributeContent = toCompare.getAttribute(attributeName))) continue;
            return false;
        }
        if (!this.graphEquals(reference.getParent(), toCompare.getParent(), compared)) {
            return false;
        }
        if (reference.getChildren().size() != toCompare.getChildren().size()) {
            return false;
        }
        Iterator<SourceElement> referenceChildIt = reference.getChildren().iterator();
        Iterator<SourceElement> toCompareChildIt = toCompare.getChildren().iterator();
        while (referenceChildIt.hasNext()) {
            SourceElement toCompareChild;
            SourceElement referenceChild = referenceChildIt.next();
            if (this.graphEquals(referenceChild, toCompareChild = toCompareChildIt.next(), compared)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        HashSet<SourceElement> alreadyProcessed = new HashSet<SourceElement>();
        StringBuilder result = new StringBuilder();
        this.toString(alreadyProcessed, result);
        return result.toString();
    }

    private void toString(Set<SourceElement> alreadyProcessed, StringBuilder result) {
        alreadyProcessed.add(this);
        result.append("(name=").append(this.name).append(",attributes=(");
        Iterator<Map.Entry<String, Object>> entryIt = this.attributes.entrySet().iterator();
        while (entryIt.hasNext()) {
            Map.Entry<String, Object> entry = entryIt.next();
            result.append(entry.getKey()).append("=").append(entry.getValue());
            if (!entryIt.hasNext()) continue;
            result.append(",");
        }
        result.append("),children=(");
        Iterator<SourceElement> childIt = this.children.iterator();
        while (childIt.hasNext()) {
            SourceElement child = childIt.next();
            if (alreadyProcessed.contains(child)) {
                result.append("<<loop detected>>");
            } else {
                child.toString(alreadyProcessed, result);
            }
            if (!childIt.hasNext()) continue;
            result.append(",");
        }
        result.append("))");
    }

    private static class ParentList
    extends AbstractList<SourceElement> {
        private final SourceElement sourceElement;
        private final List<SourceElement> parents = new ArrayList<SourceElement>();

        public ParentList(SourceElement sourceElement) {
            if (sourceElement == null) {
                throw new NullPointerException("sourceElement must not be null");
            }
            this.sourceElement = sourceElement;
        }

        @Override
        public SourceElement get(int index) {
            return this.parents.get(index);
        }

        @Override
        public int size() {
            return this.parents.size();
        }

        @Override
        public void add(int position, SourceElement parent) {
            if (this.parents.contains(parent)) {
                throw new IllegalArgumentException("Element " + String.valueOf(parent) + " is already a parent of " + String.valueOf(this.sourceElement));
            }
            this.parents.add(position, parent);
            List<SourceElement> children = parent.getChildren();
            if (!children.contains(this.sourceElement)) {
                children.add(this.sourceElement);
            }
        }

        @Override
        public SourceElement remove(int index) {
            SourceElement result = this.parents.remove(index);
            result.getChildren().remove(this.sourceElement);
            return result;
        }

        @Override
        public SourceElement set(int index, SourceElement parent) {
            if (this.parents.contains(parent) && !this.parents.get(index).equals(parent)) {
                throw new IllegalArgumentException("Element " + String.valueOf(parent) + " is already a parent of " + String.valueOf(this.sourceElement));
            }
            SourceElement previousParent = this.parents.set(index, parent);
            previousParent.getChildren().remove(this.sourceElement);
            List<SourceElement> children = parent.getChildren();
            if (!children.contains(this.sourceElement)) {
                children.add(this.sourceElement);
            }
            return previousParent;
        }
    }

    private static class ChildList
    extends AbstractList<SourceElement> {
        private final SourceElement sourceElement;
        private final List<SourceElement> children = new ArrayList<SourceElement>();

        public ChildList(SourceElement sourceElement) {
            if (sourceElement == null) {
                throw new NullPointerException("sourceElement must not be null");
            }
            this.sourceElement = sourceElement;
        }

        @Override
        public SourceElement get(int index) {
            return this.children.get(index);
        }

        @Override
        public int size() {
            return this.children.size();
        }

        @Override
        public void add(int position, SourceElement child) {
            if (this.children.contains(child)) {
                throw new IllegalArgumentException("Element " + String.valueOf(child) + " is already a child of " + String.valueOf(this.sourceElement));
            }
            this.children.add(position, child);
            List<SourceElement> parents = child.getParents();
            if (!parents.contains(this.sourceElement)) {
                parents.add(this.sourceElement);
            }
        }

        @Override
        public SourceElement remove(int index) {
            SourceElement result = this.children.remove(index);
            result.getParents().remove(this.sourceElement);
            return result;
        }

        @Override
        public SourceElement set(int index, SourceElement child) {
            if (this.children.contains(child) && !this.children.get(index).equals(child)) {
                throw new IllegalArgumentException("Element " + String.valueOf(child) + " is already a child of " + String.valueOf(this.sourceElement));
            }
            SourceElement previousChild = this.children.set(index, child);
            previousChild.getParents().remove(this.sourceElement);
            List<SourceElement> parents = child.getParents();
            if (!parents.contains(this.sourceElement)) {
                parents.add(this.sourceElement);
            }
            return previousChild;
        }
    }
}

