/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.sql.Connection;
import java.util.List;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.ObjectModel;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.BasePeerImpl;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class AbstractPeerImpl<T extends ObjectModel>
extends BasePeerImpl<T> {
    private static final long serialVersionUID = 1236684692145864194L;

    public AbstractPeerImpl() {
    }

    public AbstractPeerImpl(RecordMapper<T> recordMapper, TableMap tableMap, String databaseName) {
        super(recordMapper, tableMap, databaseName);
    }

    public abstract Criteria buildCriteria(T var1);

    public abstract Criteria buildSelectCriteria(T var1);

    public Criteria buildCriteria(ObjectKey<?> pk) {
        throw new RuntimeException("buildCriteria(ObjectKey) called on table without primary key");
    }

    public abstract ColumnValues buildColumnValues(T var1) throws TorqueException;

    public List<T> doSelect(T obj) throws TorqueException {
        return this.doSelect((T)this.buildSelectCriteria(obj));
    }

    public T doSelectSingleRecord(T obj) throws TorqueException {
        List<T> omList = this.doSelect(obj);
        ObjectModel om = null;
        if (omList.size() > 1) {
            throw new TooManyRowsException("Object " + String.valueOf(obj) + " matched more than one record");
        }
        if (!omList.isEmpty()) {
            om = (ObjectModel)omList.get(0);
        }
        return (T)om;
    }

    @Override
    public ObjectKey<?> doInsert(ColumnValues columnValues, Connection con) throws TorqueException {
        this.correctBooleans(columnValues);
        return super.doInsert(columnValues, con);
    }

    public void doInsert(T obj) throws TorqueException {
        ObjectKey<?> primaryKey = this.doInsert(this.buildColumnValues(obj));
        if (primaryKey != null) {
            obj.setPrimaryKey(primaryKey);
        }
        obj.setNew(false);
        obj.setModified(false);
    }

    public void doInsert(T obj, Connection con) throws TorqueException {
        ObjectKey<?> primaryKey = this.doInsert(this.buildColumnValues(obj), con);
        if (primaryKey != null) {
            obj.setPrimaryKey(primaryKey);
        }
        obj.setNew(false);
        obj.setModified(false);
    }

    public int doUpdate(T obj) throws TorqueException {
        ColumnValues columnValues = this.buildColumnValues(obj);
        int result = this.doUpdate((T)columnValues);
        obj.setModified(false);
        return result;
    }

    public int doUpdate(T obj, Connection con) throws TorqueException {
        ColumnValues columnValues = this.buildColumnValues(obj);
        int result = this.doUpdate((T)columnValues, con);
        obj.setModified(false);
        return result;
    }

    public int doDelete(ObjectKey<?> pk) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin(this.getDatabaseName());){
            int deletedRows = this.doDelete(pk, (Connection)connection);
            Transaction.commit(connection);
            int n = deletedRows;
            return n;
        }
    }

    public int doDelete(ObjectKey<?> pk, Connection con) throws TorqueException {
        return this.doDelete(this.buildCriteria(pk), con);
    }
}

