/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs.preferences;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyEvent;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.Messages;
import org.apache.directory.studio.ldapbrowser.common.widgets.BinaryEncodingInput;
import org.apache.directory.studio.ldapbrowser.common.widgets.FileEncodingInput;
import org.apache.directory.studio.ldapbrowser.common.widgets.LineSeparatorInput;
import org.apache.directory.studio.ldapbrowser.common.widgets.OptionsInput;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TextFormatsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
WidgetModifyListener,
ModifyListener {
    public static final String LDIF_TAB = "LDIF";
    public static final String CSV_TAB = "CSV";
    public static final String XLS_TAB = "XLS";
    public static final String ODF_TAB = "ODF";
    public static final String TABLE_TAB = "TABLE";
    private Preferences coreStore = BrowserCorePlugin.getDefault().getPluginPreferences();
    private TabFolder tabFolder;
    private TabItem ldifTab;
    private TabItem tableTab;
    private TabItem csvTab;
    private TabItem xlsTab;
    private TabItem odfTab;
    private Text ldifLineLengthText;
    private Button ldifSpaceAfterColonButton;
    private Button includeVersionLineButton;
    private LineSeparatorInput ldifLineSeparator;
    private OptionsInput tableAttributeDelimiterWidget;
    private OptionsInput tableValueDelimiterWidget;
    private OptionsInput tableQuoteWidget;
    private LineSeparatorInput tableLineSeparator;
    private BinaryEncodingInput tableBinaryEncodingWidget;
    private OptionsInput csvAttributeDelimiterWidget;
    private OptionsInput csvValueDelimiterWidget;
    private OptionsInput csvQuoteWidget;
    private LineSeparatorInput csvLineSeparator;
    private BinaryEncodingInput csvBinaryEncodingWidget;
    private FileEncodingInput csvEncodingWidget;
    private OptionsInput xlsValueDelimiterWidget;
    private OptionsInput xlsBinaryEncodingWidget;
    private OptionsInput odfValueDelimiterWidget;
    private OptionsInput odfBinaryEncodingWidget;

    public TextFormatsPreferencePage() {
        super(Messages.getString("TextFormatsPreferencePage.TextFormats"));
        super.setPreferenceStore(BrowserCommonActivator.getDefault().getPreferenceStore());
        super.setDescription(Messages.getString("TextFormatsPreferencePage.SettingsForTextFormats"));
    }

    public void init(IWorkbench workbench) {
    }

    public void applyData(Object data) {
        if (data != null && this.tabFolder != null) {
            if (LDIF_TAB.equals(data)) {
                this.tabFolder.setSelection(0);
            } else if (TABLE_TAB.equals(data)) {
                this.tabFolder.setSelection(1);
            } else if (CSV_TAB.equals(data)) {
                this.tabFolder.setSelection(2);
            } else if (XLS_TAB.equals(data)) {
                this.tabFolder.setSelection(3);
            } else if (ODF_TAB.equals(data)) {
                this.tabFolder.setSelection(4);
            }
        }
    }

    protected Control createContents(Composite parent) {
        BaseWidgetUtils.createSpacer((Composite)parent, (int)1);
        this.tabFolder = new TabFolder(parent, 128);
        this.createLdifTab();
        this.createTableTab();
        this.createCsvTab();
        this.createXlsTab();
        this.createOdfTab();
        this.validate();
        this.applyDialogFont((Composite)this.tabFolder);
        return this.tabFolder;
    }

    private void createTableTab() {
        this.tableTab = new TabItem(this.tabFolder, 0);
        this.tableTab.setText(Messages.getString("TextFormatsPreferencePage.CSVCopy"));
        Composite tableComposite = new Composite((Composite)this.tabFolder, 0);
        tableComposite.setLayout((Layout)new GridLayout(1, false));
        Composite tableInnerComposite = BaseWidgetUtils.createColumnContainer((Composite)tableComposite, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)tableInnerComposite, (String)Messages.getString("TextFormatsPreferencePage.CSVCopyLabel"), (int)3);
        BaseWidgetUtils.createSpacer((Composite)tableInnerComposite, (int)3);
        this.tableAttributeDelimiterWidget = new OptionsInput(Messages.getString("TextFormatsPreferencePage.AttributeDelimiter"), Messages.getString("TextFormatsPreferencePage.Tabulator"), "\t", new String[]{Messages.getString("TextFormatsPreferencePage.Tabulator"), Messages.getString("TextFormatsPreferencePage.Comma"), Messages.getString("TextFormatsPreferencePage.Semicolon")}, new String[]{"\t", ",", ";"}, this.getPreferenceStore().getString("formatTableAttributeDelimiter"), false, true);
        this.tableAttributeDelimiterWidget.createWidget(tableInnerComposite);
        this.tableAttributeDelimiterWidget.addWidgetModifyListener(this);
        this.tableValueDelimiterWidget = new OptionsInput(Messages.getString("TextFormatsPreferencePage.ValueDelimiter"), Messages.getString("TextFormatsPreferencePage.Pipe"), "|", new String[]{Messages.getString("TextFormatsPreferencePage.Pipe"), Messages.getString("TextFormatsPreferencePage.Comma"), Messages.getString("TextFormatsPreferencePage.Semicolon"), Messages.getString("TextFormatsPreferencePage.Newline")}, new String[]{"|", ",", ";", "\n"}, this.getPreferenceStore().getString("formatTableValueDelimiter"), false, true);
        this.tableValueDelimiterWidget.createWidget(tableInnerComposite);
        this.tableValueDelimiterWidget.addWidgetModifyListener(this);
        this.tableQuoteWidget = new OptionsInput(Messages.getString("TextFormatsPreferencePage.QuoteCharacter"), Messages.getString("TextFormatsPreferencePage.DoubleQuote"), "\"", new String[]{Messages.getString("TextFormatsPreferencePage.DoubleQuote"), Messages.getString("TextFormatsPreferencePage.SingleQuote")}, new String[]{"\"", "'"}, this.getPreferenceStore().getString("formatTableQuoteCharacter"), false, true);
        this.tableQuoteWidget.createWidget(tableInnerComposite);
        this.tableQuoteWidget.addWidgetModifyListener(this);
        this.tableLineSeparator = new LineSeparatorInput(this.getPreferenceStore().getString("formatTableLineSeparator"), false);
        this.tableLineSeparator.createWidget(tableInnerComposite);
        this.tableLineSeparator.addWidgetModifyListener(this);
        this.tableBinaryEncodingWidget = new BinaryEncodingInput(this.getPreferenceStore().getString("formatTableBinaryEncoding"), false);
        this.tableBinaryEncodingWidget.createWidget(tableInnerComposite);
        this.tableBinaryEncodingWidget.addWidgetModifyListener(this);
        Composite copyTableHintComposite = BaseWidgetUtils.createColumnContainer((Composite)tableInnerComposite, (int)3, (int)3);
        Text hintText = BaseWidgetUtils.createWrappedLabeledText((Composite)copyTableHintComposite, (String)Messages.getString("TextFormatsPreferencePage.CSVCopyHint"), (int)1);
        GridData hintTextGridData = new GridData(4, 0, true, false);
        hintTextGridData.widthHint = 300;
        hintText.setLayoutData((Object)hintTextGridData);
        this.tableTab.setControl((Control)tableComposite);
    }

    private void createCsvTab() {
        this.csvTab = new TabItem(this.tabFolder, 0);
        this.csvTab.setText(Messages.getString("TextFormatsPreferencePage.CSVExport"));
        Composite csvComposite = new Composite((Composite)this.tabFolder, 0);
        csvComposite.setLayout((Layout)new GridLayout(1, false));
        Composite csvInnerComposite = BaseWidgetUtils.createColumnContainer((Composite)csvComposite, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)csvInnerComposite, (String)Messages.getString("TextFormatsPreferencePage.CSVExportLabel"), (int)3);
        BaseWidgetUtils.createSpacer((Composite)csvInnerComposite, (int)3);
        this.csvAttributeDelimiterWidget = new OptionsInput(Messages.getString("TextFormatsPreferencePage.AttributeDelimiter"), Messages.getString("TextFormatsPreferencePage.Comma"), ",", new String[]{Messages.getString("TextFormatsPreferencePage.Comma"), Messages.getString("TextFormatsPreferencePage.Semicolon"), Messages.getString("TextFormatsPreferencePage.Tabulator")}, new String[]{",", ";", "\t"}, this.coreStore.getString("formatCsvAttributeDelimiter"), false, true);
        this.csvAttributeDelimiterWidget.createWidget(csvInnerComposite);
        this.csvAttributeDelimiterWidget.addWidgetModifyListener(this);
        this.csvValueDelimiterWidget = new OptionsInput(Messages.getString("TextFormatsPreferencePage.ValueDelimiter"), Messages.getString("TextFormatsPreferencePage.Pipe"), "|", new String[]{Messages.getString("TextFormatsPreferencePage.Pipe"), Messages.getString("TextFormatsPreferencePage.Comma"), Messages.getString("TextFormatsPreferencePage.Semicolon"), Messages.getString("TextFormatsPreferencePage.Newline")}, new String[]{"|", ",", ";", "\n"}, this.coreStore.getString("formatCsvValueDelimiter"), false, true);
        this.csvValueDelimiterWidget.createWidget(csvInnerComposite);
        this.csvValueDelimiterWidget.addWidgetModifyListener(this);
        this.csvQuoteWidget = new OptionsInput(Messages.getString("TextFormatsPreferencePage.QuoteCharacter"), Messages.getString("TextFormatsPreferencePage.DoubleQuote"), "\"", new String[]{Messages.getString("TextFormatsPreferencePage.DoubleQuote"), Messages.getString("TextFormatsPreferencePage.SingleQuote")}, new String[]{"\"", "'"}, this.coreStore.getString("formatCsvQuoteCharacter"), false, true);
        this.csvQuoteWidget.createWidget(csvInnerComposite);
        this.csvQuoteWidget.addWidgetModifyListener(this);
        this.csvLineSeparator = new LineSeparatorInput(this.coreStore.getString("formatCsvLineSeparator"), false);
        this.csvLineSeparator.createWidget(csvInnerComposite);
        this.csvLineSeparator.addWidgetModifyListener(this);
        this.csvBinaryEncodingWidget = new BinaryEncodingInput(this.coreStore.getString("formatCsvBinaryEncoding"), false);
        this.csvBinaryEncodingWidget.createWidget(csvInnerComposite);
        this.csvBinaryEncodingWidget.addWidgetModifyListener(this);
        this.csvEncodingWidget = new FileEncodingInput(this.coreStore.getString("formatCsvEncoding"), false);
        this.csvEncodingWidget.createWidget(csvInnerComposite);
        this.csvEncodingWidget.addWidgetModifyListener(this);
        this.csvTab.setControl((Control)csvComposite);
    }

    private void createXlsTab() {
        this.xlsTab = new TabItem(this.tabFolder, 0);
        this.xlsTab.setText(Messages.getString("TextFormatsPreferencePage.ExcelExport"));
        Composite xlsComposite = new Composite((Composite)this.tabFolder, 0);
        xlsComposite.setLayout((Layout)new GridLayout(1, false));
        Composite xlsInnerComposite = BaseWidgetUtils.createColumnContainer((Composite)xlsComposite, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)xlsInnerComposite, (String)Messages.getString("TextFormatsPreferencePage.ExcelExportLabel"), (int)3);
        BaseWidgetUtils.createSpacer((Composite)xlsInnerComposite, (int)3);
        this.xlsValueDelimiterWidget = new OptionsInput(Messages.getString("TextFormatsPreferencePage.ValueDelimiter"), Messages.getString("TextFormatsPreferencePage.Pipe"), "|", new String[]{Messages.getString("TextFormatsPreferencePage.Pipe"), Messages.getString("TextFormatsPreferencePage.Comma"), Messages.getString("TextFormatsPreferencePage.Semicolon"), Messages.getString("TextFormatsPreferencePage.Newline")}, new String[]{"|", ",", ";", "\n"}, this.coreStore.getString("formatXlsValueDelimiter"), false, true);
        this.xlsValueDelimiterWidget.createWidget(xlsInnerComposite);
        this.xlsValueDelimiterWidget.addWidgetModifyListener(this);
        this.xlsBinaryEncodingWidget = new BinaryEncodingInput(this.coreStore.getString("formatXlsBinaryEncoding"), false);
        this.xlsBinaryEncodingWidget.createWidget(xlsInnerComposite);
        this.xlsBinaryEncodingWidget.addWidgetModifyListener(this);
        this.xlsTab.setControl((Control)xlsComposite);
    }

    private void createOdfTab() {
        this.odfTab = new TabItem(this.tabFolder, 0);
        this.odfTab.setText(Messages.getString("TextFormatsPreferencePage.OdfExport"));
        Composite odfComposite = new Composite((Composite)this.tabFolder, 0);
        odfComposite.setLayout((Layout)new GridLayout(1, false));
        Composite odfInnerComposite = BaseWidgetUtils.createColumnContainer((Composite)odfComposite, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)odfInnerComposite, (String)Messages.getString("TextFormatsPreferencePage.OdfExportLabel"), (int)3);
        BaseWidgetUtils.createSpacer((Composite)odfInnerComposite, (int)3);
        this.odfValueDelimiterWidget = new OptionsInput(Messages.getString("TextFormatsPreferencePage.ValueDelimiter"), Messages.getString("TextFormatsPreferencePage.Pipe"), "|", new String[]{Messages.getString("TextFormatsPreferencePage.Pipe"), Messages.getString("TextFormatsPreferencePage.Comma"), Messages.getString("TextFormatsPreferencePage.Semicolon"), Messages.getString("TextFormatsPreferencePage.Newline")}, new String[]{"|", ",", ";", "\n"}, this.coreStore.getString("formatOdfValueDelimiter"), false, true);
        this.odfValueDelimiterWidget.createWidget(odfInnerComposite);
        this.odfValueDelimiterWidget.addWidgetModifyListener(this);
        this.odfBinaryEncodingWidget = new BinaryEncodingInput(this.coreStore.getString("formatOdfBinaryEncoding"), false);
        this.odfBinaryEncodingWidget.createWidget(odfInnerComposite);
        this.odfBinaryEncodingWidget.addWidgetModifyListener(this);
        this.odfTab.setControl((Control)odfComposite);
    }

    private void createLdifTab() {
        this.ldifTab = new TabItem(this.tabFolder, 0);
        this.ldifTab.setText(Messages.getString("TextFormatsPreferencePage.LDIF"));
        Composite ldifComposite = new Composite((Composite)this.tabFolder, 0);
        ldifComposite.setLayout((Layout)new GridLayout(1, false));
        Composite ldifInnerComposite = BaseWidgetUtils.createColumnContainer((Composite)ldifComposite, (int)1, (int)1);
        BaseWidgetUtils.createLabel((Composite)ldifInnerComposite, (String)Messages.getString("TextFormatsPreferencePage.LDIFLabel"), (int)1);
        BaseWidgetUtils.createSpacer((Composite)ldifInnerComposite, (int)1);
        this.ldifLineSeparator = new LineSeparatorInput(this.coreStore.getString("ldifLineSeparator"), true);
        this.ldifLineSeparator.createWidget(ldifInnerComposite);
        this.ldifLineSeparator.addWidgetModifyListener(this);
        BaseWidgetUtils.createSpacer((Composite)ldifInnerComposite, (int)1);
        Composite lineLengthComposite = BaseWidgetUtils.createColumnContainer((Composite)ldifInnerComposite, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)lineLengthComposite, (String)Messages.getString("TextFormatsPreferencePage.LineLength1"), (int)1);
        this.ldifLineLengthText = BaseWidgetUtils.createText((Composite)lineLengthComposite, (String)"", (int)3, (int)1);
        this.ldifLineLengthText.setText(this.coreStore.getString("ldifLineWidth"));
        this.ldifLineLengthText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
                if ("".equals(TextFormatsPreferencePage.this.ldifLineLengthText.getText()) && e.text.matches("[0]")) {
                    e.doit = false;
                }
            }
        });
        this.ldifLineLengthText.addModifyListener((ModifyListener)this);
        BaseWidgetUtils.createLabel((Composite)lineLengthComposite, (String)Messages.getString("TextFormatsPreferencePage.LineLength2"), (int)1);
        this.ldifSpaceAfterColonButton = BaseWidgetUtils.createCheckbox((Composite)ldifInnerComposite, (String)Messages.getString("TextFormatsPreferencePage.SpaceAfterColon"), (int)1);
        this.ldifSpaceAfterColonButton.setSelection(this.coreStore.getBoolean("ldifSpaceAfterColon"));
        this.includeVersionLineButton = BaseWidgetUtils.createCheckbox((Composite)ldifInnerComposite, (String)Messages.getString("TextFormatsPreferencePage.IncludeVersionLine"), (int)1);
        this.includeVersionLineButton.setSelection(this.coreStore.getBoolean("ldifIncludeVersionLine"));
        this.ldifTab.setControl((Control)ldifComposite);
    }

    public boolean performOk() {
        this.coreStore.setValue("ldifLineWidth", this.ldifLineLengthText.getText());
        this.coreStore.setValue("ldifLineSeparator", this.ldifLineSeparator.getRawValue());
        this.coreStore.setValue("ldifSpaceAfterColon", this.ldifSpaceAfterColonButton.getSelection());
        this.coreStore.setValue("ldifIncludeVersionLine", this.includeVersionLineButton.getSelection());
        this.coreStore.setValue("formatCsvAttributeDelimiter", this.csvAttributeDelimiterWidget.getRawValue());
        this.coreStore.setValue("formatCsvValueDelimiter", this.csvValueDelimiterWidget.getRawValue());
        this.coreStore.setValue("formatCsvQuoteCharacter", this.csvQuoteWidget.getRawValue());
        this.coreStore.setValue("formatCsvLineSeparator", this.csvLineSeparator.getRawValue());
        this.coreStore.setValue("formatCsvBinaryEncoding", this.csvBinaryEncodingWidget.getRawValue());
        this.coreStore.setValue("formatCsvEncoding", this.csvEncodingWidget.getRawValue());
        this.getPreferenceStore().setValue("formatTableAttributeDelimiter", this.tableAttributeDelimiterWidget.getRawValue());
        this.getPreferenceStore().setValue("formatTableValueDelimiter", this.tableValueDelimiterWidget.getRawValue());
        this.getPreferenceStore().setValue("formatTableQuoteCharacter", this.tableQuoteWidget.getRawValue());
        this.getPreferenceStore().setValue("formatTableLineSeparator", this.tableLineSeparator.getRawValue());
        this.getPreferenceStore().setValue("formatTableBinaryEncoding", this.tableBinaryEncodingWidget.getRawValue());
        this.coreStore.setValue("formatXlsValueDelimiter", this.xlsValueDelimiterWidget.getRawValue());
        this.coreStore.setValue("formatXlsBinaryEncoding", this.xlsBinaryEncodingWidget.getRawValue());
        BrowserCorePlugin.getDefault().savePluginPreferences();
        this.validate();
        return true;
    }

    protected void performDefaults() {
        this.ldifLineLengthText.setText(this.coreStore.getDefaultString("ldifLineWidth"));
        this.ldifLineSeparator.setRawValue(this.coreStore.getDefaultString("ldifLineSeparator"));
        this.ldifSpaceAfterColonButton.setSelection(this.coreStore.getDefaultBoolean("ldifSpaceAfterColon"));
        this.includeVersionLineButton.setSelection(this.coreStore.getDefaultBoolean("ldifIncludeVersionLine"));
        this.csvAttributeDelimiterWidget.setRawValue(this.coreStore.getDefaultString("formatCsvAttributeDelimiter"));
        this.csvValueDelimiterWidget.setRawValue(this.coreStore.getDefaultString("formatCsvValueDelimiter"));
        this.csvQuoteWidget.setRawValue(this.coreStore.getDefaultString("formatCsvQuoteCharacter"));
        this.csvLineSeparator.setRawValue(this.coreStore.getDefaultString("formatCsvLineSeparator"));
        this.csvBinaryEncodingWidget.setRawValue(this.coreStore.getDefaultString("formatCsvBinaryEncoding"));
        this.csvEncodingWidget.setRawValue(this.coreStore.getDefaultString("formatCsvEncoding"));
        this.tableAttributeDelimiterWidget.setRawValue(this.getPreferenceStore().getDefaultString("formatTableAttributeDelimiter"));
        this.tableValueDelimiterWidget.setRawValue(this.getPreferenceStore().getDefaultString("formatTableValueDelimiter"));
        this.tableQuoteWidget.setRawValue(this.getPreferenceStore().getDefaultString("formatTableQuoteCharacter"));
        this.tableLineSeparator.setRawValue(this.getPreferenceStore().getDefaultString("formatTableLineSeparator"));
        this.tableBinaryEncodingWidget.setRawValue(this.getPreferenceStore().getDefaultString("formatTableBinaryEncoding"));
        this.xlsValueDelimiterWidget.setRawValue(this.coreStore.getDefaultString("formatXlsValueDelimiter"));
        this.xlsBinaryEncodingWidget.setRawValue(this.coreStore.getDefaultString("formatXlsBinaryEncoding"));
        this.validate();
        super.performDefaults();
    }

    public void widgetModified(WidgetModifyEvent event) {
        this.validate();
    }

    public void modifyText(ModifyEvent e) {
        this.validate();
    }

    protected void validate() {
        this.setValid(!"".equals(this.csvAttributeDelimiterWidget.getRawValue()) && !"".equals(this.csvValueDelimiterWidget.getRawValue()) && !"".equals(this.csvQuoteWidget.getRawValue()) && !"".equals(this.csvLineSeparator.getRawValue()) && !"".equals(this.csvBinaryEncodingWidget.getRawValue()) && !"".equals(this.csvEncodingWidget.getRawValue()) && !"".equals(this.tableAttributeDelimiterWidget.getRawValue()) && !"".equals(this.tableValueDelimiterWidget.getRawValue()) && !"".equals(this.tableQuoteWidget.getRawValue()) && !"".equals(this.tableLineSeparator.getRawValue()) && !"".equals(this.tableBinaryEncodingWidget.getRawValue()) && !"".equals(this.xlsValueDelimiterWidget.getRawValue()) && !"".equals(this.xlsBinaryEncodingWidget.getRawValue()) && !"".equals(this.ldifLineLengthText.getText()) && !"".equals(this.ldifLineSeparator.getRawValue()));
    }
}

