/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.core;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class AntClassLoader
extends URLClassLoader {
    private static final String ANT_PACKAGES_PREFIX = "org.apache.tools";
    private static final String ANT_URL_PREFIX = "org/apache/tools";
    private boolean fAllowPluginLoading = false;
    protected ClassLoader[] fPluginLoaders;
    private ClassLoader fContextClassloader = null;

    public AntClassLoader(URL[] urls, ClassLoader[] pluginLoaders) {
        super(urls, ClassLoader.getSystemClassLoader());
        this.fPluginLoaders = pluginLoaders;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        if (this.fAllowPluginLoading || !name.startsWith(ANT_PACKAGES_PREFIX)) {
            result = this.loadClassPlugins(name);
        }
        if (result != null) {
            return result;
        }
        return super.findClass(name);
    }

    protected Class<?> loadClassPlugins(String name) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.fContextClassloader != null) {
            Thread.currentThread().setContextClassLoader(this.fContextClassloader);
        }
        try {
            Class<?> result = null;
            if (this.fPluginLoaders != null) {
                int i = 0;
                while (i < this.fPluginLoaders.length && result == null) {
                    try {
                        result = this.fPluginLoaders[i].loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    ++i;
                }
            }
            Class<?> clazz = result;
            return clazz;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    @Override
    public URL findResource(String name) {
        URL result;
        if ((this.fAllowPluginLoading || !name.startsWith(ANT_URL_PREFIX)) && (result = this.findResourcePlugins(name)) != null) {
            return result;
        }
        return super.findResource(name);
    }

    private URL findResourcePlugins(String name) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.fContextClassloader != null) {
            Thread.currentThread().setContextClassLoader(this.fContextClassloader);
        }
        try {
            URL result = null;
            if (this.fPluginLoaders != null) {
                ClassLoader[] classLoaderArray = this.fPluginLoaders;
                int n = this.fPluginLoaders.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassLoader loader = classLoaderArray[n2];
                    result = loader.getResource(name);
                    if (result != null) {
                        URL uRL = result;
                        return uRL;
                    }
                    ++n2;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.fContextClassloader != null) {
            Thread.currentThread().setContextClassLoader(this.fContextClassloader);
        }
        all = new ArrayList<URL>();
        try {
            if (!this.fAllowPluginLoading && (name.startsWith("org/apache/tools") || name.startsWith("org/apache/tools", 1)) || this.fPluginLoaders == null) ** GOTO lbl16
            result = null;
            var8_5 = this.fPluginLoaders;
            var7_6 = this.fPluginLoaders.length;
            var6_7 = 0;
lbl11:
            // 2 sources

            while (true) {
                block8: {
                    if (var6_7 >= var7_6) break block8;
                    loader = var8_5[var6_7];
                    result = loader.getResources(name);
                    if (true) ** GOTO lbl29
                }
                superResources = super.findResources(name);
                if (all.isEmpty()) {
                    var10_9 = superResources;
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                    return var10_9;
                }
                ** GOTO lbl34
                break;
            }
        }
        catch (Throwable var9_11) {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            throw var9_11;
        }
        do {
            all.add(result.nextElement());
lbl29:
            // 2 sources

        } while (result.hasMoreElements());
        ++var6_7;
        ** while (true)
lbl-1000:
        // 1 sources

        {
            all.add(superResources.nextElement());
lbl34:
            // 2 sources

            ** while (superResources.hasMoreElements())
        }
lbl35:
        // 1 sources

        var10_10 = Collections.enumeration(all);
        Thread.currentThread().setContextClassLoader(originalClassLoader);
        return var10_10;
    }

    public void allowPluginClassLoadersToLoadAnt(boolean allowLoading) {
        this.fAllowPluginLoading = allowLoading;
    }

    public void setPluginContextClassloader(ClassLoader classLoader) {
        this.fContextClassloader = classLoader;
    }
}

