/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ISelectionConversionService;
import org.eclipse.ui.internal.PluginActionBuilder;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDESelectionConversionService;
import org.eclipse.ui.internal.ide.IDEWorkbenchActivityHelper;
import org.eclipse.ui.internal.ide.IDEWorkbenchErrorHandler;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.application.DelayedEventsProcessor;
import org.eclipse.ui.internal.ide.application.IDEWorkbenchWindowAdvisor;
import org.eclipse.ui.internal.ide.undo.WorkspaceUndoMonitor;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.urischeme.AutoRegisterSchemeHandlersJob;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class IDEWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final String WORKBENCH_PREFERENCE_CATEGORY_ID = "org.eclipse.ui.preferencePages.Workbench";
    private static final String INSTALLED_FEATURES = "installedFeatures";
    private static IDEWorkbenchAdvisor workbenchAdvisor = null;
    private Map<String, AboutInfo> newlyAddedBundleGroups;
    private AboutInfo[] welcomePerspectiveInfos = null;
    private IDEWorkbenchActivityHelper activityHelper = null;
    private Listener settingsChangeListener;
    private WorkspaceUndoMonitor workspaceUndoMonitor;
    private AbstractStatusHandler ideWorkbenchErrorHandler;
    private final DelayedEventsProcessor delayedEventsProcessor;
    private static boolean jfaceComparatorIsSet = false;
    private final int workspaceWaitDelay;
    private final Listener closeListener = event -> {
        boolean doExit;
        event.doit = doExit = IDEWorkbenchWindowAdvisor.promptOnExit(null);
        if (!doExit) {
            event.type = 0;
        }
    };

    public IDEWorkbenchAdvisor() {
        this(1000, null);
    }

    IDEWorkbenchAdvisor(int workspaceWaitDelay, DelayedEventsProcessor processor) {
        this.workspaceWaitDelay = workspaceWaitDelay;
        if (workbenchAdvisor != null) {
            throw new IllegalStateException();
        }
        workbenchAdvisor = this;
        this.delayedEventsProcessor = processor;
        Display.getDefault().addListener(21, this.closeListener);
    }

    public IDEWorkbenchAdvisor(DelayedEventsProcessor processor) {
        this(1000, processor);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        PluginActionBuilder.setAllowIdeLogging((boolean)true);
        configurer.setSaveAndRestore(true);
        IDE.registerAdapters();
        this.declareWorkbenchImages();
        this.activityHelper = IDEWorkbenchActivityHelper.getInstance();
        this.workspaceUndoMonitor = WorkspaceUndoMonitor.getInstance();
        TrayDialog.setDialogHelpAvailable((boolean)true);
        IDEWorkbenchAdvisor.setWorkspaceNameDefault();
        if (!jfaceComparatorIsSet) {
            Policy.setComparator((Comparator)Collator.getInstance());
            jfaceComparatorIsSet = true;
        }
        new AutoRegisterSchemeHandlersJob().schedule();
    }

    public void preStartup() {
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        ImageDescriptor newImage = IDEInternalWorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_BUILD_EXEC");
        service.registerIconForFamily(newImage, ResourcesPlugin.FAMILY_MANUAL_BUILD);
        service.registerIconForFamily(newImage, ResourcesPlugin.FAMILY_AUTO_BUILD);
    }

    public void postStartup() {
        try {
            this.refreshFromLocal();
            this.activateProxyService();
            ((Workbench)PlatformUI.getWorkbench()).registerService(ISelectionConversionService.class, (Object)new IDESelectionConversionService());
            this.initializeSettingsChangeListener();
            Display.getCurrent().addListener(39, this.settingsChangeListener);
        }
        finally {
            Job.getJobManager().resume();
        }
    }

    private void activateProxyService() {
        ServiceReference ref;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        Object proxyService = null;
        if (bundle != null && (ref = bundle.getBundleContext().getServiceReference(IProxyService.class)) != null) {
            proxyService = bundle.getBundleContext().getService(ref);
        }
        if (proxyService == null) {
            IDEWorkbenchPlugin.log((String)"Proxy service could not be found.");
        }
    }

    private void initializeSettingsChangeListener() {
        this.settingsChangeListener = new Listener(){
            boolean currentHighContrast = Display.getCurrent().getHighContrast();

            public void handleEvent(Event event) {
                if (Display.getCurrent().getHighContrast() == this.currentHighContrast) {
                    return;
                }
                boolean bl = this.currentHighContrast = !this.currentHighContrast;
                if (new MessageDialog(null, IDEWorkbenchMessages.SystemSettingsChange_title, null, IDEWorkbenchMessages.SystemSettingsChange_message, 3, 1, new String[]{IDEWorkbenchMessages.SystemSettingsChange_yes, IDEWorkbenchMessages.SystemSettingsChange_no}).open() == 0) {
                    PlatformUI.getWorkbench().restart();
                }
            }
        };
    }

    public void postShutdown() {
        Display.getDefault().removeListener(21, this.closeListener);
        if (this.activityHelper != null) {
            this.activityHelper.shutdown();
            this.activityHelper = null;
        }
        if (this.workspaceUndoMonitor != null) {
            this.workspaceUndoMonitor.shutdown();
            this.workspaceUndoMonitor = null;
        }
        final IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        Runnable disconnectFromWorkspace = new Runnable(){
            int attempts;

            @Override
            public void run() {
                if (IDEWorkbenchAdvisor.this.isWorkspaceLocked(workspace)) {
                    if (this.attempts < 3) {
                        ++this.attempts;
                        IDEWorkbenchPlugin.log(null, (IStatus)this.createErrorStatus("Workspace is locked, waiting..."));
                        Display.getCurrent().timerExec(IDEWorkbenchAdvisor.this.workspaceWaitDelay * this.attempts, (Runnable)this);
                    } else {
                        IDEWorkbenchPlugin.log(null, (IStatus)this.createErrorStatus("Workspace is locked and can't be saved."));
                    }
                    return;
                }
                IDEWorkbenchAdvisor.this.disconnectFromWorkspace();
            }

            IStatus createErrorStatus(String exceptionMessage) {
                return new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.ProblemsSavingWorkspace, (Throwable)new IllegalStateException(exceptionMessage));
            }
        };
        if (workspace != null) {
            if (this.isWorkspaceLocked(workspace)) {
                Display.getCurrent().asyncExec(disconnectFromWorkspace);
            } else {
                disconnectFromWorkspace.run();
            }
        }
        workbenchAdvisor = null;
    }

    private boolean isWorkspaceLocked(IWorkspace workspace) {
        ISchedulingRule currentRule = Job.getJobManager().currentRule();
        return currentRule != null && currentRule.isConflicting((ISchedulingRule)workspace.getRoot());
    }

    public boolean preShutdown() {
        Display.getCurrent().removeListener(39, this.settingsChangeListener);
        return super.preShutdown();
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new IDEWorkbenchWindowAdvisor(this, configurer);
    }

    public boolean hasIntro() {
        return this.getWorkbenchConfigurer().getWorkbench().getIntroManager().hasIntro();
    }

    private void refreshFromLocal() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean refresh = store.getBoolean("REFRESH_WORKSPACE_ON_STARTUP");
        if (!refresh) {
            return;
        }
        String[] stringArray = commandLineArgs;
        int n = commandLineArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String commandLineArg = stringArray[n2];
            if (commandLineArg.equalsIgnoreCase("-refresh")) {
                return;
            }
            ++n2;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        WorkspaceJob job = new WorkspaceJob(IDEWorkbenchMessages.Workspace_refreshing, (IContainer)root){
            private final /* synthetic */ IContainer val$root;
            {
                this.val$root = iContainer;
                super($anonymous0);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                this.val$root.refreshLocal(2, monitor);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)root);
        job.schedule();
    }

    private void disconnectFromWorkspace() {
        MultiStatus status = new MultiStatus("org.eclipse.ui.ide", 1, IDEWorkbenchMessages.ProblemSavingWorkbench);
        try {
            CancelableProgressMonitorJobsDialog p = new CancelableProgressMonitorJobsDialog(null);
            boolean applyPolicy = ResourcesPlugin.getWorkspace().getDescription().isApplyFileStatePolicy();
            IRunnableWithProgress runnable = monitor -> {
                try {
                    if (applyPolicy) {
                        monitor = new CancelableProgressMonitorWrapper(monitor, p);
                    }
                    status.merge(((Workspace)ResourcesPlugin.getWorkspace()).save(true, true, monitor));
                }
                catch (CoreException e) {
                    status.merge(e.getStatus());
                }
            };
            p.run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.InternalError, e.getTargetException()));
        }
        catch (InterruptedException e) {
            status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.InternalError, (Throwable)e));
        }
        ErrorDialog.openError(null, (String)IDEWorkbenchMessages.ProblemsSavingWorkspace, null, (IStatus)status, (int)6);
        if (!status.isOK()) {
            IDEWorkbenchPlugin.log((String)IDEWorkbenchMessages.ProblemsSavingWorkspace, (IStatus)status);
        }
    }

    public IAdaptable getDefaultPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public String getInitialWindowPerspectiveId() {
        int index = PlatformUI.getWorkbench().getWorkbenchWindowCount() - 1;
        String perspectiveId = null;
        AboutInfo[] welcomeInfos = this.getWelcomePerspectiveInfos();
        if (index >= 0 && welcomeInfos != null && index < welcomeInfos.length) {
            perspectiveId = welcomeInfos[index].getWelcomePerspectiveId();
        }
        if (perspectiveId == null) {
            perspectiveId = "org.eclipse.ui.resourcePerspective";
        }
        return perspectiveId;
    }

    private Map<String, AboutInfo> computeBundleGroupMap() {
        IBundleGroupProvider[] providers;
        TreeMap<String, AboutInfo> ids = new TreeMap<String, AboutInfo>();
        IBundleGroupProvider[] iBundleGroupProviderArray = providers = Platform.getBundleGroupProviders();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroup[] groups;
            IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
            IBundleGroup[] iBundleGroupArray = groups = provider.getBundleGroups();
            int n3 = groups.length;
            int n4 = 0;
            while (n4 < n3) {
                IBundleGroup group = iBundleGroupArray[n4];
                AboutInfo info = new AboutInfo(group);
                String version = info.getVersionId();
                version = version == null ? "0.0.0" : new Version(version).toString();
                String versionedFeature = String.valueOf(group.getIdentifier()) + ":" + version;
                ids.put(versionedFeature, info);
                ++n4;
            }
            ++n2;
        }
        return ids;
    }

    public Map<String, AboutInfo> getNewlyAddedBundleGroups() {
        if (this.newlyAddedBundleGroups == null) {
            this.newlyAddedBundleGroups = this.createNewBundleGroupsMap();
        }
        return this.newlyAddedBundleGroups;
    }

    private Map<String, AboutInfo> createNewBundleGroupsMap() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        String[] previousFeaturesArray = settings.getArray(INSTALLED_FEATURES);
        Map<String, AboutInfo> bundleGroups = this.computeBundleGroupMap();
        String[] currentFeaturesArray = new String[bundleGroups.size()];
        bundleGroups.keySet().toArray(currentFeaturesArray);
        settings.put(INSTALLED_FEATURES, currentFeaturesArray);
        if (previousFeaturesArray != null) {
            String[] stringArray = previousFeaturesArray;
            int n = previousFeaturesArray.length;
            int n2 = 0;
            while (n2 < n) {
                String previousFeature = stringArray[n2];
                bundleGroups.remove(previousFeature);
                ++n2;
            }
        }
        return bundleGroups;
    }

    private static void setWorkspaceNameDefault() {
        IPreferenceStore preferences = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String workspaceNameDefault = preferences.getDefaultString("WORKSPACE_NAME");
        if (workspaceNameDefault != null && !workspaceNameDefault.isEmpty()) {
            return;
        }
        IPath workspaceDir = Platform.getLocation();
        if (workspaceDir == null) {
            return;
        }
        String workspaceName = workspaceDir.lastSegment();
        if (workspaceName == null) {
            return;
        }
        preferences.setDefault("WORKSPACE_NAME", workspaceName);
    }

    private void declareWorkbenchImages() {
        Bundle ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC", "$nl$/icons/full/etool16/build_exec.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_HOVER", "$nl$/icons/full/etool16/build_exec.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_DISABLED", "$nl$/icons/full/dtool16/build_exec.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC", "$nl$/icons/full/etool16/search_src.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_HOVER", "$nl$/icons/full/etool16/search_src.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_DISABLED", "$nl$/icons/full/dtool16/search_src.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_NEXT_NAV", "$nl$/icons/full/etool16/next_nav.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PREVIOUS_NAV", "$nl$/icons/full/etool16/prev_nav.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWPRJ_WIZ", "$nl$/icons/full/wizban/newprj_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFOLDER_WIZ", "$nl$/icons/full/wizban/newfolder_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFILE_WIZ", "$nl$/icons/full/wizban/newfile_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTDIR_WIZ", "$nl$/icons/full/wizban/importdir_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTZIP_WIZ", "$nl$/icons/full/wizban/importzip_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTDIR_WIZ", "$nl$/icons/full/wizban/exportdir_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/exportzip_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/workset_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_DLGBAN_SAVEAS_DLG", "$nl$/icons/full/wizban/saveas_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_DLGBAN_QUICKFIX_DLG", "$nl$/icons/full/wizban/quick_fix.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT", "$nl$/icons/full/obj16/prj_obj.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT_CLOSED", "$nl$/icons/full/obj16/cprj_obj.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OPEN_MARKER", "$nl$/icons/full/elcl16/gotoobj_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ELCL_QUICK_FIX_ENABLED", "$nl$/icons/full/elcl16/smartmode_co.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_DLCL_QUICK_FIX_DISABLED", "$nl$/icons/full/dlcl16/smartmode_co.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_FIXABLE_WARNING", "$nl$/icons/full/obj16/quickfix_warning_obj.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_FIXABLE_ERROR", "$nl$/icons/full/obj16/quickfix_error_obj.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_FIXABLE_INFO", "$nl$/icons/full/obj16/quickfix_info_obj.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_TASK_TSK", "$nl$/icons/full/obj16/taskmrk_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_BKMRK_TSK", "$nl$/icons/full/obj16/bkmrk_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_COMPLETE_TSK", "$nl$/icons/full/obj16/complete_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INCOMPLETE_TSK", "$nl$/icons/full/obj16/incomplete_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_ITEM", "$nl$/icons/full/obj16/welcome_item.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_BANNER", "$nl$/icons/full/obj16/welcome_banner.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_ERROR_PATH", "$nl$/icons/full/obj16/error_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WARNING_PATH", "$nl$/icons/full/obj16/warn_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INFO_PATH", "$nl$/icons/full/obj16/info_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_LCL_FLAT_LAYOUT", "$nl$/icons/full/elcl16/flatLayout.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_LCL_HIERARCHICAL_LAYOUT", "$nl$/icons/full/elcl16/hierarchicalLayout.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEM_CATEGORY", "$nl$/icons/full/etool16/problem_category.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEMS_VIEW", "$nl$/icons/full/eview16/problems_view.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEMS_VIEW_ERROR", "$nl$/icons/full/eview16/problems_view_error.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEMS_VIEW_WARNING", "$nl$/icons/full/eview16/problems_view_warning.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEMS_VIEW_INFO", "$nl$/icons/full/eview16/problems_view_info.png", true);
    }

    private void declareWorkbenchImage(Bundle ideBundle, String symbolicName, String path, boolean shared) {
        URL url = FileLocator.find((Bundle)ideBundle, (IPath)new Path(path), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.getWorkbenchConfigurer().declareImage(symbolicName, desc, shared);
    }

    public String getMainPreferencePageId() {
        return WORKBENCH_PREFERENCE_CATEGORY_ID;
    }

    public String getCommandLineLocation() {
        IEclipseContext context = (IEclipseContext)this.getWorkbenchConfigurer().getWorkbench().getService(IEclipseContext.class);
        return context != null ? (String)context.get("forcedShowLocation") : null;
    }

    public String getWorkspaceLocation() {
        String location = this.getCommandLineLocation();
        if (location != null) {
            return location;
        }
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("SHOW_LOCATION")) {
            return Platform.getLocation().toOSString();
        }
        return null;
    }

    public AboutInfo[] getWelcomePerspectiveInfos() {
        if (this.welcomePerspectiveInfos == null && !this.hasIntro()) {
            Map<String, AboutInfo> m = this.getNewlyAddedBundleGroups();
            ArrayList<AboutInfo> list = new ArrayList<AboutInfo>(m.size());
            for (AboutInfo info : m.values()) {
                if (info == null || info.getWelcomePerspectiveId() == null || info.getWelcomePageURL() == null) continue;
                list.add(info);
            }
            this.welcomePerspectiveInfos = new AboutInfo[list.size()];
            list.toArray(this.welcomePerspectiveInfos);
        }
        return this.welcomePerspectiveInfos;
    }

    public synchronized AbstractStatusHandler getWorkbenchErrorHandler() {
        if (this.ideWorkbenchErrorHandler == null) {
            this.ideWorkbenchErrorHandler = new IDEWorkbenchErrorHandler(this.getWorkbenchConfigurer());
        }
        return this.ideWorkbenchErrorHandler;
    }

    public void eventLoopIdle(Display display) {
        if (this.delayedEventsProcessor != null) {
            this.delayedEventsProcessor.catchUp(display);
        }
        super.eventLoopIdle(display);
    }

    private static class CancelableProgressMonitorJobsDialog
    extends ProgressMonitorJobsDialog {
        public CancelableProgressMonitorJobsDialog(Shell parent) {
            super(parent);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.registerCancelButtonListener();
        }

        public void registerCancelButtonListener() {
            this.cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    subTaskLabel.setText("");
                }
            });
        }
    }

    private static class CancelableProgressMonitorWrapper
    extends ProgressMonitorWrapper {
        private double total = 0.0;
        private ProgressMonitorJobsDialog dialog;

        CancelableProgressMonitorWrapper(IProgressMonitor monitor, ProgressMonitorJobsDialog dialog) {
            super(monitor);
            this.dialog = dialog;
        }

        public void internalWorked(double work) {
            super.internalWorked(work);
            this.total += work;
            this.updateProgressDetails();
        }

        public void worked(int work) {
            super.worked(work);
            this.total += (double)work;
            this.updateProgressDetails();
        }

        public void beginTask(String name, int totalWork) {
            super.beginTask(name, totalWork);
            this.subTask(IDEWorkbenchMessages.IDEWorkbenchAdvisor_preHistoryCompaction);
        }

        private void updateProgressDetails() {
            if (!this.isCanceled() && Math.abs(this.total - 4.0) < 1.0E-4) {
                this.subTask(IDEWorkbenchMessages.IDEWorkbenchAdvisor_cancelHistoryPruning);
                this.dialog.setCancelable(true);
            }
            if (Math.abs(this.total - 5.0) < 1.0E-4) {
                this.subTask(IDEWorkbenchMessages.IDEWorkbenchAdvisor_postHistoryCompaction);
                this.dialog.setCancelable(false);
            }
        }
    }
}

