/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.actions;

import org.apache.directory.studio.ldifeditor.editor.LdifEditor;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractLdifAction
extends Action
implements IUpdate {
    protected LdifEditor editor;

    public AbstractLdifAction(String text, LdifEditor editor) {
        super(text);
        this.editor = editor;
    }

    public final void run() {
        if (this.isEnabled()) {
            this.doRun();
        }
    }

    protected abstract void doRun();

    public boolean isEnabled() {
        this.update();
        return super.isEnabled();
    }

    protected LdifFile getLdifModel() {
        LdifFile model = this.editor.getLdifModel();
        return model;
    }

    protected LdifContainer[] getSelectedLdifContainers() {
        LdifContainer[] containers = null;
        ISourceViewer sourceViewer = (ISourceViewer)this.editor.getAdapter(ISourceViewer.class);
        if (sourceViewer != null) {
            LdifFile model = this.editor.getLdifModel();
            Point selection = sourceViewer.getSelectedRange();
            containers = LdifFile.getContainers((LdifFile)model, (int)selection.x, (int)selection.y);
        }
        return containers != null ? containers : new LdifContainer[]{};
    }

    protected LdifPart[] getSelectedLdifParts() {
        LdifPart[] parts = null;
        ISourceViewer sourceViewer = (ISourceViewer)this.editor.getAdapter(ISourceViewer.class);
        if (sourceViewer != null) {
            LdifFile model = this.editor.getLdifModel();
            Point selection = sourceViewer.getSelectedRange();
            parts = LdifFile.getParts((LdifFile)model, (int)selection.x, (int)selection.y);
        }
        return parts != null ? parts : new LdifPart[]{};
    }

    protected LdifModSpec getSelectedLdifModSpec() {
        ISourceViewer sourceViewer;
        LdifModSpec modSpec = null;
        LdifContainer[] containers = this.getSelectedLdifContainers();
        if (containers.length == 1 && (sourceViewer = (ISourceViewer)this.editor.getAdapter(ISourceViewer.class)) != null) {
            Point selection = sourceViewer.getSelectedRange();
            modSpec = LdifFile.getInnerContainer((LdifContainer)containers[0], (int)selection.x);
        }
        return modSpec;
    }
}

